/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.metadata.FunctionInfo;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.ParametricScalar;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.TypeParameter;
import com.facebook.presto.server.SliceSerializer;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.type.ArrayType;
import com.facebook.presto.type.TypeUtils;
import com.facebook.presto.util.Reflection;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.type.MapType;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import io.airlift.json.ObjectMapperProvider;
import io.airlift.slice.Slice;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandle;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class MapValues
extends ParametricScalar {
    public static final MapValues MAP_VALUES = new MapValues();
    private static final Signature SIGNATURE = new Signature("map_values", (List<TypeParameter>)ImmutableList.of((Object)Signature.typeParameter("K"), (Object)Signature.typeParameter("V")), "array<V>", (List<String>)ImmutableList.of((Object)"map<K,V>"), false, false);
    private static final MethodHandle METHOD_HANDLE = Reflection.methodHandle(MapValues.class, "getValues", Slice.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapperProvider().get().registerModule((Module)new SimpleModule().addSerializer(Slice.class, (JsonSerializer)new SliceSerializer()));

    @Override
    public Signature getSignature() {
        return SIGNATURE;
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public boolean isDeterministic() {
        return true;
    }

    @Override
    public String getDescription() {
        return "Returns the values of the given map<K,V> as an array";
    }

    @Override
    public FunctionInfo specialize(Map<String, Type> types, int arity, TypeManager typeManager, FunctionRegistry functionRegistry) {
        Preconditions.checkArgument((arity == 1 ? 1 : 0) != 0, (Object)"map_values expects only one argument");
        Type keyType = types.get("K");
        Type valueType = types.get("V");
        Signature signature = new Signature("map_values", TypeUtils.parameterizedTypeName("array", valueType.getTypeSignature()), TypeUtils.parameterizedTypeName("map", keyType.getTypeSignature(), valueType.getTypeSignature()));
        return new FunctionInfo(signature, this.getDescription(), this.isHidden(), METHOD_HANDLE, this.isDeterministic(), true, (List<Boolean>)ImmutableList.of((Object)false));
    }

    public static Slice getValues(Slice map) {
        Map jsonMap;
        ArrayList values = new ArrayList();
        MapType type = OBJECT_MAPPER.getTypeFactory().constructMapType(Map.class, String.class, Object.class);
        try {
            jsonMap = (Map)OBJECT_MAPPER.readValue((InputStream)map.getInput(), (JavaType)type);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
        values.addAll(jsonMap.values());
        return ArrayType.toStackRepresentation(values);
    }
}

