/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.metadata.FunctionInfo;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.OperatorType;
import com.facebook.presto.metadata.ParametricOperator;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.TypeParameter;
import com.facebook.presto.server.SliceSerializer;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.type.TypeJsonUtils;
import com.facebook.presto.util.Reflection;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import io.airlift.json.ObjectMapperProvider;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class MapToJsonCast
extends ParametricOperator {
    public static final MapToJsonCast MAP_TO_JSON = new MapToJsonCast();
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapperProvider().get().registerModule((Module)new SimpleModule().addSerializer(Slice.class, (JsonSerializer)new SliceSerializer()).addSerializer(Map.class, (JsonSerializer)new MapSerializer()));
    private static final MethodHandle METHOD_HANDLE = Reflection.methodHandle(MapToJsonCast.class, "toJson", Type.class, ConnectorSession.class, Slice.class);

    private MapToJsonCast() {
        super(OperatorType.CAST, (List<TypeParameter>)ImmutableList.of((Object)Signature.typeParameter("K"), (Object)Signature.typeParameter("V")), "json", (List<String>)ImmutableList.of((Object)"map<K,V>"));
    }

    @Override
    public FunctionInfo specialize(Map<String, Type> types, int arity, TypeManager typeManager, FunctionRegistry functionRegistry) {
        Preconditions.checkArgument((arity == 1 ? 1 : 0) != 0, (Object)"Expected arity to be 1");
        Type keyType = types.get("K");
        Type valueType = types.get("V");
        Type mapType = typeManager.getParameterizedType("map", (List)ImmutableList.of((Object)keyType.getTypeSignature(), (Object)valueType.getTypeSignature()), (List)ImmutableList.of());
        MethodHandle methodHandle = METHOD_HANDLE.bindTo(mapType);
        return FunctionRegistry.operatorInfo(OperatorType.CAST, TypeSignature.parseTypeSignature((String)"json"), (List<TypeSignature>)ImmutableList.of((Object)mapType.getTypeSignature()), methodHandle, false, (List<Boolean>)ImmutableList.of((Object)false));
    }

    public static Slice toJson(Type mapType, ConnectorSession session, Slice slice) {
        Object object = TypeJsonUtils.stackRepresentationToObject(session, slice, mapType);
        try {
            return Slices.utf8Slice((String)OBJECT_MAPPER.writeValueAsString(object));
        }
        catch (JsonProcessingException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private static class MapSerializer
    extends JsonSerializer<Map> {
        private MapSerializer() {
        }

        public void serialize(Map map, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            TreeMap orderedMap = new TreeMap();
            for (Map.Entry entry : map.entrySet()) {
                orderedMap.put(entry.getKey().toString(), entry.getValue());
            }
            jsonGenerator.writeStartObject();
            for (Map.Entry entry : orderedMap.entrySet()) {
                jsonGenerator.writeObjectField((String)entry.getKey(), entry.getValue());
            }
            jsonGenerator.writeEndObject();
        }
    }
}

