/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.byteCode.Access;
import com.facebook.presto.byteCode.ClassDefinition;
import com.facebook.presto.byteCode.CompilerContext;
import com.facebook.presto.byteCode.DynamicClassLoader;
import com.facebook.presto.byteCode.NamedParameterDefinition;
import com.facebook.presto.byteCode.OpCode;
import com.facebook.presto.byteCode.ParameterizedType;
import com.facebook.presto.byteCode.Variable;
import com.facebook.presto.byteCode.control.IfStatement;
import com.facebook.presto.metadata.FunctionInfo;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.ParametricScalar;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.TypeParameter;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.sql.gen.Bootstrap;
import com.facebook.presto.sql.gen.CallSiteBinder;
import com.facebook.presto.sql.gen.CompilerOperations;
import com.facebook.presto.sql.gen.CompilerUtils;
import com.facebook.presto.sql.gen.SqlTypeByteCodeExpression;
import com.facebook.presto.util.ImmutableCollectors;
import com.facebook.presto.util.Reflection;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import java.lang.invoke.MethodHandle;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class Least
extends ParametricScalar {
    public static final Least LEAST = new Least();
    private static final Signature SIGNATURE = new Signature("least", (List<TypeParameter>)ImmutableList.of((Object)Signature.orderableTypeParameter("E")), "E", (List<String>)ImmutableList.of((Object)"E"), true, false);

    @Override
    public Signature getSignature() {
        return SIGNATURE;
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public boolean isDeterministic() {
        return true;
    }

    @Override
    public String getDescription() {
        return "get the smallest of the given values";
    }

    @Override
    public FunctionInfo specialize(Map<String, Type> types, int arity, TypeManager typeManager, FunctionRegistry functionRegistry) {
        Type type = types.get("E");
        Preconditions.checkArgument((boolean)type.isOrderable(), (Object)"Type must be orderable");
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < arity; ++i) {
            builder.add((Object)type.getJavaType());
        }
        ImmutableList stackTypes = builder.build();
        Class<?> clazz = Least.generateLeast(stackTypes, type);
        MethodHandle methodHandle = Reflection.methodHandle(clazz, "least", (Class[])stackTypes.toArray((Object[])new Class[stackTypes.size()]));
        ImmutableList nullableParameters = ImmutableList.copyOf(Collections.nCopies(stackTypes.size(), false));
        Signature specializedSignature = Signature.internalFunction(SIGNATURE.getName(), type.getTypeSignature(), Collections.nCopies(arity, type.getTypeSignature()));
        return new FunctionInfo(specializedSignature, this.getDescription(), this.isHidden(), methodHandle, this.isDeterministic(), false, (List<Boolean>)nullableParameters);
    }

    public static void checkNotNaN(double value) {
        if (Double.isNaN(value)) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Invalid argument to least(): NaN");
        }
    }

    private static Class<?> generateLeast(List<Class<?>> nativeContainerTypes, Type type) {
        List nativeContainerTypeNames = (List)nativeContainerTypes.stream().map(Class::getSimpleName).collect(ImmutableCollectors.toImmutableList());
        CompilerContext context = new CompilerContext(Bootstrap.BOOTSTRAP_METHOD);
        ClassDefinition definition = new ClassDefinition(context, Access.a(Access.PUBLIC, Access.FINAL), CompilerUtils.makeClassName(Joiner.on((String)"").join((Iterable)nativeContainerTypeNames) + "Least"), ParameterizedType.type(Object.class), new ParameterizedType[0]);
        definition.declareDefaultConstructor(Access.a(Access.PRIVATE));
        ImmutableList.Builder parameters = ImmutableList.builder();
        for (int i = 0; i < nativeContainerTypes.size(); ++i) {
            Class<?> nativeContainerType = nativeContainerTypes.get(i);
            parameters.add((Object)NamedParameterDefinition.arg("arg" + i, nativeContainerType));
        }
        com.facebook.presto.byteCode.Block body = definition.declareMethod(context, Access.a(Access.PUBLIC, Access.STATIC), "least", ParameterizedType.type(nativeContainerTypes.get(0)), (Iterable<NamedParameterDefinition>)parameters.build()).getBody();
        Variable typeVariable = context.declareVariable(Type.class, "typeVariable");
        CallSiteBinder binder = new CallSiteBinder();
        body.comment("typeVariable = type;").append(SqlTypeByteCodeExpression.constantType(context, binder, type)).putVariable(typeVariable);
        for (int i = 0; i < nativeContainerTypes.size(); ++i) {
            String writeMethodName;
            Class<?> nativeContainerType = nativeContainerTypes.get(i);
            Variable currentBlock = context.declareVariable(Block.class, "block" + i);
            Variable blockBuilder = context.declareVariable(BlockBuilder.class, "blockBuilder" + i);
            com.facebook.presto.byteCode.Block buildBlock = new com.facebook.presto.byteCode.Block(context).comment("blockBuilder%d = typeVariable.createBlockBuilder(new BlockBuilderStatus());", i).getVariable(typeVariable).newObject(BlockBuilderStatus.class).dup().invokeConstructor(BlockBuilderStatus.class, new Class[0]).invokeInterface(Type.class, "createBlockBuilder", BlockBuilder.class, BlockBuilderStatus.class).putVariable(blockBuilder);
            if (nativeContainerType == Long.TYPE) {
                writeMethodName = "writeLong";
            } else if (nativeContainerType == Boolean.TYPE) {
                writeMethodName = "writeBoolean";
            } else if (nativeContainerType == Double.TYPE) {
                writeMethodName = "writeDouble";
            } else if (nativeContainerType == Slice.class) {
                writeMethodName = "writeSlice";
            } else {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INTERNAL_ERROR, String.format("Unexpected type %s", nativeContainerType.getName()));
            }
            if (type.getTypeSignature().getBase().equals("double")) {
                buildBlock.getVariable("arg" + i).invokeStatic(Least.class, "checkNotNaN", Void.TYPE, Double.TYPE);
            }
            com.facebook.presto.byteCode.Block writeBlock = new com.facebook.presto.byteCode.Block(context).comment("typeVariable.%s(blockBuilder%d, arg%d);", writeMethodName, i, i).getVariable(typeVariable).getVariable(blockBuilder).getVariable("arg" + i).invokeInterface(Type.class, writeMethodName, Void.TYPE, BlockBuilder.class, nativeContainerType);
            buildBlock.append(writeBlock);
            com.facebook.presto.byteCode.Block storeBlock = new com.facebook.presto.byteCode.Block(context).comment("block%d = blockBuilder%d.build();", i, i).getVariable(blockBuilder).invokeInterface(BlockBuilder.class, "build", Block.class, new Class[0]).putVariable(currentBlock);
            buildBlock.append(storeBlock);
            body.append(buildBlock);
        }
        Variable leastVariable = context.declareVariable(nativeContainerTypes.get(0), "least");
        Variable leastBlockVariable = context.declareVariable(Block.class, "leastBlock");
        body.comment("least = arg0; leastBlock = block0;").getVariable("arg0").putVariable(leastVariable).getVariable("block0").putVariable(leastBlockVariable);
        for (int i = 1; i < nativeContainerTypes.size(); ++i) {
            com.facebook.presto.byteCode.Block condition = new com.facebook.presto.byteCode.Block(context).getVariable(typeVariable).getVariable(leastBlockVariable).push(0).getVariable("block" + i).push(0).invokeInterface(Type.class, "compareTo", Integer.TYPE, Block.class, Integer.TYPE, Block.class, Integer.TYPE).push(0).invokeStatic(CompilerOperations.class, "lessThan", Boolean.TYPE, Integer.TYPE, Integer.TYPE);
            com.facebook.presto.byteCode.Block ifFalse = new com.facebook.presto.byteCode.Block(context).getVariable("arg" + i).putVariable(leastVariable).getVariable("block" + i).putVariable(leastBlockVariable);
            IfStatement.IfStatementBuilder builder = IfStatement.ifStatementBuilder(context);
            builder.comment("if (type.compareTo(leastBlock, 0, block" + i + ", 0) < 0)", new Object[0]).condition(condition).ifTrue(OpCode.NOP).ifFalse(ifFalse);
            body.append(builder.build());
        }
        body.comment("return least;").getVariable(leastVariable).ret(nativeContainerTypes.get(0));
        return CompilerUtils.defineClass(definition, Object.class, binder.getBindings(), new DynamicClassLoader(Least.class.getClassLoader()));
    }
}

