/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.index;

import com.facebook.presto.operator.GroupByHash;
import com.facebook.presto.operator.GroupByIdBlock;
import com.facebook.presto.operator.index.IndexSnapshot;
import com.facebook.presto.operator.index.UpdateRequest;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.RecordCursor;
import com.facebook.presto.spi.RecordSet;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import io.airlift.slice.Slice;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public class UnloadedIndexKeyRecordSet
implements RecordSet {
    private final List<Type> types;
    private final List<PageAndPositions> pageAndPositions;

    public UnloadedIndexKeyRecordSet(IndexSnapshot existingSnapshot, Set<Integer> channelsForDistinct, List<Type> types, List<UpdateRequest> requests) {
        Preconditions.checkNotNull((Object)existingSnapshot, (Object)"existingSnapshot is null");
        this.types = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(types, (Object)"types is null")));
        Preconditions.checkNotNull(requests, (Object)"requests is null");
        int[] distinctChannels = Ints.toArray(channelsForDistinct);
        int[] normalizedDistinctChannels = new int[distinctChannels.length];
        ArrayList<Type> distinctChannelTypes = new ArrayList<Type>(distinctChannels.length);
        for (int i = 0; i < distinctChannels.length; ++i) {
            normalizedDistinctChannels[i] = i;
            distinctChannelTypes.add(types.get(distinctChannels[i]));
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        GroupByHash groupByHash = new GroupByHash(distinctChannelTypes, normalizedDistinctChannels, Optional.empty(), 10000);
        for (UpdateRequest request : requests) {
            Page page = request.getPage();
            Block[] blocks = page.getBlocks();
            Block[] distinctBlocks = new Block[distinctChannels.length];
            for (int i = 0; i < distinctBlocks.length; ++i) {
                distinctBlocks[i] = blocks[distinctChannels[i]];
            }
            GroupByIdBlock groupIds = groupByHash.getGroupIds(new Page(distinctBlocks));
            int positionCount = blocks[0].getPositionCount();
            long nextDistinctId = -1L;
            Preconditions.checkArgument((groupIds.getGroupCount() <= Integer.MAX_VALUE ? 1 : 0) != 0);
            IntArrayList positions = new IntArrayList((int)groupIds.getGroupCount());
            for (int position = 0; position < positionCount; ++position) {
                long groupId;
                if (UnloadedIndexKeyRecordSet.containsNullValue(position, blocks) || existingSnapshot.getJoinPosition(position, page) != -2L || nextDistinctId >= (groupId = groupIds.getGroupId(position))) continue;
                nextDistinctId = groupId;
                positions.add(position);
            }
            if (positions.isEmpty()) continue;
            builder.add((Object)new PageAndPositions(request, (IntList)positions));
        }
        this.pageAndPositions = builder.build();
    }

    public List<Type> getColumnTypes() {
        return this.types;
    }

    public UnloadedIndexKeyRecordCursor cursor() {
        return new UnloadedIndexKeyRecordCursor(this.types, this.pageAndPositions);
    }

    private static boolean containsNullValue(int position, Block ... blocks) {
        for (Block block : blocks) {
            if (!block.isNull(position)) continue;
            return true;
        }
        return false;
    }

    private static class PageAndPositions {
        private final UpdateRequest updateRequest;
        private final IntList positions;

        private PageAndPositions(UpdateRequest updateRequest, IntList positions) {
            this.updateRequest = (UpdateRequest)Preconditions.checkNotNull((Object)updateRequest, (Object)"updateRequest is null");
            this.positions = (IntList)Preconditions.checkNotNull((Object)positions, (Object)"positions is null");
        }

        private UpdateRequest getUpdateRequest() {
            return this.updateRequest;
        }

        private IntList getPositions() {
            return this.positions;
        }
    }

    public static class UnloadedIndexKeyRecordCursor
    implements RecordCursor {
        private final List<Type> types;
        private final Iterator<PageAndPositions> pageAndPositionsIterator;
        private Block[] blocks;
        private Page page;
        private IntListIterator positionIterator;
        private int position;

        public UnloadedIndexKeyRecordCursor(List<Type> types, List<PageAndPositions> pageAndPositions) {
            this.types = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(types, (Object)"types is null")));
            this.pageAndPositionsIterator = ((List)Preconditions.checkNotNull(pageAndPositions, (Object)"pageAndPositions is null")).iterator();
            this.blocks = new Block[types.size()];
        }

        public long getTotalBytes() {
            return 0L;
        }

        public long getCompletedBytes() {
            return 0L;
        }

        public long getReadTimeNanos() {
            return 0L;
        }

        public Type getType(int field) {
            return this.types.get(field);
        }

        public boolean advanceNextPosition() {
            while (this.positionIterator == null || !this.positionIterator.hasNext()) {
                if (!this.pageAndPositionsIterator.hasNext()) {
                    return false;
                }
                PageAndPositions pageAndPositions = this.pageAndPositionsIterator.next();
                this.page = pageAndPositions.getUpdateRequest().getPage();
                this.blocks = this.page.getBlocks();
                Preconditions.checkState((this.types.size() == this.blocks.length ? 1 : 0) != 0);
                this.positionIterator = pageAndPositions.getPositions().iterator();
            }
            this.position = this.positionIterator.nextInt();
            return true;
        }

        public Block[] getBlocks() {
            return this.blocks;
        }

        public Page getPage() {
            return this.page;
        }

        public int getPosition() {
            return this.position;
        }

        public boolean getBoolean(int field) {
            return this.types.get(field).getBoolean(this.blocks[field], this.position);
        }

        public long getLong(int field) {
            return this.types.get(field).getLong(this.blocks[field], this.position);
        }

        public double getDouble(int field) {
            return this.types.get(field).getDouble(this.blocks[field], this.position);
        }

        public Slice getSlice(int field) {
            return this.types.get(field).getSlice(this.blocks[field], this.position);
        }

        public boolean isNull(int field) {
            return this.blocks[field].isNull(this.position);
        }

        public void close() {
        }
    }
}

