/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.state;

import com.facebook.presto.byteCode.Access;
import com.facebook.presto.byteCode.ClassDefinition;
import com.facebook.presto.byteCode.CompilerContext;
import com.facebook.presto.byteCode.DynamicClassLoader;
import com.facebook.presto.byteCode.FieldDefinition;
import com.facebook.presto.byteCode.NamedParameterDefinition;
import com.facebook.presto.byteCode.ParameterizedType;
import com.facebook.presto.byteCode.Variable;
import com.facebook.presto.operator.aggregation.GroupedAccumulator;
import com.facebook.presto.operator.aggregation.state.AbstractGroupedAccumulatorState;
import com.facebook.presto.operator.aggregation.state.AccumulatorStateFactory;
import com.facebook.presto.operator.aggregation.state.AccumulatorStateMetadata;
import com.facebook.presto.operator.aggregation.state.AccumulatorStateSerializer;
import com.facebook.presto.operator.aggregation.state.InitialBooleanValue;
import com.facebook.presto.operator.aggregation.state.InitialDoubleValue;
import com.facebook.presto.operator.aggregation.state.InitialLongValue;
import com.facebook.presto.operator.aggregation.state.StateCompilerUtils;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.sql.gen.Bootstrap;
import com.facebook.presto.sql.gen.CallSiteBinder;
import com.facebook.presto.sql.gen.CompilerUtils;
import com.facebook.presto.sql.gen.SqlTypeByteCodeExpression;
import com.facebook.presto.util.array.BooleanBigArray;
import com.facebook.presto.util.array.ByteBigArray;
import com.facebook.presto.util.array.DoubleBigArray;
import com.facebook.presto.util.array.LongBigArray;
import com.facebook.presto.util.array.SliceBigArray;
import com.google.common.base.CaseFormat;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Ordering;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.lang.annotation.Annotation;
import java.lang.constant.Constable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.openjdk.jol.info.ClassLayout;

public class StateCompiler {
    private static Class<?> getBigArrayType(Class<?> type) {
        if (type.equals(Long.TYPE)) {
            return LongBigArray.class;
        }
        if (type.equals(Byte.TYPE)) {
            return ByteBigArray.class;
        }
        if (type.equals(Double.TYPE)) {
            return DoubleBigArray.class;
        }
        if (type.equals(Boolean.TYPE)) {
            return BooleanBigArray.class;
        }
        if (type.equals(Slice.class)) {
            return SliceBigArray.class;
        }
        throw new IllegalArgumentException("Unsupported type: " + type.getName());
    }

    public <T> AccumulatorStateSerializer<T> generateStateSerializer(Class<T> clazz) {
        return this.generateStateSerializer(clazz, new DynamicClassLoader(clazz.getClassLoader()));
    }

    public <T> AccumulatorStateSerializer<T> generateStateSerializer(Class<T> clazz, DynamicClassLoader classLoader) {
        AccumulatorStateMetadata metadata = StateCompiler.getMetadataAnnotation(clazz);
        if (metadata != null && metadata.stateSerializerClass() != Void.TYPE) {
            try {
                return (AccumulatorStateSerializer)metadata.stateSerializerClass().getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
        ClassDefinition definition = new ClassDefinition(Access.a(Access.PUBLIC, Access.FINAL), CompilerUtils.makeClassName(clazz.getSimpleName() + "Serializer"), ParameterizedType.type(Object.class), ParameterizedType.type(AccumulatorStateSerializer.class));
        CallSiteBinder callSiteBinder = new CallSiteBinder();
        definition.declareDefaultConstructor(Access.a(Access.PUBLIC));
        List<StateField> fields = StateCompiler.enumerateFields(clazz);
        StateCompiler.generateGetSerializedType(definition, fields, callSiteBinder);
        StateCompiler.generateSerialize(definition, clazz, fields);
        StateCompiler.generateDeserialize(definition, clazz, fields);
        Class<AccumulatorStateSerializer> serializerClass = CompilerUtils.defineClass(definition, AccumulatorStateSerializer.class, callSiteBinder.getBindings(), classLoader);
        try {
            return serializerClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private static void generateGetSerializedType(ClassDefinition definition, List<StateField> fields, CallSiteBinder callSiteBinder) {
        VarcharType type;
        CompilerContext compilerContext = new CompilerContext();
        com.facebook.presto.byteCode.Block body = definition.declareMethod(compilerContext, Access.a(Access.PUBLIC), "getSerializedType", ParameterizedType.type(Type.class), new NamedParameterDefinition[0]).getBody();
        if (fields.size() > 1) {
            type = VarcharType.VARCHAR;
        } else {
            Class<?> stackType = fields.get(0).getType();
            if (stackType == Long.TYPE) {
                type = BigintType.BIGINT;
            } else if (stackType == Double.TYPE) {
                type = DoubleType.DOUBLE;
            } else if (stackType == Boolean.TYPE) {
                type = BooleanType.BOOLEAN;
            } else if (stackType == Byte.TYPE) {
                type = BigintType.BIGINT;
            } else if (stackType == Slice.class) {
                type = VarcharType.VARCHAR;
            } else {
                throw new IllegalArgumentException("Unsupported type: " + stackType);
            }
        }
        body.comment("return %s", type.getTypeSignature()).append(SqlTypeByteCodeExpression.constantType(new CompilerContext(Bootstrap.BOOTSTRAP_METHOD), callSiteBinder, (Type)type)).retObject();
    }

    private static <T> AccumulatorStateMetadata getMetadataAnnotation(Class<T> clazz) {
        AccumulatorStateMetadata metadata = clazz.getAnnotation(AccumulatorStateMetadata.class);
        if (metadata != null) {
            return metadata;
        }
        for (Class<?> superInterface : clazz.getInterfaces()) {
            metadata = superInterface.getAnnotation(AccumulatorStateMetadata.class);
            if (metadata == null) continue;
            return metadata;
        }
        return null;
    }

    private static <T> void generateDeserialize(ClassDefinition definition, Class<T> clazz, List<StateField> fields) {
        CompilerContext compilerContext = new CompilerContext();
        com.facebook.presto.byteCode.Block deserializerBody = definition.declareMethod(compilerContext, Access.a(Access.PUBLIC), "deserialize", ParameterizedType.type(Void.TYPE), NamedParameterDefinition.arg("block", Block.class), NamedParameterDefinition.arg("index", Integer.TYPE), NamedParameterDefinition.arg("state", Object.class)).getBody();
        if (fields.size() == 1) {
            StateCompiler.generatePrimitiveDeserializer(deserializerBody, StateCompiler.getSetter(clazz, fields.get(0)));
        } else {
            Variable slice = compilerContext.declareVariable(Slice.class, "slice");
            deserializerBody.comment("Slice slice = block.getSlice(index, 0, block.getLength(index));").getVariable("block").getVariable("index").push(0).getVariable("block").getVariable("index").invokeInterface(Block.class, "getLength", Integer.TYPE, Integer.TYPE).invokeInterface(Block.class, "getSlice", Slice.class, Integer.TYPE, Integer.TYPE, Integer.TYPE).putVariable(slice);
            for (StateField field : fields) {
                StateCompiler.generateDeserializeFromSlice(deserializerBody, slice, StateCompiler.getSetter(clazz, field), StateCompiler.offsetOfField(field, fields));
            }
        }
        deserializerBody.ret();
    }

    private static <T> void generateSerialize(ClassDefinition definition, Class<T> clazz, List<StateField> fields) {
        CompilerContext compilerContext = new CompilerContext();
        com.facebook.presto.byteCode.Block serializerBody = definition.declareMethod(compilerContext, Access.a(Access.PUBLIC), "serialize", ParameterizedType.type(Void.TYPE), NamedParameterDefinition.arg("state", Object.class), NamedParameterDefinition.arg("out", BlockBuilder.class)).getBody();
        if (fields.size() == 1) {
            StateCompiler.generatePrimitiveSerializer(serializerBody, StateCompiler.getGetter(clazz, fields.get(0)));
        } else {
            Variable slice = compilerContext.declareVariable(Slice.class, "slice");
            int size = StateCompiler.serializedSizeOf(clazz);
            serializerBody.comment("Slice slice = Slices.allocate(%d);", size).push(size).invokeStatic(Slices.class, "allocate", Slice.class, Integer.TYPE).putVariable(slice);
            for (StateField field : fields) {
                StateCompiler.generateSerializeFieldToSlice(serializerBody, slice, StateCompiler.getGetter(clazz, field), StateCompiler.offsetOfField(field, fields));
            }
            serializerBody.comment("out.appendSlice(slice);").getVariable("out").getVariable(slice).push(0).push(size).invokeInterface(BlockBuilder.class, "writeBytes", BlockBuilder.class, Slice.class, Integer.TYPE, Integer.TYPE).invokeInterface(BlockBuilder.class, "closeEntry", BlockBuilder.class, new Class[0]).pop();
        }
        serializerBody.ret();
    }

    private static void generateSerializeFieldToSlice(com.facebook.presto.byteCode.Block body, Variable slice, Method getter, int offset) {
        Method sliceSetterMethod = StateCompilerUtils.getSliceSetter(getter.getReturnType());
        body.comment("slice.%s(offset, state.%s())", sliceSetterMethod.getName(), getter.getName()).getVariable(slice).push(offset).getVariable("state").invokeInterface(getter).invokeStatic(sliceSetterMethod);
    }

    private static int offsetOfField(StateField targetField, List<StateField> fields) {
        int offset = 0;
        for (StateField field : fields) {
            if (targetField.getName().equals(field.getName())) break;
            offset += field.sizeOfType();
        }
        return offset;
    }

    private static int serializedSizeOf(Class<?> stateClass) {
        List<StateField> fields = StateCompiler.enumerateFields(stateClass);
        int size = 0;
        for (StateField field : fields) {
            size += field.sizeOfType();
        }
        return size;
    }

    private static Method getSetter(Class<?> clazz, StateField field) {
        try {
            return clazz.getMethod(field.getSetterName(), field.getType());
        }
        catch (NoSuchMethodException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private static Method getGetter(Class<?> clazz, StateField field) {
        try {
            return clazz.getMethod(field.getGetterName(), new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private static void generatePrimitiveSerializer(com.facebook.presto.byteCode.Block body, Method getter) {
        Method method = StateCompilerUtils.getBlockBuilderAppend(getter.getReturnType());
        body.comment("out.%s(state.%s());", method.getName(), getter.getName()).getVariable("out").getVariable("state").invokeInterface(getter).invokeStatic(method);
    }

    private static void generatePrimitiveDeserializer(com.facebook.presto.byteCode.Block body, Method setter) {
        Method method = StateCompilerUtils.getBlockGetter(setter.getParameterTypes()[0]);
        body.comment("state.%s(block.%s));", setter.getName(), method.getName()).getVariable("state").getVariable("block").getVariable("index").invokeStatic(method).invokeInterface(setter);
    }

    private static void generateDeserializeFromSlice(com.facebook.presto.byteCode.Block body, Variable slice, Method setter, int offset) {
        Method sliceGetterMethod = StateCompilerUtils.getSliceGetter(setter.getParameterTypes()[0]);
        body.comment("state.%s(slice.%s(%d))", setter.getName(), sliceGetterMethod.getName(), offset).getVariable("state").getVariable(slice).push(offset).invokeStatic(sliceGetterMethod).invokeInterface(setter);
    }

    public <T> AccumulatorStateFactory<T> generateStateFactory(Class<T> clazz) {
        return this.generateStateFactory(clazz, new DynamicClassLoader(clazz.getClassLoader()));
    }

    public <T> AccumulatorStateFactory<T> generateStateFactory(Class<T> clazz, DynamicClassLoader classLoader) {
        AccumulatorStateMetadata metadata = StateCompiler.getMetadataAnnotation(clazz);
        if (metadata != null && metadata.stateFactoryClass() != Void.TYPE) {
            try {
                return (AccumulatorStateFactory)metadata.stateFactoryClass().getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
        Class<T> singleStateClass = StateCompiler.generateSingleStateClass(clazz, classLoader);
        Class<T> groupedStateClass = StateCompiler.generateGroupedStateClass(clazz, classLoader);
        ClassDefinition definition = new ClassDefinition(Access.a(Access.PUBLIC, Access.FINAL), CompilerUtils.makeClassName(clazz.getSimpleName() + "Factory"), ParameterizedType.type(Object.class), ParameterizedType.type(AccumulatorStateFactory.class));
        definition.declareDefaultConstructor(Access.a(Access.PUBLIC));
        definition.declareMethod(Access.a(Access.PUBLIC), "createSingleState", ParameterizedType.type(Object.class), new NamedParameterDefinition[0]).getBody().newObject(singleStateClass).dup().invokeConstructor(singleStateClass, new Class[0]).retObject();
        definition.declareMethod(Access.a(Access.PUBLIC), "createGroupedState", ParameterizedType.type(Object.class), new NamedParameterDefinition[0]).getBody().newObject(groupedStateClass).dup().invokeConstructor(groupedStateClass, new Class[0]).retObject();
        definition.declareMethod(Access.a(Access.PUBLIC), "getSingleStateClass", ParameterizedType.type(Class.class, singleStateClass), new NamedParameterDefinition[0]).getBody().push(singleStateClass).retObject();
        definition.declareMethod(Access.a(Access.PUBLIC), "getGroupedStateClass", ParameterizedType.type(Class.class, groupedStateClass), new NamedParameterDefinition[0]).getBody().push(groupedStateClass).retObject();
        Class<AccumulatorStateFactory> factoryClass = CompilerUtils.defineClass(definition, AccumulatorStateFactory.class, classLoader);
        try {
            return factoryClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private static <T> Class<? extends T> generateSingleStateClass(Class<T> clazz, DynamicClassLoader classLoader) {
        ClassDefinition definition = new ClassDefinition(Access.a(Access.PUBLIC, Access.FINAL), CompilerUtils.makeClassName("Single" + clazz.getSimpleName()), ParameterizedType.type(Object.class), ParameterizedType.type(clazz));
        FieldDefinition classSize = definition.declareField(Access.a(Access.PRIVATE, Access.STATIC, Access.FINAL), "CLASS_SIZE", Long.TYPE);
        definition.getClassInitializer().getBody().comment("CLASS_SIZE = ClassLayout.parseClass(%s.class).instanceSize()", definition.getName()).push(definition.getType()).invokeStatic(ClassLayout.class, "parseClass", ClassLayout.class, Class.class).invokeVirtual(ClassLayout.class, "instanceSize", Integer.TYPE, new Class[0]).intToLong().putStaticField(classSize);
        definition.declareMethod(new CompilerContext(null), Access.a(Access.PUBLIC), "getEstimatedSize", ParameterizedType.type(Long.TYPE), new NamedParameterDefinition[0]).getBody().getStaticField(classSize).retLong();
        com.facebook.presto.byteCode.Block constructor = definition.declareConstructor(Access.a(Access.PUBLIC), new NamedParameterDefinition[0]).getBody().pushThis().invokeConstructor(Object.class, new Class[0]);
        List<StateField> fields = StateCompiler.enumerateFields(clazz);
        for (StateField field : fields) {
            StateCompiler.generateField(definition, constructor, field);
        }
        constructor.ret();
        return CompilerUtils.defineClass(definition, clazz, classLoader);
    }

    private static <T> Class<? extends T> generateGroupedStateClass(Class<T> clazz, DynamicClassLoader classLoader) {
        ClassDefinition definition = new ClassDefinition(Access.a(Access.PUBLIC, Access.FINAL), CompilerUtils.makeClassName("Grouped" + clazz.getSimpleName()), ParameterizedType.type(AbstractGroupedAccumulatorState.class), ParameterizedType.type(clazz), ParameterizedType.type(GroupedAccumulator.class));
        List<StateField> fields = StateCompiler.enumerateFields(clazz);
        com.facebook.presto.byteCode.Block constructor = definition.declareConstructor(Access.a(Access.PUBLIC), new NamedParameterDefinition[0]).getBody().pushThis().invokeConstructor(AbstractGroupedAccumulatorState.class, new Class[0]);
        com.facebook.presto.byteCode.Block ensureCapacity = definition.declareMethod(Access.a(Access.PUBLIC), "ensureCapacity", ParameterizedType.type(Void.TYPE), NamedParameterDefinition.arg("size", Long.TYPE)).getBody();
        ArrayList<FieldDefinition> fieldDefinitions = new ArrayList<FieldDefinition>();
        for (StateField field : fields) {
            fieldDefinitions.add(StateCompiler.generateGroupedField(definition, constructor, ensureCapacity, field));
        }
        constructor.ret();
        ensureCapacity.ret();
        com.facebook.presto.byteCode.Block getEstimatedSize = definition.declareMethod(Access.a(Access.PUBLIC), "getEstimatedSize", ParameterizedType.type(Long.TYPE), new NamedParameterDefinition[0]).getBody().comment("long size = 0;").push(0L);
        for (FieldDefinition field : fieldDefinitions) {
            getEstimatedSize.comment("size += %s.sizeOf();", field.getName()).pushThis().getField(field).invokeVirtual(field.getType(), "sizeOf", ParameterizedType.type(Long.TYPE), new ParameterizedType[0]).longAdd();
        }
        getEstimatedSize.comment("return size;");
        getEstimatedSize.retLong();
        return CompilerUtils.defineClass(definition, clazz, classLoader);
    }

    private static void generateField(ClassDefinition definition, com.facebook.presto.byteCode.Block constructor, StateField stateField) {
        FieldDefinition field = definition.declareField(Access.a(Access.PRIVATE), CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, stateField.getName()) + "Value", stateField.getType());
        definition.declareMethod(Access.a(Access.PUBLIC), stateField.getGetterName(), ParameterizedType.type(stateField.getType()), new NamedParameterDefinition[0]).getBody().pushThis().getField(field).ret(stateField.getType());
        definition.declareMethod(Access.a(Access.PUBLIC), stateField.getSetterName(), ParameterizedType.type(Void.TYPE), NamedParameterDefinition.arg("value", stateField.getType())).getBody().pushThis().getVariable("value").putField(field).ret();
        constructor.pushThis();
        StateCompiler.pushInitialValue(constructor, stateField);
        constructor.putField(field);
    }

    private static FieldDefinition generateGroupedField(ClassDefinition definition, com.facebook.presto.byteCode.Block constructor, com.facebook.presto.byteCode.Block ensureCapacity, StateField stateField) {
        Class<?> bigArrayType = StateCompiler.getBigArrayType(stateField.getType());
        FieldDefinition field = definition.declareField(Access.a(Access.PRIVATE), CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, stateField.getName()) + "Values", bigArrayType);
        definition.declareMethod(Access.a(Access.PUBLIC), stateField.getGetterName(), ParameterizedType.type(stateField.getType()), new NamedParameterDefinition[0]).getBody().comment("return field.get(getGroupId());").pushThis().getField(field).pushThis().invokeVirtual(AbstractGroupedAccumulatorState.class, "getGroupId", Long.TYPE, new Class[0]).invokeVirtual(bigArrayType, "get", stateField.getType(), Long.TYPE).ret(stateField.getType());
        definition.declareMethod(Access.a(Access.PUBLIC), stateField.getSetterName(), ParameterizedType.type(Void.TYPE), NamedParameterDefinition.arg("value", stateField.getType())).getBody().comment("return field.set(getGroupId(), value);").pushThis().getField(field).pushThis().invokeVirtual(AbstractGroupedAccumulatorState.class, "getGroupId", Long.TYPE, new Class[0]).getVariable("value").invokeVirtual(bigArrayType, "set", Void.TYPE, Long.TYPE, stateField.getType()).ret();
        ensureCapacity.pushThis().getField(field).getVariable("size").invokeVirtual(field.getType(), "ensureCapacity", ParameterizedType.type(Void.TYPE), ParameterizedType.type(Long.TYPE));
        constructor.pushThis().newObject(field.getType()).dup();
        StateCompiler.pushInitialValue(constructor, stateField);
        constructor.invokeConstructor(field.getType(), ParameterizedType.type(stateField.getType()));
        constructor.putField(field);
        return field;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void pushInitialValue(com.facebook.presto.byteCode.Block block, StateField stateField) {
        Object initialValue = stateField.getInitialValue();
        if (initialValue != null) {
            if (initialValue instanceof Number) {
                block.push((Number)initialValue);
                return;
            } else {
                if (!(initialValue instanceof Boolean)) throw new IllegalArgumentException("Unsupported initial value type: " + initialValue.getClass());
                block.push((Boolean)initialValue);
            }
            return;
        } else {
            block.pushJavaDefault(stateField.getType());
        }
    }

    private static List<StateField> enumerateFields(Class<?> clazz) {
        ImmutableList.Builder builder = ImmutableList.builder();
        ImmutableSet primitiveClasses = ImmutableSet.of(Byte.TYPE, Boolean.TYPE, Long.TYPE, Double.TYPE);
        ImmutableSet supportedClasses = ImmutableSet.of(Byte.TYPE, Boolean.TYPE, Long.TYPE, Double.TYPE, Slice.class);
        for (Method method : clazz.getMethods()) {
            String name;
            Class<?> type;
            if (method.getName().equals("getEstimatedSize")) continue;
            if (method.getName().startsWith("get")) {
                type = method.getReturnType();
                Preconditions.checkArgument((boolean)supportedClasses.contains(type), (Object)(type.getName() + " is not supported"));
                name = method.getName().substring(3);
                builder.add((Object)new StateField(name, (Class)type, StateCompiler.getInitialValue(method)));
            }
            if (!method.getName().startsWith("is")) continue;
            type = method.getReturnType();
            Preconditions.checkArgument((type == Boolean.TYPE ? 1 : 0) != 0, (Object)"Only boolean is support for 'is' methods");
            name = method.getName().substring(2);
            builder.add((Object)new StateField(name, type, StateCompiler.getInitialValue(method), method.getName()));
        }
        Ordering<StateField> ordering = new Ordering<StateField>((Set)primitiveClasses){
            final /* synthetic */ Set val$primitiveClasses;
            {
                this.val$primitiveClasses = set;
            }

            public int compare(StateField left, StateField right) {
                if (this.val$primitiveClasses.contains(left.getType()) && !this.val$primitiveClasses.contains(right.getType())) {
                    return -1;
                }
                if (this.val$primitiveClasses.contains(right.getType()) && !this.val$primitiveClasses.contains(left.getType())) {
                    return 1;
                }
                return left.getName().compareTo(right.getName());
            }
        };
        List fields = ordering.sortedCopy((Iterable)builder.build());
        StateCompiler.checkInterface(clazz, fields);
        return fields;
    }

    private static Object getInitialValue(Method method) {
        Constable value = null;
        for (Annotation annotation : method.getAnnotations()) {
            if (annotation instanceof InitialLongValue) {
                Preconditions.checkArgument((value == null ? 1 : 0) != 0, (String)"%s has multiple initialValue annotations", (Object[])new Object[]{method.getName()});
                Preconditions.checkArgument((method.getReturnType() == Long.TYPE ? 1 : 0) != 0, (String)"%s does not return a long, but is annotated with @InitialLongValue", (Object[])new Object[]{method.getName()});
                value = ((InitialLongValue)annotation).value();
                continue;
            }
            if (annotation instanceof InitialDoubleValue) {
                Preconditions.checkArgument((value == null ? 1 : 0) != 0, (String)"%s has multiple initialValue annotations", (Object[])new Object[]{method.getName()});
                Preconditions.checkArgument((method.getReturnType() == Double.TYPE ? 1 : 0) != 0, (String)"%s does not return a double, but is annotated with @InitialDoubleValue", (Object[])new Object[]{method.getName()});
                value = ((InitialDoubleValue)annotation).value();
                continue;
            }
            if (!(annotation instanceof InitialBooleanValue)) continue;
            Preconditions.checkArgument((value == null ? 1 : 0) != 0, (String)"%s has multiple initialValue annotations", (Object[])new Object[]{method.getName()});
            Preconditions.checkArgument((method.getReturnType() == Boolean.TYPE ? 1 : 0) != 0, (String)"%s does not return a boolean, but is annotated with @InitialBooleanValue", (Object[])new Object[]{method.getName()});
            value = Boolean.valueOf(((InitialBooleanValue)annotation).value());
        }
        return value;
    }

    private static void checkInterface(Class<?> clazz, List<StateField> fields) {
        Preconditions.checkArgument((boolean)clazz.isInterface(), (Object)(clazz.getName() + " is not an interface"));
        HashSet<String> setters = new HashSet<String>();
        HashSet<String> getters = new HashSet<String>();
        HashSet<String> isGetters = new HashSet<String>();
        HashMap fieldTypes = new HashMap();
        for (StateField field : fields) {
            fieldTypes.put(field.getName(), field.getType());
        }
        for (Method method : clazz.getMethods()) {
            String name;
            if (method.getName().equals("getEstimatedSize")) {
                Preconditions.checkArgument((boolean)method.getReturnType().equals(Long.TYPE), (Object)"getEstimatedSize must return long");
                Preconditions.checkArgument((method.getParameterTypes().length == 0 ? 1 : 0) != 0, (Object)"getEstimatedSize may not have parameters");
                continue;
            }
            if (method.getName().startsWith("get")) {
                name = method.getName().substring(3);
                Preconditions.checkArgument((boolean)((Class)fieldTypes.get(name)).equals(method.getReturnType()), (String)"Expected %s to return type %s, but found %s", (Object[])new Object[]{method.getName(), fieldTypes.get(name), method.getReturnType()});
                Preconditions.checkArgument((method.getParameterTypes().length == 0 ? 1 : 0) != 0, (String)"Expected %s to have zero parameters", (Object[])new Object[]{method.getName()});
                getters.add(name);
                continue;
            }
            if (method.getName().startsWith("is")) {
                name = method.getName().substring(2);
                Preconditions.checkArgument((fieldTypes.get(name) == Boolean.TYPE ? 1 : 0) != 0, (String)"Expected %s to have type boolean, but found %s", (Object[])new Object[]{name, fieldTypes.get(name)});
                Preconditions.checkArgument((method.getParameterTypes().length == 0 ? 1 : 0) != 0, (String)"Expected %s to have zero parameters", (Object[])new Object[]{method.getName()});
                Preconditions.checkArgument((method.getReturnType() == Boolean.TYPE ? 1 : 0) != 0, (String)"Expected %s to return boolean", (Object[])new Object[]{method.getName()});
                isGetters.add(name);
                continue;
            }
            if (method.getName().startsWith("set")) {
                name = method.getName().substring(3);
                Preconditions.checkArgument((method.getParameterTypes().length == 1 ? 1 : 0) != 0, (Object)"Expected setter to have one parameter");
                Preconditions.checkArgument((boolean)((Class)fieldTypes.get(name)).equals(method.getParameterTypes()[0]), (String)"Expected %s to accept type %s, but found %s", (Object[])new Object[]{method.getName(), fieldTypes.get(name), method.getParameterTypes()[0]});
                Preconditions.checkArgument((StateCompiler.getInitialValue(method) == null ? 1 : 0) != 0, (Object)"initial value annotation not allowed on setter");
                Preconditions.checkArgument((boolean)method.getReturnType().equals(Void.TYPE), (String)"%s may not return a value", (Object[])new Object[]{method.getName()});
                setters.add(name);
                continue;
            }
            throw new IllegalArgumentException("Cannot generate implementation for method: " + method.getName());
        }
        Preconditions.checkArgument((getters.size() + isGetters.size() == setters.size() && setters.size() == fields.size() ? 1 : 0) != 0, (Object)"Wrong number of getters/setters");
    }

    private static final class StateField {
        private final String name;
        private final String getterName;
        private final Class<?> type;
        private final Object initialValue;

        private StateField(String name, Class<?> type, Object initialValue) {
            this(name, type, initialValue, "get" + name);
        }

        private StateField(String name, Class<?> type, Object initialValue, String getterName) {
            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name is null");
            Preconditions.checkArgument((!name.isEmpty() ? 1 : 0) != 0, (Object)"name is empty");
            this.type = (Class)Preconditions.checkNotNull(type, (Object)"type is null");
            this.getterName = (String)Preconditions.checkNotNull((Object)getterName, (Object)"getterName is null");
            this.initialValue = initialValue;
        }

        public String getGetterName() {
            return this.getterName;
        }

        public String getSetterName() {
            return "set" + this.getName();
        }

        public String getName() {
            return this.name;
        }

        public Class<?> getType() {
            return this.type;
        }

        public int sizeOfType() {
            if (this.getType() == Long.TYPE) {
                return 8;
            }
            if (this.getType() == Double.TYPE) {
                return 8;
            }
            if (this.getType() == Boolean.TYPE || this.getType() == Byte.TYPE) {
                return 1;
            }
            throw new IllegalArgumentException("Unsupported type: " + this.getType());
        }

        public Object getInitialValue() {
            return this.initialValue;
        }
    }
}

