/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.operator.GroupByHash;
import com.facebook.presto.server.SliceSerializer;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PageBuilder;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.type.ArrayType;
import com.facebook.presto.type.MapType;
import com.facebook.presto.type.RowType;
import com.facebook.presto.type.TypeJsonUtils;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import io.airlift.json.ObjectMapperProvider;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.openjdk.jol.info.ClassLayout;

public class KeyValuePairs {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(KeyValuePairs.class).instanceSize();
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapperProvider().get().registerModule((Module)new SimpleModule().addSerializer(Slice.class, (JsonSerializer)new SliceSerializer()));
    public static final int EXPECTED_HASH_SIZE = 10000;
    private final GroupByHash keysHash;
    private final PageBuilder keyPageBuilder;
    private final Type keyType;
    private final PageBuilder valuePageBuilder;
    private final Type valueType;

    public KeyValuePairs(Type keyType, Type valueType) {
        Preconditions.checkNotNull((Object)keyType, (Object)"keyType is null");
        Preconditions.checkNotNull((Object)valueType, (Object)"valueType is null");
        this.keyType = keyType;
        this.valueType = valueType;
        this.keysHash = new GroupByHash((List<? extends Type>)ImmutableList.of((Object)keyType), new int[]{0}, Optional.empty(), 10000);
        this.keyPageBuilder = new PageBuilder((List)ImmutableList.of((Object)this.keyType));
        this.valuePageBuilder = new PageBuilder((List)ImmutableList.of((Object)this.valueType));
    }

    public KeyValuePairs(Slice serialized, Type keyType, Type valueType) {
        Preconditions.checkNotNull((Object)serialized, (Object)"serialized is null");
        Preconditions.checkNotNull((Object)keyType, (Object)"keyType is null");
        Preconditions.checkNotNull((Object)valueType, (Object)"valueType is null");
        this.keyType = keyType;
        this.valueType = valueType;
        this.keysHash = new GroupByHash((List<? extends Type>)ImmutableList.of((Object)keyType), new int[]{0}, Optional.empty(), 10000);
        this.keyPageBuilder = new PageBuilder((List)ImmutableList.of((Object)this.keyType));
        this.valuePageBuilder = new PageBuilder((List)ImmutableList.of((Object)this.valueType));
        this.deserialize(serialized);
    }

    public Block getKeys() {
        return this.keyPageBuilder.getBlockBuilder(0).build();
    }

    public Block getValues() {
        return this.valuePageBuilder.getBlockBuilder(0).build();
    }

    private void deserialize(Slice serialized) {
        Map map = (Map)TypeJsonUtils.stackRepresentationToObject(null, serialized, (Type)new MapType(this.keyType, this.valueType));
        for (Map.Entry entry : map.entrySet()) {
            this.add(KeyValuePairs.createBlock(entry.getKey(), this.keyType), KeyValuePairs.createBlock(entry.getValue(), this.valueType), 0);
        }
    }

    public Slice serialize() {
        LinkedHashMap<Object, Object> newMap = new LinkedHashMap<Object, Object>();
        Block values = this.valuePageBuilder.getBlockBuilder(0).build();
        Block keys = this.keyPageBuilder.getBlockBuilder(0).build();
        for (int i = 0; i < keys.getPositionCount(); ++i) {
            newMap.put(TypeJsonUtils.getValue(keys, this.keyType, i), TypeJsonUtils.getValue(values, this.valueType, i));
        }
        return MapType.toStackRepresentation(newMap);
    }

    public long estimatedInMemorySize() {
        return (long)INSTANCE_SIZE + this.keyPageBuilder.getSizeInBytes() + this.valuePageBuilder.getSizeInBytes();
    }

    public void add(Block key, Block value, int position) {
        Page page = new Page(new Block[]{key});
        if (!this.keysHash.contains(position, page)) {
            int groupId = this.keysHash.putIfAbsent(position, page, new Block[]{key});
            this.keysHash.appendValuesTo(groupId, this.keyPageBuilder, 0);
            if (value.isNull(position)) {
                this.valuePageBuilder.getBlockBuilder(0).appendNull();
            } else {
                this.valueType.appendTo(value, position, this.valuePageBuilder.getBlockBuilder(0));
            }
        }
    }

    private static Block createBlock(Object obj, Type type) {
        BlockBuilder blockBuilder;
        block11: {
            blockBuilder = type.createBlockBuilder(new BlockBuilderStatus());
            try {
                if (obj == null) {
                    return blockBuilder.appendNull().build();
                }
                if (type.getJavaType() == Double.TYPE) {
                    type.writeDouble(blockBuilder, ((Number)obj).doubleValue());
                    break block11;
                }
                if (type.getJavaType() == Long.TYPE) {
                    type.writeLong(blockBuilder, ((Number)obj).longValue());
                    break block11;
                }
                if (type.getJavaType() == Slice.class) {
                    if (type instanceof VarcharType) {
                        type.writeSlice(blockBuilder, Slices.utf8Slice((String)((String)obj)));
                    } else if (type instanceof ArrayType || type instanceof MapType || type instanceof RowType) {
                        type.writeSlice(blockBuilder, Slices.utf8Slice((String)OBJECT_MAPPER.writeValueAsString(obj)));
                    } else {
                        type.writeSlice(blockBuilder, (Slice)obj);
                    }
                    break block11;
                }
                if (type.getJavaType() == Boolean.TYPE) {
                    type.writeBoolean(blockBuilder, ((Boolean)obj).booleanValue());
                    break block11;
                }
                throw new IllegalArgumentException("Unsupported type: " + type.getJavaType().getSimpleName());
            }
            catch (IOException ioe) {
                Throwables.propagate((Throwable)ioe);
            }
        }
        return blockBuilder.build();
    }
}

