/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.PagesIndex;
import com.facebook.presto.operator.WindowFunctionDefinition;
import com.facebook.presto.operator.window.WindowFunction;
import com.facebook.presto.operator.window.WindowIndex;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PageBuilder;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.block.SortOrder;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.tree.FrameBound;
import com.facebook.presto.sql.tree.WindowFrame;
import com.facebook.presto.util.Failures;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.primitives.Ints;
import it.unimi.dsi.fastutil.ints.IntComparator;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;

public class WindowOperator
implements Operator {
    private final OperatorContext operatorContext;
    private final int[] outputChannels;
    private final List<WindowFunction> windowFunctions;
    private final List<Type> partitionTypes;
    private final List<Integer> partitionChannels;
    private final List<Type> sortTypes;
    private final List<Integer> sortChannels;
    private final List<SortOrder> sortOrder;
    private final List<Type> types;
    private final boolean frameRange;
    private final FrameBound.Type frameStartType;
    private final int frameStartChannel;
    private final FrameBound.Type frameEndType;
    private final int frameEndChannel;
    private final PagesIndex pagesIndex;
    private final PageBuilder pageBuilder;
    private State state = State.NEEDS_INPUT;
    private int currentPosition;
    private IntComparator partitionComparator;
    private IntComparator orderComparator;
    private int partitionStart;
    private int partitionEnd;
    private int peerGroupStart;
    private int peerGroupEnd;
    private int frameStart;
    private int frameEnd;

    public WindowOperator(OperatorContext operatorContext, List<Type> sourceTypes, List<Integer> outputChannels, List<WindowFunctionDefinition> windowFunctionDefinitions, List<Type> partitionTypes, List<Integer> partitionChannels, List<Type> sortTypes, List<Integer> sortChannels, List<SortOrder> sortOrder, WindowFrame.Type frameType, FrameBound.Type frameStartType, Optional<Integer> frameStartChannel, FrameBound.Type frameEndType, Optional<Integer> frameEndChannel, int expectedPositions) {
        this.operatorContext = (OperatorContext)Preconditions.checkNotNull((Object)operatorContext, (Object)"operatorContext is null");
        this.outputChannels = Ints.toArray((Collection)((Collection)Preconditions.checkNotNull(outputChannels, (Object)"outputChannels is null")));
        this.windowFunctions = WindowOperator.toWindowFunctions((List)Preconditions.checkNotNull(windowFunctionDefinitions, (Object)"windowFunctionDefinitions is null"));
        this.partitionTypes = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(partitionTypes, (Object)"partitionTypes is null")));
        this.partitionChannels = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(partitionChannels, (Object)"partitionChannels is null")));
        this.sortTypes = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(sortTypes, (Object)"sortTypes is null")));
        this.sortChannels = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(sortChannels, (Object)"sortChannels is null")));
        this.sortOrder = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(sortOrder, (Object)"sortOrder is null")));
        this.frameRange = Preconditions.checkNotNull((Object)frameType, (Object)"frameType is null") == WindowFrame.Type.RANGE;
        this.frameStartType = (FrameBound.Type)Preconditions.checkNotNull((Object)frameStartType, (Object)"frameStartType is null");
        this.frameStartChannel = ((Optional)Preconditions.checkNotNull(frameStartChannel, (Object)"frameStartChannel is null")).orElse(-1);
        this.frameEndType = (FrameBound.Type)Preconditions.checkNotNull((Object)frameEndType, (Object)"frameEndType is null");
        this.frameEndChannel = ((Optional)Preconditions.checkNotNull(frameEndChannel, (Object)"frameEndChannel is null")).orElse(-1);
        this.types = WindowOperator.toTypes(sourceTypes, outputChannels, this.windowFunctions);
        this.pagesIndex = new PagesIndex(sourceTypes, expectedPositions);
        this.pageBuilder = new PageBuilder(this.types);
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public List<Type> getTypes() {
        return this.types;
    }

    @Override
    public void finish() {
        if (this.state == State.NEEDS_INPUT) {
            this.state = State.HAS_OUTPUT;
            List<SortOrder> partitionOrder = Collections.nCopies(this.partitionChannels.size(), SortOrder.ASC_NULLS_LAST);
            ImmutableList orderChannels = ImmutableList.copyOf((Iterable)Iterables.concat(this.partitionChannels, this.sortChannels));
            ImmutableList ordering = ImmutableList.copyOf((Iterable)Iterables.concat(partitionOrder, this.sortOrder));
            ImmutableList orderingTypes = ImmutableList.copyOf((Iterable)Iterables.concat(this.partitionTypes, this.sortTypes));
            this.pagesIndex.sort((List<Type>)orderingTypes, (List<Integer>)orderChannels, (List<SortOrder>)ordering);
            this.partitionComparator = this.pagesIndex.createComparator((List<Type>)orderingTypes, this.partitionChannels, partitionOrder);
            this.orderComparator = this.pagesIndex.createComparator((List<Type>)orderingTypes, this.sortChannels, this.sortOrder);
        }
    }

    @Override
    public boolean isFinished() {
        return this.state == State.FINISHED;
    }

    @Override
    public boolean needsInput() {
        return this.state == State.NEEDS_INPUT;
    }

    @Override
    public void addInput(Page page) {
        Preconditions.checkState((this.state == State.NEEDS_INPUT ? 1 : 0) != 0, (Object)"Operator is already finishing");
        Preconditions.checkNotNull((Object)page, (Object)"page is null");
        this.pagesIndex.addPage(page);
        this.operatorContext.setMemoryReservation(this.pagesIndex.getEstimatedSize().toBytes());
    }

    @Override
    public Page getOutput() {
        if (this.state != State.HAS_OUTPUT) {
            return null;
        }
        if (this.currentPosition >= this.pagesIndex.getPositionCount()) {
            this.state = State.FINISHED;
            return null;
        }
        this.pageBuilder.reset();
        while (!this.pageBuilder.isFull() && this.currentPosition < this.pagesIndex.getPositionCount()) {
            boolean newPeerGroup;
            int channel;
            boolean newPartition;
            boolean bl = newPartition = this.currentPosition == 0 || this.currentPosition == this.partitionEnd;
            if (newPartition) {
                this.partitionStart = this.currentPosition;
                ++this.partitionEnd;
                while (this.partitionEnd < this.pagesIndex.getPositionCount() && this.partitionComparator.compare(this.partitionEnd - 1, this.partitionEnd) == 0) {
                    ++this.partitionEnd;
                }
                WindowIndex windowIndex = new WindowIndex(this.pagesIndex, this.partitionStart, this.partitionEnd);
                for (WindowFunction function : this.windowFunctions) {
                    function.reset(windowIndex);
                }
            }
            this.pageBuilder.declarePosition();
            for (channel = 0; channel < this.outputChannels.length; ++channel) {
                this.pagesIndex.appendTo(this.outputChannels[channel], this.currentPosition, this.pageBuilder.getBlockBuilder(channel));
            }
            boolean bl2 = newPeerGroup = newPartition || this.currentPosition == this.peerGroupEnd;
            if (newPeerGroup) {
                this.peerGroupStart = this.currentPosition;
                ++this.peerGroupEnd;
                while (this.peerGroupEnd < this.partitionEnd && this.orderComparator.compare(this.peerGroupEnd - 1, this.peerGroupEnd) == 0) {
                    ++this.peerGroupEnd;
                }
            }
            this.updateFrame();
            for (WindowFunction function : this.windowFunctions) {
                function.processRow(this.pageBuilder.getBlockBuilder(channel), this.peerGroupStart - this.partitionStart, this.peerGroupEnd - this.partitionStart - 1, this.frameStart, this.frameEnd);
                ++channel;
            }
            ++this.currentPosition;
        }
        if (this.pageBuilder.isEmpty()) {
            this.state = State.FINISHED;
            return null;
        }
        Page page = this.pageBuilder.build();
        return page;
    }

    private void updateFrame() {
        int rowPosition = this.currentPosition - this.partitionStart;
        int endPosition = this.partitionEnd - this.partitionStart - 1;
        this.frameStart = this.frameStartType == FrameBound.Type.UNBOUNDED_PRECEDING ? 0 : (this.frameStartType == FrameBound.Type.PRECEDING ? WindowOperator.preceding(rowPosition, this.getStartValue()) : (this.frameStartType == FrameBound.Type.FOLLOWING ? WindowOperator.following(rowPosition, endPosition, this.getStartValue()) : (this.frameRange ? this.peerGroupStart - this.partitionStart : rowPosition)));
        this.frameEnd = this.frameEndType == FrameBound.Type.UNBOUNDED_FOLLOWING ? endPosition : (this.frameEndType == FrameBound.Type.PRECEDING ? WindowOperator.preceding(rowPosition, this.getEndValue()) : (this.frameEndType == FrameBound.Type.FOLLOWING ? WindowOperator.following(rowPosition, endPosition, this.getEndValue()) : (this.frameRange ? this.peerGroupEnd - this.partitionStart - 1 : rowPosition)));
        if (this.emptyFrame(rowPosition, endPosition)) {
            this.frameStart = -1;
            this.frameEnd = -1;
        }
    }

    private boolean emptyFrame(int rowPosition, int endPosition) {
        if (this.frameStartType != this.frameEndType) {
            return false;
        }
        FrameBound.Type type = this.frameStartType;
        if (type != FrameBound.Type.PRECEDING && type != FrameBound.Type.FOLLOWING) {
            return false;
        }
        long start = this.getStartValue();
        long end = this.getEndValue();
        if (type == FrameBound.Type.PRECEDING) {
            return start < end || start > (long)rowPosition && end > (long)rowPosition;
        }
        int positions = endPosition - rowPosition;
        return start > end || start > (long)positions && end > (long)positions;
    }

    private static int preceding(int rowPosition, long value) {
        if (value > (long)rowPosition) {
            return 0;
        }
        return Ints.checkedCast((long)((long)rowPosition - value));
    }

    private static int following(int rowPosition, int endPosition, long value) {
        if (value > (long)(endPosition - rowPosition)) {
            return endPosition;
        }
        return Ints.checkedCast((long)((long)rowPosition + value));
    }

    private long getStartValue() {
        return this.getFrameValue(this.frameStartChannel, "starting");
    }

    private long getEndValue() {
        return this.getFrameValue(this.frameEndChannel, "ending");
    }

    private long getFrameValue(int channel, String type) {
        Failures.checkCondition(!this.pagesIndex.isNull(channel, this.currentPosition), (ErrorCodeSupplier)StandardErrorCode.INVALID_WINDOW_FRAME, "Window frame %s offset must not be null", type);
        long value = this.pagesIndex.getLong(channel, this.currentPosition);
        Failures.checkCondition(value >= 0L, (ErrorCodeSupplier)StandardErrorCode.INVALID_WINDOW_FRAME, "Window frame %s offset must not be negative", new Object[0]);
        return value;
    }

    private static List<Type> toTypes(List<? extends Type> sourceTypes, List<Integer> outputChannels, List<WindowFunction> windowFunctions) {
        ImmutableList.Builder types = ImmutableList.builder();
        Iterator<Object> iterator = outputChannels.iterator();
        while (iterator.hasNext()) {
            int channel = iterator.next();
            types.add((Object)sourceTypes.get(channel));
        }
        for (WindowFunction function : windowFunctions) {
            types.add((Object)function.getType());
        }
        return types.build();
    }

    private static List<WindowFunction> toWindowFunctions(List<WindowFunctionDefinition> windowFunctionDefinitions) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (WindowFunctionDefinition windowFunctionDefinition : windowFunctionDefinitions) {
            builder.add((Object)windowFunctionDefinition.createWindowFunction());
        }
        return builder.build();
    }

    private static enum State {
        NEEDS_INPUT,
        HAS_OUTPUT,
        FINISHED;

    }

    public static class WindowOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final List<Type> sourceTypes;
        private final List<Integer> outputChannels;
        private final List<WindowFunctionDefinition> windowFunctionDefinitions;
        private final List<Type> partitionTypes;
        private final List<Integer> partitionChannels;
        private final List<Type> sortTypes;
        private final List<Integer> sortChannels;
        private final List<SortOrder> sortOrder;
        private final WindowFrame.Type frameType;
        private final FrameBound.Type frameStartType;
        private final Optional<Integer> frameStartChannel;
        private final FrameBound.Type frameEndType;
        private final Optional<Integer> frameEndChannel;
        private final int expectedPositions;
        private final List<Type> types;
        private boolean closed;

        public WindowOperatorFactory(int operatorId, List<? extends Type> sourceTypes, List<Integer> outputChannels, List<WindowFunctionDefinition> windowFunctionDefinitions, List<Integer> partitionChannels, List<Integer> sortChannels, List<SortOrder> sortOrder, WindowFrame.Type frameType, FrameBound.Type frameStartType, Optional<Integer> frameStartChannel, FrameBound.Type frameEndType, Optional<Integer> frameEndChannel, int expectedPositions) {
            this.operatorId = operatorId;
            this.sourceTypes = ImmutableList.copyOf(sourceTypes);
            this.outputChannels = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(outputChannels, (Object)"outputChannels is null")));
            this.windowFunctionDefinitions = windowFunctionDefinitions;
            ImmutableList.Builder partitionTypes = ImmutableList.builder();
            for (int channel : partitionChannels) {
                partitionTypes.add((Object)sourceTypes.get(channel));
            }
            this.partitionTypes = partitionTypes.build();
            this.partitionChannels = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(partitionChannels, (Object)"partitionChannels is null")));
            ImmutableList.Builder sortTypes = ImmutableList.builder();
            for (int channel : sortChannels) {
                sortTypes.add((Object)sourceTypes.get(channel));
            }
            this.sortTypes = sortTypes.build();
            this.sortChannels = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(sortChannels, (Object)"sortChannels is null")));
            this.sortOrder = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(sortOrder, (Object)"sortOrder is null")));
            this.frameType = (WindowFrame.Type)Preconditions.checkNotNull((Object)frameType, (Object)"frameType is null");
            this.frameStartType = (FrameBound.Type)Preconditions.checkNotNull((Object)frameStartType, (Object)"frameStartType is null");
            this.frameStartChannel = (Optional)Preconditions.checkNotNull(frameStartChannel, (Object)"frameStartChannel is null");
            this.frameEndType = (FrameBound.Type)Preconditions.checkNotNull((Object)frameEndType, (Object)"frameEndType is null");
            this.frameEndChannel = (Optional)Preconditions.checkNotNull(frameEndChannel, (Object)"frameEndChannel is null");
            this.expectedPositions = expectedPositions;
            this.types = WindowOperator.toTypes(sourceTypes, outputChannels, WindowOperator.toWindowFunctions(windowFunctionDefinitions));
        }

        @Override
        public List<Type> getTypes() {
            return this.types;
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, WindowOperator.class.getSimpleName());
            return new WindowOperator(operatorContext, this.sourceTypes, this.outputChannels, this.windowFunctionDefinitions, this.partitionTypes, this.partitionChannels, this.sortTypes, this.sortChannels, this.sortOrder, this.frameType, this.frameStartType, this.frameStartChannel, this.frameEndType, this.frameEndChannel, this.expectedPositions);
        }

        @Override
        public void close() {
            this.closed = true;
        }
    }
}

