/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.execution.SharedBuffer;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.OutputFactory;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;

public class TaskOutputOperator
implements Operator {
    private final OperatorContext operatorContext;
    private final SharedBuffer sharedBuffer;
    private ListenableFuture<?> blocked = NOT_BLOCKED;
    private boolean finished;

    public TaskOutputOperator(OperatorContext operatorContext, SharedBuffer sharedBuffer) {
        this.operatorContext = (OperatorContext)Preconditions.checkNotNull((Object)operatorContext, (Object)"operatorContext is null");
        this.sharedBuffer = (SharedBuffer)Preconditions.checkNotNull((Object)sharedBuffer, (Object)"sharedBuffer is null");
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public List<Type> getTypes() {
        return ImmutableList.of();
    }

    @Override
    public void finish() {
        this.finished = true;
    }

    @Override
    public boolean isFinished() {
        if (this.blocked != NOT_BLOCKED && this.blocked.isDone()) {
            this.blocked = NOT_BLOCKED;
        }
        return this.finished && this.blocked == NOT_BLOCKED;
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        if (this.blocked != NOT_BLOCKED && this.blocked.isDone()) {
            this.blocked = NOT_BLOCKED;
        }
        return this.blocked;
    }

    @Override
    public boolean needsInput() {
        if (this.blocked != NOT_BLOCKED && this.blocked.isDone()) {
            this.blocked = NOT_BLOCKED;
        }
        return !this.finished && this.blocked == NOT_BLOCKED;
    }

    @Override
    public void addInput(Page page) {
        Preconditions.checkNotNull((Object)page, (Object)"page is null");
        Preconditions.checkState((this.blocked == NOT_BLOCKED ? 1 : 0) != 0, (Object)"output is already blocked");
        ListenableFuture<?> future = this.sharedBuffer.enqueue(page);
        if (!future.isDone()) {
            this.blocked = future;
        }
        this.operatorContext.recordGeneratedOutput(page.getSizeInBytes(), page.getPositionCount());
    }

    @Override
    public Page getOutput() {
        return null;
    }

    public static class TaskOutputOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final SharedBuffer sharedBuffer;

        public TaskOutputOperatorFactory(int operatorId, SharedBuffer sharedBuffer) {
            this.operatorId = operatorId;
            this.sharedBuffer = (SharedBuffer)Preconditions.checkNotNull((Object)sharedBuffer, (Object)"sharedBuffer is null");
        }

        @Override
        public List<Type> getTypes() {
            return ImmutableList.of();
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, TaskOutputOperator.class.getSimpleName());
            return new TaskOutputOperator(operatorContext, this.sharedBuffer);
        }

        @Override
        public void close() {
        }
    }

    public static class TaskOutputFactory
    implements OutputFactory {
        private final SharedBuffer sharedBuffer;

        public TaskOutputFactory(SharedBuffer sharedBuffer) {
            this.sharedBuffer = (SharedBuffer)Preconditions.checkNotNull((Object)sharedBuffer, (Object)"sharedBuffer is null");
        }

        @Override
        public OperatorFactory createOutputOperator(int operatorId, List<Type> sourceType) {
            return new TaskOutputOperatorFactory(operatorId, this.sharedBuffer);
        }
    }
}

