/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.JoinProbe;
import com.facebook.presto.operator.JoinProbeFactory;
import com.facebook.presto.operator.LookupSource;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PageBuilder;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;
import java.util.List;
import java.util.Optional;

public class SimpleJoinProbe
implements JoinProbe {
    private final List<Type> types;
    private final LookupSource lookupSource;
    private final int positionCount;
    private final Block[] blocks;
    private final Block[] probeBlocks;
    private final Page probePage;
    private final Optional<Block> probeHashBlock;
    private int position = -1;

    private SimpleJoinProbe(List<Type> types, LookupSource lookupSource, Page page, List<Integer> probeJoinChannels, Optional<Integer> hashChannel) {
        int i;
        this.types = types;
        this.lookupSource = lookupSource;
        this.positionCount = page.getPositionCount();
        this.blocks = new Block[page.getChannelCount()];
        this.probeBlocks = new Block[probeJoinChannels.size()];
        for (i = 0; i < page.getChannelCount(); ++i) {
            this.blocks[i] = page.getBlock(i);
        }
        for (i = 0; i < probeJoinChannels.size(); ++i) {
            this.probeBlocks[i] = this.blocks[probeJoinChannels.get(i)];
        }
        this.probePage = new Page(this.probeBlocks);
        this.probeHashBlock = hashChannel.isPresent() ? Optional.of(page.getBlock(hashChannel.get().intValue())) : Optional.empty();
    }

    @Override
    public int getChannelCount() {
        return this.blocks.length;
    }

    @Override
    public boolean advanceNextPosition() {
        ++this.position;
        return this.position < this.positionCount;
    }

    @Override
    public void appendTo(PageBuilder pageBuilder) {
        for (int outputIndex = 0; outputIndex < this.blocks.length; ++outputIndex) {
            Type type = this.types.get(outputIndex);
            Block block = this.blocks[outputIndex];
            type.appendTo(block, this.position, pageBuilder.getBlockBuilder(outputIndex));
        }
    }

    @Override
    public long getCurrentJoinPosition() {
        if (this.currentRowContainsNull()) {
            return -1L;
        }
        if (this.probeHashBlock.isPresent()) {
            int rawHash = (int)BigintType.BIGINT.getLong(this.probeHashBlock.get(), this.position);
            return this.lookupSource.getJoinPosition(this.position, this.probePage, rawHash);
        }
        return this.lookupSource.getJoinPosition(this.position, this.probePage);
    }

    private boolean currentRowContainsNull() {
        for (Block probeBlock : this.probeBlocks) {
            if (!probeBlock.isNull(this.position)) continue;
            return true;
        }
        return false;
    }

    public static class SimpleJoinProbeFactory
    implements JoinProbeFactory {
        private List<Type> types;
        private List<Integer> probeJoinChannels;
        private final Optional<Integer> probeHashChannel;

        public SimpleJoinProbeFactory(List<Type> types, List<Integer> probeJoinChannels, Optional<Integer> probeHashChannel) {
            this.types = types;
            this.probeJoinChannels = probeJoinChannels;
            this.probeHashChannel = probeHashChannel;
        }

        @Override
        public JoinProbe createJoinProbe(LookupSource lookupSource, Page page) {
            return new SimpleJoinProbe(this.types, lookupSource, page, this.probeJoinChannels, this.probeHashChannel);
        }
    }
}

