/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.metadata.ColumnHandle;
import com.facebook.presto.metadata.Split;
import com.facebook.presto.operator.CursorProcessor;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.FilterAndProjectOperator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.PageProcessor;
import com.facebook.presto.operator.SourceOperator;
import com.facebook.presto.operator.SourceOperatorFactory;
import com.facebook.presto.spi.ConnectorPageSource;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PageBuilder;
import com.facebook.presto.spi.RecordCursor;
import com.facebook.presto.spi.RecordPageSource;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.split.PageSourceProvider;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import javax.annotation.concurrent.GuardedBy;

public class ScanFilterAndProjectOperator
implements SourceOperator,
Closeable {
    private static final int ROWS_PER_PAGE = 16384;
    private final OperatorContext operatorContext;
    private final PlanNodeId planNodeId;
    private final PageSourceProvider pageSourceProvider;
    private final List<Type> types;
    private final List<ColumnHandle> columns;
    private final PageBuilder pageBuilder;
    private final CursorProcessor cursorProcessor;
    private final PageProcessor pageProcessor;
    @GuardedBy(value="this")
    private RecordCursor cursor;
    @GuardedBy(value="this")
    private ConnectorPageSource pageSource;
    private Page currentPage;
    private int currentPosition;
    private boolean finishing;
    private long completedBytes;
    private long readTimeNanos;

    protected ScanFilterAndProjectOperator(OperatorContext operatorContext, PlanNodeId sourceId, PageSourceProvider pageSourceProvider, CursorProcessor cursorProcessor, PageProcessor pageProcessor, Iterable<ColumnHandle> columns, Iterable<Type> types) {
        this.cursorProcessor = (CursorProcessor)Preconditions.checkNotNull((Object)cursorProcessor, (Object)"cursorProcessor is null");
        this.pageProcessor = (PageProcessor)Preconditions.checkNotNull((Object)pageProcessor, (Object)"pageProcessor is null");
        this.operatorContext = (OperatorContext)Preconditions.checkNotNull((Object)operatorContext, (Object)"operatorContext is null");
        this.planNodeId = (PlanNodeId)Preconditions.checkNotNull((Object)sourceId, (Object)"sourceId is null");
        this.pageSourceProvider = (PageSourceProvider)Preconditions.checkNotNull((Object)pageSourceProvider, (Object)"pageSourceManager is null");
        this.types = ImmutableList.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(types, (Object)"types is null")));
        this.columns = ImmutableList.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(columns, (Object)"columns is null")));
        this.pageBuilder = new PageBuilder(this.getTypes());
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public PlanNodeId getSourceId() {
        return this.planNodeId;
    }

    @Override
    public synchronized void addSplit(Split split) {
        Preconditions.checkNotNull((Object)split, (Object)"split is null");
        Preconditions.checkState((this.cursor == null && this.pageSource == null ? 1 : 0) != 0, (Object)"split already set");
        ConnectorPageSource pageSource = this.pageSourceProvider.createPageSource(split, this.columns);
        if (pageSource instanceof RecordPageSource) {
            this.cursor = ((RecordPageSource)pageSource).getCursor();
        } else {
            this.pageSource = pageSource;
        }
        Object splitInfo = split.getInfo();
        if (splitInfo != null) {
            this.operatorContext.setInfoSupplier((Supplier<Object>)Suppliers.ofInstance((Object)splitInfo));
        }
    }

    @Override
    public synchronized void noMoreSplits() {
        if (this.cursor == null && this.pageSource == null) {
            this.finishing = true;
        }
    }

    @Override
    public final List<Type> getTypes() {
        return this.types;
    }

    @Override
    public final void finish() {
        this.close();
    }

    @Override
    public void close() {
        if (this.pageSource != null) {
            try {
                this.pageSource.close();
            }
            catch (IOException e) {
                throw Throwables.propagate((Throwable)e);
            }
        } else if (this.cursor != null) {
            this.cursor.close();
        }
        this.finishing = true;
    }

    @Override
    public final boolean isFinished() {
        if (this.pageSource != null && this.pageSource.isFinished() && this.currentPage == null) {
            this.finishing = true;
        }
        return this.finishing && this.pageBuilder.isEmpty();
    }

    @Override
    public final boolean needsInput() {
        return false;
    }

    @Override
    public final void addInput(Page page) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Page getOutput() {
        if (!this.finishing) {
            if (this.cursor != null) {
                int rowsProcessed = this.cursorProcessor.process(this.operatorContext.getSession().toConnectorSession(), this.cursor, 16384, this.pageBuilder);
                long bytesProcessed = this.cursor.getCompletedBytes() - this.completedBytes;
                long elapsedNanos = this.cursor.getReadTimeNanos() - this.readTimeNanos;
                this.operatorContext.recordGeneratedInput(bytesProcessed, rowsProcessed, elapsedNanos);
                this.completedBytes = this.cursor.getCompletedBytes();
                this.readTimeNanos = this.cursor.getReadTimeNanos();
                if (rowsProcessed == 0) {
                    this.finishing = true;
                }
            } else {
                if (this.currentPage == null) {
                    this.currentPage = this.pageSource.getNextPage();
                    if (this.currentPage != null) {
                        long endCompletedBytes = this.pageSource.getCompletedBytes();
                        long endReadTimeNanos = this.pageSource.getReadTimeNanos();
                        this.operatorContext.recordGeneratedInput(endCompletedBytes - this.completedBytes, this.currentPage.getPositionCount(), endReadTimeNanos - this.readTimeNanos);
                        this.completedBytes = endCompletedBytes;
                        this.readTimeNanos = endReadTimeNanos;
                    }
                    this.currentPosition = 0;
                }
                if (this.currentPage != null) {
                    this.currentPosition = this.pageProcessor.process(this.operatorContext.getSession().toConnectorSession(), this.currentPage, this.currentPosition, this.currentPage.getPositionCount(), this.pageBuilder);
                    if (this.currentPosition == this.currentPage.getPositionCount()) {
                        this.currentPage = null;
                        this.currentPosition = 0;
                    }
                }
            }
        }
        if (this.pageBuilder.isEmpty() || !this.finishing && !this.pageBuilder.isFull()) {
            return null;
        }
        Page page = this.pageBuilder.build();
        this.pageBuilder.reset();
        return page;
    }

    public static class ScanFilterAndProjectOperatorFactory
    implements SourceOperatorFactory {
        private final int operatorId;
        private final CursorProcessor cursorProcessor;
        private final PageProcessor pageProcessor;
        private final PlanNodeId sourceId;
        private final PageSourceProvider pageSourceProvider;
        private final List<ColumnHandle> columns;
        private final List<Type> types;
        private boolean closed;

        public ScanFilterAndProjectOperatorFactory(int operatorId, PlanNodeId sourceId, PageSourceProvider pageSourceProvider, CursorProcessor cursorProcessor, PageProcessor pageProcessor, Iterable<ColumnHandle> columns, List<Type> types) {
            this.operatorId = operatorId;
            this.cursorProcessor = (CursorProcessor)Preconditions.checkNotNull((Object)cursorProcessor, (Object)"cursorProcessor is null");
            this.pageProcessor = (PageProcessor)Preconditions.checkNotNull((Object)pageProcessor, (Object)"pageProcessor is null");
            this.sourceId = (PlanNodeId)Preconditions.checkNotNull((Object)sourceId, (Object)"sourceId is null");
            this.pageSourceProvider = (PageSourceProvider)Preconditions.checkNotNull((Object)pageSourceProvider, (Object)"pageSourceProvider is null");
            this.columns = ImmutableList.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(columns, (Object)"columns is null")));
            this.types = (List)Preconditions.checkNotNull(types, (Object)"types is null");
        }

        @Override
        public PlanNodeId getSourceId() {
            return this.sourceId;
        }

        @Override
        public List<Type> getTypes() {
            return this.types;
        }

        @Override
        public SourceOperator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, FilterAndProjectOperator.class.getSimpleName());
            return new ScanFilterAndProjectOperator(operatorContext, this.sourceId, this.pageSourceProvider, this.cursorProcessor, this.pageProcessor, this.columns, this.types);
        }

        @Override
        public void close() {
            this.closed = true;
        }
    }
}

