/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.spi.type.Type;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;

public final class ViewDefinition {
    private final String originalSql;
    private final String catalog;
    private final String schema;
    private final List<ViewColumn> columns;

    @JsonCreator
    public ViewDefinition(@JsonProperty(value="originalSql") String originalSql, @JsonProperty(value="catalog") String catalog, @JsonProperty(value="schema") String schema, @JsonProperty(value="columns") List<ViewColumn> columns) {
        this.originalSql = (String)Preconditions.checkNotNull((Object)originalSql, (Object)"originalSql is null");
        this.catalog = (String)Preconditions.checkNotNull((Object)catalog, (Object)"catalog is null");
        this.schema = (String)Preconditions.checkNotNull((Object)schema, (Object)"schema is null");
        this.columns = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(columns, (Object)"columns is null")));
    }

    @JsonProperty
    public String getOriginalSql() {
        return this.originalSql;
    }

    @JsonProperty
    public String getCatalog() {
        return this.catalog;
    }

    @JsonProperty
    public String getSchema() {
        return this.schema;
    }

    @JsonProperty
    public List<ViewColumn> getColumns() {
        return this.columns;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("originalSql", (Object)this.originalSql).add("catalog", (Object)this.catalog).add("schema", (Object)this.schema).add("columns", this.columns).toString();
    }

    public static final class ViewColumn {
        private final String name;
        private final Type type;

        @JsonCreator
        public ViewColumn(@JsonProperty(value="name") String name, @JsonProperty(value="type") Type type) {
            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name is null");
            this.type = (Type)Preconditions.checkNotNull((Object)type, (Object)"type is null");
        }

        @JsonProperty
        public String getName() {
            return this.name;
        }

        @JsonProperty
        public Type getType() {
            return this.type;
        }

        public String toString() {
            return this.name + ":" + this.type;
        }
    }
}

