/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.metadata.MetadataUtil;
import com.facebook.presto.spi.SchemaTablePrefix;
import com.google.common.base.Objects;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;

@Immutable
public class QualifiedTablePrefix {
    private final String catalogName;
    private final Optional<String> schemaName;
    private final Optional<String> tableName;

    public QualifiedTablePrefix(String catalogName) {
        this.catalogName = MetadataUtil.checkCatalogName(catalogName);
        this.schemaName = Optional.empty();
        this.tableName = Optional.empty();
    }

    public QualifiedTablePrefix(String catalogName, String schemaName) {
        this.catalogName = MetadataUtil.checkCatalogName(catalogName);
        this.schemaName = Optional.of(MetadataUtil.checkSchemaName(schemaName));
        this.tableName = Optional.empty();
    }

    public QualifiedTablePrefix(String catalogName, String schemaName, String tableName) {
        this.catalogName = MetadataUtil.checkCatalogName(catalogName);
        this.schemaName = Optional.of(MetadataUtil.checkSchemaName(schemaName));
        this.tableName = Optional.of(MetadataUtil.checkTableName(tableName));
    }

    public QualifiedTablePrefix(String catalogName, Optional<String> schemaName, Optional<String> tableName) {
        MetadataUtil.checkTableName(catalogName, schemaName, tableName);
        this.catalogName = catalogName;
        this.schemaName = schemaName;
        this.tableName = tableName;
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public Optional<String> getSchemaName() {
        return this.schemaName;
    }

    public Optional<String> getTableName() {
        return this.tableName;
    }

    public boolean hasSchemaName() {
        return this.schemaName.isPresent();
    }

    public boolean hasTableName() {
        return this.tableName.isPresent();
    }

    public SchemaTablePrefix asSchemaTablePrefix() {
        if (!this.schemaName.isPresent()) {
            return new SchemaTablePrefix();
        }
        if (!this.tableName.isPresent()) {
            return new SchemaTablePrefix(this.schemaName.get());
        }
        return new SchemaTablePrefix(this.schemaName.get(), this.tableName.get());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        QualifiedTablePrefix o = (QualifiedTablePrefix)obj;
        return Objects.equal((Object)this.catalogName, (Object)o.catalogName) && Objects.equal(this.schemaName, o.schemaName) && Objects.equal(this.tableName, o.tableName);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.catalogName, this.schemaName, this.tableName});
    }

    public String toString() {
        return this.catalogName + '.' + this.schemaName.orElse("*") + '.' + this.tableName.orElse("*");
    }
}

