/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.connector.system.SystemHandleResolver;
import com.facebook.presto.spi.ConnectorColumnHandle;
import com.facebook.presto.spi.ConnectorHandleResolver;
import com.facebook.presto.spi.ConnectorIndexHandle;
import com.facebook.presto.spi.ConnectorInsertTableHandle;
import com.facebook.presto.spi.ConnectorOutputTableHandle;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.inject.Inject;

public class HandleResolver {
    private final ConcurrentMap<String, ConnectorHandleResolver> handleIdResolvers = new ConcurrentHashMap<String, ConnectorHandleResolver>();

    public HandleResolver() {
    }

    @Inject
    public HandleResolver(Map<String, ConnectorHandleResolver> handleIdResolvers) {
        this.handleIdResolvers.putAll(handleIdResolvers);
        this.handleIdResolvers.put("system", new SystemHandleResolver());
    }

    public void addHandleResolver(String id, ConnectorHandleResolver connectorHandleResolver) {
        ConnectorHandleResolver existingResolver = this.handleIdResolvers.putIfAbsent(id, connectorHandleResolver);
        Preconditions.checkState((existingResolver == null ? 1 : 0) != 0, (String)"Id %s is already assigned to resolver %s", (Object[])new Object[]{id, existingResolver});
    }

    public String getId(ConnectorTableHandle tableHandle) {
        for (Map.Entry entry : this.handleIdResolvers.entrySet()) {
            if (!((ConnectorHandleResolver)entry.getValue()).canHandle(tableHandle)) continue;
            return (String)entry.getKey();
        }
        throw new IllegalArgumentException("No connector for table handle: " + tableHandle);
    }

    public String getId(ConnectorColumnHandle columnHandle) {
        for (Map.Entry entry : this.handleIdResolvers.entrySet()) {
            if (!((ConnectorHandleResolver)entry.getValue()).canHandle(columnHandle)) continue;
            return (String)entry.getKey();
        }
        throw new IllegalArgumentException("No connector for column handle: " + columnHandle);
    }

    public String getId(ConnectorSplit split) {
        for (Map.Entry entry : this.handleIdResolvers.entrySet()) {
            if (!((ConnectorHandleResolver)entry.getValue()).canHandle(split)) continue;
            return (String)entry.getKey();
        }
        throw new IllegalArgumentException("No connector for split: " + split);
    }

    public String getId(ConnectorIndexHandle indexHandle) {
        for (Map.Entry entry : this.handleIdResolvers.entrySet()) {
            if (!((ConnectorHandleResolver)entry.getValue()).canHandle(indexHandle)) continue;
            return (String)entry.getKey();
        }
        throw new IllegalArgumentException("No connector for index handle: " + indexHandle);
    }

    public String getId(ConnectorOutputTableHandle outputHandle) {
        for (Map.Entry entry : this.handleIdResolvers.entrySet()) {
            if (!((ConnectorHandleResolver)entry.getValue()).canHandle(outputHandle)) continue;
            return (String)entry.getKey();
        }
        throw new IllegalArgumentException("No connector for output table handle: " + outputHandle);
    }

    public String getId(ConnectorInsertTableHandle insertHandle) {
        for (Map.Entry entry : this.handleIdResolvers.entrySet()) {
            if (!((ConnectorHandleResolver)entry.getValue()).canHandle(insertHandle)) continue;
            return (String)entry.getKey();
        }
        throw new IllegalArgumentException("No connector for insert table handle: " + insertHandle);
    }

    public Class<? extends ConnectorTableHandle> getTableHandleClass(String id) {
        return this.resolverFor(id).getTableHandleClass();
    }

    public Class<? extends ConnectorColumnHandle> getColumnHandleClass(String id) {
        return this.resolverFor(id).getColumnHandleClass();
    }

    public Class<? extends ConnectorSplit> getSplitClass(String id) {
        return this.resolverFor(id).getSplitClass();
    }

    public Class<? extends ConnectorIndexHandle> getIndexHandleClass(String id) {
        return this.resolverFor(id).getIndexHandleClass();
    }

    public Class<? extends ConnectorOutputTableHandle> getOutputTableHandleClass(String id) {
        return this.resolverFor(id).getOutputTableHandleClass();
    }

    public Class<? extends ConnectorInsertTableHandle> getInsertTableHandleClass(String id) {
        return this.resolverFor(id).getInsertTableHandleClass();
    }

    public ConnectorHandleResolver resolverFor(String id) {
        ConnectorHandleResolver resolver = (ConnectorHandleResolver)this.handleIdResolvers.get(id);
        Preconditions.checkArgument((resolver != null ? 1 : 0) != 0, (String)"No handle resolver for %s", (Object[])new Object[]{id});
        return resolver;
    }
}

