/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.metadata.FunctionInfo;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.OperatorType;
import com.facebook.presto.metadata.ParametricFunction;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.operator.Description;
import com.facebook.presto.operator.aggregation.GenericAggregationFunctionFactory;
import com.facebook.presto.operator.aggregation.InternalAggregationFunction;
import com.facebook.presto.operator.scalar.JsonPath;
import com.facebook.presto.operator.scalar.ScalarFunction;
import com.facebook.presto.operator.scalar.ScalarOperator;
import com.facebook.presto.operator.window.ReflectionWindowFunctionSupplier;
import com.facebook.presto.operator.window.WindowFunction;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.type.SqlType;
import com.facebook.presto.type.TypeUtils;
import com.google.common.base.CaseFormat;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.primitives.Primitives;
import io.airlift.slice.Slice;
import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.joni.Regex;

public class FunctionListBuilder {
    private static final Set<Class<?>> NULLABLE_ARGUMENT_TYPES = ImmutableSet.of(Boolean.class, Long.class, Double.class, Slice.class);
    private static final Set<Class<?>> SUPPORTED_TYPES = ImmutableSet.of(Long.TYPE, Long.class, Double.TYPE, Double.class, Slice.class, Boolean.TYPE, (Object[])new Class[]{Boolean.class, Pattern.class, Regex.class, JsonPath.class});
    private static final Set<Class<?>> SUPPORTED_RETURN_TYPES = ImmutableSet.of(Long.TYPE, Double.TYPE, Slice.class, Boolean.TYPE, Integer.TYPE, Pattern.class, (Object[])new Class[]{Regex.class, JsonPath.class});
    private final List<ParametricFunction> functions = new ArrayList<ParametricFunction>();
    private final TypeManager typeManager;

    public FunctionListBuilder(TypeManager typeManager) {
        this.typeManager = (TypeManager)Preconditions.checkNotNull((Object)typeManager, (Object)"typeManager is null");
    }

    public FunctionListBuilder window(String name, Type returnType, List<? extends Type> argumentTypes, Class<? extends WindowFunction> functionClass) {
        ReflectionWindowFunctionSupplier<? extends WindowFunction> windowFunctionSupplier = new ReflectionWindowFunctionSupplier<WindowFunction>(new Signature(name, returnType.getTypeSignature(), Lists.transform((List)ImmutableList.copyOf(argumentTypes), Type::getTypeSignature)), functionClass);
        this.functions.add(new FunctionInfo(windowFunctionSupplier.getSignature(), windowFunctionSupplier.getDescription(), windowFunctionSupplier));
        return this;
    }

    public FunctionListBuilder aggregate(List<InternalAggregationFunction> functions) {
        for (InternalAggregationFunction function : functions) {
            this.aggregate(function);
        }
        return this;
    }

    public FunctionListBuilder aggregate(InternalAggregationFunction function) {
        String name = function.name();
        name = name.toLowerCase(Locale.ENGLISH);
        String description = FunctionListBuilder.getDescription(function.getClass());
        Signature signature = new Signature(name, function.getFinalType().getTypeSignature(), Lists.transform((List)ImmutableList.copyOf(function.getParameterTypes()), Type::getTypeSignature));
        this.functions.add(new FunctionInfo(signature, description, function.getIntermediateType().getTypeSignature(), function, function.isApproximate()));
        return this;
    }

    public FunctionListBuilder aggregate(Class<?> aggregationDefinition) {
        this.functions.addAll(GenericAggregationFunctionFactory.fromAggregationDefinition(aggregationDefinition, this.typeManager).listFunctions());
        return this;
    }

    public FunctionListBuilder scalar(Signature signature, MethodHandle function, boolean deterministic, String description, boolean hidden, boolean nullable, List<Boolean> nullableArguments) {
        this.functions.add(new FunctionInfo(signature, description, hidden, function, deterministic, nullable, nullableArguments));
        return this;
    }

    private FunctionListBuilder operator(OperatorType operatorType, Type returnType, List<Type> parameterTypes, MethodHandle function, boolean nullable, List<Boolean> nullableArguments) {
        FunctionInfo operatorInfo = FunctionRegistry.operatorInfo(operatorType, returnType.getTypeSignature(), Lists.transform(parameterTypes, Type::getTypeSignature), function, nullable, nullableArguments);
        this.functions.add(operatorInfo);
        return this;
    }

    public FunctionListBuilder scalar(Class<?> clazz) {
        try {
            boolean foundOne = false;
            for (Method method : clazz.getMethods()) {
                foundOne = this.processScalarFunction(method) || foundOne;
                foundOne = this.processScalarOperator(method) || foundOne;
            }
            Preconditions.checkArgument((boolean)foundOne, (String)"Expected class %s to contain at least one method annotated with @%s", (Object[])new Object[]{clazz.getName(), ScalarFunction.class.getSimpleName()});
        }
        catch (IllegalAccessException e) {
            throw Throwables.propagate((Throwable)e);
        }
        return this;
    }

    public FunctionListBuilder functions(ParametricFunction ... parametricFunctions) {
        for (ParametricFunction parametricFunction : parametricFunctions) {
            this.function(parametricFunction);
        }
        return this;
    }

    public FunctionListBuilder function(ParametricFunction parametricFunction) {
        Preconditions.checkNotNull((Object)parametricFunction, (Object)"parametricFunction is null");
        this.functions.add(parametricFunction);
        return this;
    }

    private boolean processScalarFunction(Method method) throws IllegalAccessException {
        SqlType returnTypeAnnotation;
        ScalarFunction scalarFunction = method.getAnnotation(ScalarFunction.class);
        if (scalarFunction == null) {
            return false;
        }
        FunctionListBuilder.checkValidMethod(method);
        MethodHandle methodHandle = MethodHandles.lookup().unreflect(method);
        String name = scalarFunction.value();
        if (name.isEmpty()) {
            name = FunctionListBuilder.camelToSnake(method.getName());
        }
        Preconditions.checkArgument(((returnTypeAnnotation = method.getAnnotation(SqlType.class)) != null ? 1 : 0) != 0, (String)"Method %s return type does not have a @SqlType annotation", (Object[])new Object[]{method});
        Type returnType = FunctionListBuilder.type(this.typeManager, returnTypeAnnotation);
        Signature signature = new Signature(name.toLowerCase(Locale.ENGLISH), returnType.getTypeSignature(), Lists.transform(FunctionListBuilder.parameterTypes(this.typeManager, method), Type::getTypeSignature));
        FunctionListBuilder.verifyMethodSignature(method, signature.getReturnType(), signature.getArgumentTypes(), this.typeManager);
        List<Boolean> nullableArguments = FunctionListBuilder.getNullableArguments(method);
        this.scalar(signature, methodHandle, scalarFunction.deterministic(), FunctionListBuilder.getDescription(method), scalarFunction.hidden(), method.isAnnotationPresent(Nullable.class), nullableArguments);
        for (String alias : scalarFunction.alias()) {
            this.scalar(signature.withAlias(alias.toLowerCase(Locale.ENGLISH)), methodHandle, scalarFunction.deterministic(), FunctionListBuilder.getDescription(method), scalarFunction.hidden(), method.isAnnotationPresent(Nullable.class), nullableArguments);
        }
        return true;
    }

    private static Type type(TypeManager typeManager, SqlType explicitType) {
        Type type = typeManager.getType(TypeSignature.parseTypeSignature((String)explicitType.value()));
        Preconditions.checkNotNull((Object)type, (String)"No type found for '%s'", (Object[])new Object[]{explicitType.value()});
        return type;
    }

    private static List<Type> parameterTypes(TypeManager typeManager, Method method) {
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        ImmutableList.Builder types = ImmutableList.builder();
        for (int i = 0; i < method.getParameterTypes().length; ++i) {
            Class<?> clazz = method.getParameterTypes()[i];
            if (clazz == ConnectorSession.class) continue;
            SqlType explicitType = null;
            for (Annotation annotation : parameterAnnotations[i]) {
                if (!(annotation instanceof SqlType)) continue;
                explicitType = (SqlType)annotation;
                break;
            }
            Preconditions.checkArgument((explicitType != null ? 1 : 0) != 0, (String)"Method %s argument %s does not have a @SqlType annotation", (Object[])new Object[]{method, i});
            types.add((Object)FunctionListBuilder.type(typeManager, explicitType));
        }
        return types.build();
    }

    private static void verifyMethodSignature(Method method, TypeSignature returnTypeName, List<TypeSignature> argumentTypeNames, TypeManager typeManager) {
        Type returnType = typeManager.getType(returnTypeName);
        Preconditions.checkNotNull((Object)returnType, (Object)"returnType is null");
        List<Type> argumentTypes = TypeUtils.resolveTypes(argumentTypeNames, typeManager);
        Preconditions.checkArgument((Primitives.unwrap(method.getReturnType()) == returnType.getJavaType() ? 1 : 0) != 0, (String)"Expected method %s return type to be %s (%s)", (Object[])new Object[]{method, returnType.getJavaType().getName(), returnType});
        Class<?>[] parameterTypes = method.getParameterTypes();
        Annotation[][] annotations = method.getParameterAnnotations();
        if (parameterTypes.length > 0 && parameterTypes[0] == ConnectorSession.class) {
            parameterTypes = Arrays.copyOfRange(parameterTypes, 1, parameterTypes.length);
            annotations = (Annotation[][])Arrays.copyOfRange(annotations, 1, annotations.length);
        }
        for (int i = 0; i < parameterTypes.length; ++i) {
            boolean nullable;
            Class<?> actualType = parameterTypes[i];
            Type expectedType = argumentTypes.get(i);
            boolean bl = nullable = !FluentIterable.from(Arrays.asList(annotations[i])).filter(Nullable.class).isEmpty();
            if (Primitives.isWrapperType(actualType)) {
                Preconditions.checkArgument((boolean)nullable, (String)"Method %s has parameter with type %s that is missing @Nullable", (Object[])new Object[]{method, actualType});
            }
            if (nullable) {
                Preconditions.checkArgument((boolean)NULLABLE_ARGUMENT_TYPES.contains(actualType), (String)"Method %s has parameter type %s, but @Nullable is not supported on this type", (Object[])new Object[]{method, actualType});
            }
            Preconditions.checkArgument((Primitives.unwrap(actualType) == expectedType.getJavaType() ? 1 : 0) != 0, (String)"Expected method %s parameter %s type to be %s (%s)", (Object[])new Object[]{method, i, expectedType.getJavaType().getName(), expectedType});
        }
    }

    private static List<Boolean> getNullableArguments(Method method) {
        ArrayList<Boolean> nullableArguments = new ArrayList<Boolean>();
        for (Annotation[] annotations : method.getParameterAnnotations()) {
            boolean nullable = false;
            boolean foundSqlType = false;
            for (Annotation annotation : annotations) {
                if (annotation instanceof Nullable) {
                    nullable = true;
                }
                if (!(annotation instanceof SqlType)) continue;
                foundSqlType = true;
            }
            if (!foundSqlType) continue;
            nullableArguments.add(nullable);
        }
        return nullableArguments;
    }

    private boolean processScalarOperator(Method method) throws IllegalAccessException {
        BigintType returnType;
        ScalarOperator scalarOperator = method.getAnnotation(ScalarOperator.class);
        if (scalarOperator == null) {
            return false;
        }
        FunctionListBuilder.checkValidMethod(method);
        MethodHandle methodHandle = MethodHandles.lookup().unreflect(method);
        OperatorType operatorType = scalarOperator.value();
        List<Type> parameterTypes = FunctionListBuilder.parameterTypes(this.typeManager, method);
        if (operatorType == OperatorType.HASH_CODE) {
            returnType = BigintType.BIGINT;
        } else {
            SqlType explicitType = method.getAnnotation(SqlType.class);
            Preconditions.checkArgument((explicitType != null ? 1 : 0) != 0, (String)"Method %s return type does not have a @SqlType annotation", (Object[])new Object[]{method});
            returnType = FunctionListBuilder.type(this.typeManager, explicitType);
            FunctionListBuilder.verifyMethodSignature(method, returnType.getTypeSignature(), Lists.transform(parameterTypes, Type::getTypeSignature), this.typeManager);
        }
        List<Boolean> nullableArguments = FunctionListBuilder.getNullableArguments(method);
        this.operator(operatorType, (Type)returnType, parameterTypes, methodHandle, method.isAnnotationPresent(Nullable.class), nullableArguments);
        return true;
    }

    private static String getDescription(AnnotatedElement annotatedElement) {
        Description description = annotatedElement.getAnnotation(Description.class);
        return description == null ? null : description.value();
    }

    private static String camelToSnake(String name) {
        return CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, name);
    }

    private static void checkValidMethod(Method method) {
        String message = "@ScalarFunction method %s is not valid: ";
        Preconditions.checkArgument((boolean)Modifier.isStatic(method.getModifiers()), (String)(message + "must be static"), (Object[])new Object[]{method});
        Preconditions.checkArgument((boolean)SUPPORTED_RETURN_TYPES.contains(Primitives.unwrap(method.getReturnType())), (String)(message + "return type not supported"), (Object[])new Object[]{method});
        if (method.getAnnotation(Nullable.class) != null) {
            Preconditions.checkArgument((!method.getReturnType().isPrimitive() ? 1 : 0) != 0, (String)(message + "annotated with @Nullable but has primitive return type"), (Object[])new Object[]{method});
        } else {
            Preconditions.checkArgument((!Primitives.isWrapperType(method.getReturnType()) ? 1 : 0) != 0, (String)"not annotated with @Nullable but has boxed primitive return type", (Object[])new Object[]{method});
        }
        for (Class<?> type : FunctionListBuilder.getParameterTypes(method.getParameterTypes())) {
            Preconditions.checkArgument((boolean)SUPPORTED_TYPES.contains(type), (String)(message + "parameter type [%s] not supported"), (Object[])new Object[]{method, type.getName()});
        }
    }

    private static List<Class<?>> getParameterTypes(Class<?> ... types) {
        ImmutableList parameterTypes = ImmutableList.copyOf((Object[])types);
        if (!parameterTypes.isEmpty() && parameterTypes.get(0) == ConnectorSession.class) {
            parameterTypes = parameterTypes.subList(1, parameterTypes.size());
        }
        return parameterTypes;
    }

    public List<ParametricFunction> getFunctions() {
        return ImmutableList.copyOf(this.functions);
    }
}

