/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.execution.Column;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class Input {
    private final String connectorId;
    private final String schema;
    private final String table;
    private final List<Column> columns;

    @JsonCreator
    public Input(@JsonProperty(value="connectorId") String connectorId, @JsonProperty(value="schema") String schema, @JsonProperty(value="table") String table, @JsonProperty(value="columns") List<Column> columns) {
        Preconditions.checkNotNull((Object)connectorId, (Object)"connectorId is null");
        Preconditions.checkNotNull((Object)schema, (Object)"schema is null");
        Preconditions.checkNotNull((Object)table, (Object)"table is null");
        Preconditions.checkNotNull(columns, (Object)"columns is null");
        this.connectorId = connectorId;
        this.schema = schema;
        this.table = table;
        this.columns = ImmutableList.copyOf(columns);
    }

    @JsonProperty
    public String getConnectorId() {
        return this.connectorId;
    }

    @JsonProperty
    public String getSchema() {
        return this.schema;
    }

    @JsonProperty
    public String getTable() {
        return this.table;
    }

    @JsonProperty
    public List<Column> getColumns() {
        return this.columns;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Input that = (Input)o;
        return Objects.equal((Object)this.connectorId, (Object)that.connectorId) && Objects.equal((Object)this.schema, (Object)that.schema) && Objects.equal((Object)this.table, (Object)that.table) && Objects.equal(this.columns, that.columns);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.connectorId, this.schema, this.table, this.columns});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.connectorId).addValue((Object)this.schema).addValue((Object)this.table).addValue(this.columns).toString();
    }
}

