/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.Session;
import com.facebook.presto.execution.DataDefinitionTask;
import com.facebook.presto.execution.QueryStateMachine;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataUtil;
import com.facebook.presto.metadata.QualifiedTableName;
import com.facebook.presto.metadata.ViewDefinition;
import com.facebook.presto.sql.analyzer.SemanticErrorCode;
import com.facebook.presto.sql.analyzer.SemanticException;
import com.facebook.presto.sql.tree.DropView;
import com.facebook.presto.sql.tree.Node;
import java.util.Optional;

public class DropViewTask
implements DataDefinitionTask<DropView> {
    @Override
    public void execute(DropView statement, Session session, Metadata metadata, QueryStateMachine stateMachine) {
        QualifiedTableName name = MetadataUtil.createQualifiedTableName(session, statement.getName());
        Optional<ViewDefinition> view = metadata.getView(session, name);
        if (!view.isPresent()) {
            throw new SemanticException(SemanticErrorCode.MISSING_TABLE, (Node)statement, "View '%s' does not exist", name);
        }
        metadata.dropView(session, name);
    }
}

