/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.Session;
import com.facebook.presto.execution.DataDefinitionTask;
import com.facebook.presto.execution.QueryStateMachine;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataUtil;
import com.facebook.presto.metadata.QualifiedTableName;
import com.facebook.presto.metadata.ViewDefinition;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.sql.SqlFormatter;
import com.facebook.presto.sql.analyzer.Analysis;
import com.facebook.presto.sql.analyzer.Analyzer;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.sql.analyzer.QueryExplainer;
import com.facebook.presto.sql.parser.ParsingException;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.tree.CreateView;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.Query;
import com.facebook.presto.sql.tree.Statement;
import com.facebook.presto.util.ImmutableCollectors;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.json.JsonCodec;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;

public class CreateViewTask
implements DataDefinitionTask<CreateView> {
    private final JsonCodec<ViewDefinition> codec;
    private final SqlParser sqlParser;
    private final List<PlanOptimizer> planOptimizers;
    private final boolean experimentalSyntaxEnabled;

    @Inject
    public CreateViewTask(JsonCodec<ViewDefinition> codec, SqlParser sqlParser, List<PlanOptimizer> planOptimizers, FeaturesConfig featuresConfig) {
        this.codec = (JsonCodec)Preconditions.checkNotNull(codec, (Object)"codec is null");
        this.sqlParser = (SqlParser)Preconditions.checkNotNull((Object)sqlParser, (Object)"sqlParser is null");
        this.planOptimizers = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(planOptimizers, (Object)"planOptimizers is null")));
        Preconditions.checkNotNull((Object)featuresConfig, (Object)"featuresConfig is null");
        this.experimentalSyntaxEnabled = featuresConfig.isExperimentalSyntaxEnabled();
    }

    @Override
    public void execute(CreateView statement, Session session, Metadata metadata, QueryStateMachine stateMachine) {
        QualifiedTableName name = MetadataUtil.createQualifiedTableName(session, statement.getName());
        String sql = this.getFormattedSql(statement);
        Analysis analysis = this.analyzeStatement((Statement)statement, session, metadata);
        List columns = (List)analysis.getOutputDescriptor().getVisibleFields().stream().map(field -> new ViewDefinition.ViewColumn(field.getName().get(), field.getType())).collect(ImmutableCollectors.toImmutableList());
        String data = this.codec.toJson((Object)new ViewDefinition(sql, session.getCatalog(), session.getSchema(), columns));
        metadata.createView(session, name, data, statement.isReplace());
    }

    public Analysis analyzeStatement(Statement statement, Session session, Metadata metadata) {
        QueryExplainer explainer = new QueryExplainer(session, this.planOptimizers, metadata, this.sqlParser, this.experimentalSyntaxEnabled);
        Analyzer analyzer = new Analyzer(session, metadata, this.sqlParser, Optional.of(explainer), this.experimentalSyntaxEnabled);
        return analyzer.analyze(statement);
    }

    private String getFormattedSql(CreateView statement) {
        Statement parsed;
        Query query = statement.getQuery();
        String sql = SqlFormatter.formatSql((Node)query);
        try {
            parsed = this.sqlParser.createStatement(sql);
        }
        catch (ParsingException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INTERNAL_ERROR, "Formatted query does not parse: " + query);
        }
        if (!query.equals((Object)parsed)) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INTERNAL_ERROR, "Query does not round-trip: " + query);
        }
        return sql;
    }
}

