/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.connector.system;

import com.facebook.presto.connector.system.SystemColumnHandle;
import com.facebook.presto.connector.system.SystemSplit;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorColumnHandle;
import com.facebook.presto.spi.ConnectorRecordSetProvider;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.RecordSet;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.SystemTable;
import com.facebook.presto.split.MappedRecordSet;
import com.facebook.presto.util.Types;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class SystemRecordSetProvider
implements ConnectorRecordSetProvider {
    private final ConcurrentMap<SchemaTableName, SystemTable> tables = new ConcurrentHashMap<SchemaTableName, SystemTable>();

    public void addTable(SystemTable systemTable) {
        Preconditions.checkNotNull((Object)systemTable, (Object)"systemTable is null");
        SchemaTableName tableName = systemTable.getTableMetadata().getTable();
        Preconditions.checkArgument((this.tables.putIfAbsent(tableName, systemTable) == null ? 1 : 0) != 0, (String)"Table %s is already registered", (Object[])new Object[]{tableName});
    }

    public RecordSet getRecordSet(ConnectorSplit split, List<? extends ConnectorColumnHandle> columns) {
        SchemaTableName tableName = Types.checkType(split, SystemSplit.class, "split").getTableHandle().getSchemaTableName();
        Preconditions.checkNotNull(columns, (Object)"columns is null");
        SystemTable systemTable = (SystemTable)this.tables.get(tableName);
        Preconditions.checkArgument((systemTable != null ? 1 : 0) != 0, (String)"Table %s does not exist", (Object[])new Object[]{tableName});
        ImmutableMap columnsByName = Maps.uniqueIndex((Iterable)systemTable.getTableMetadata().getColumns(), ColumnMetadata::getName);
        ImmutableList.Builder userToSystemFieldIndex = ImmutableList.builder();
        for (ConnectorColumnHandle connectorColumnHandle : columns) {
            String columnName = Types.checkType(connectorColumnHandle, SystemColumnHandle.class, "column").getColumnName();
            ColumnMetadata columnMetadata = (ColumnMetadata)columnsByName.get(columnName);
            Preconditions.checkArgument((columnMetadata != null ? 1 : 0) != 0, (String)"Column %s.%s does not exist", (Object[])new Object[]{tableName, columnName});
            userToSystemFieldIndex.add((Object)columnMetadata.getOrdinalPosition());
        }
        return new MappedRecordSet((RecordSet)systemTable, (List<Integer>)userToSystemFieldIndex.build());
    }
}

