/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.connector.system;

import com.facebook.presto.execution.QueryInfo;
import com.facebook.presto.execution.QueryManager;
import com.facebook.presto.execution.QueryStats;
import com.facebook.presto.metadata.MetadataUtil;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.InMemoryRecordSet;
import com.facebook.presto.spi.RecordCursor;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.SystemTable;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.airlift.node.NodeInfo;
import io.airlift.units.Duration;
import java.util.List;
import javax.inject.Inject;
import org.joda.time.DateTime;

public class QuerySystemTable
implements SystemTable {
    public static final SchemaTableName QUERY_TABLE_NAME = new SchemaTableName("sys", "query");
    public static final ConnectorTableMetadata QUERY_TABLE = MetadataUtil.TableMetadataBuilder.tableMetadataBuilder(QUERY_TABLE_NAME).column("node_id", (Type)VarcharType.VARCHAR).column("query_id", (Type)VarcharType.VARCHAR).column("state", (Type)VarcharType.VARCHAR).column("user", (Type)VarcharType.VARCHAR).column("query", (Type)VarcharType.VARCHAR).column("queued_time_ms", (Type)BigintType.BIGINT).column("analysis_time_ms", (Type)BigintType.BIGINT).column("distributed_planning_time_ms", (Type)BigintType.BIGINT).column("created", (Type)BigintType.BIGINT).column("started", (Type)BigintType.BIGINT).column("last_heartbeat", (Type)BigintType.BIGINT).column("end", (Type)BigintType.BIGINT).build();
    private final QueryManager queryManager;
    private final String nodeId;

    @Inject
    public QuerySystemTable(QueryManager queryManager, NodeInfo nodeInfo) {
        this.queryManager = queryManager;
        this.nodeId = nodeInfo.getNodeId();
    }

    public boolean isDistributed() {
        return true;
    }

    public ConnectorTableMetadata getTableMetadata() {
        return QUERY_TABLE;
    }

    public List<Type> getColumnTypes() {
        return ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)QUERY_TABLE.getColumns(), ColumnMetadata::getType));
    }

    public RecordCursor cursor() {
        InMemoryRecordSet.Builder table = InMemoryRecordSet.builder((ConnectorTableMetadata)QUERY_TABLE);
        for (QueryInfo queryInfo : this.queryManager.getAllQueryInfo()) {
            QueryStats queryStats = queryInfo.getQueryStats();
            table.addRow(new Object[]{this.nodeId, queryInfo.getQueryId().toString(), queryInfo.getState().toString(), queryInfo.getSession().getUser(), queryInfo.getQuery(), this.toMillis(queryStats.getQueuedTime()), this.toMillis(queryStats.getAnalysisTime()), this.toMillis(queryStats.getDistributedPlanningTime()), this.toTimeStamp(queryStats.getCreateTime()), this.toTimeStamp(queryStats.getExecutionStartTime()), this.toTimeStamp(queryStats.getLastHeartbeat()), this.toTimeStamp(queryStats.getEndTime())});
        }
        return table.build().cursor();
    }

    private Long toMillis(Duration duration) {
        if (duration == null) {
            return null;
        }
        return duration.toMillis();
    }

    private Long toTimeStamp(DateTime dateTime) {
        if (dateTime == null) {
            return null;
        }
        return dateTime.getMillis();
    }
}

