/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.connector.jmx;

import com.facebook.presto.connector.jmx.JmxColumnHandle;
import com.facebook.presto.connector.jmx.JmxSplit;
import com.facebook.presto.connector.jmx.JmxTableHandle;
import com.facebook.presto.spi.ConnectorColumnHandle;
import com.facebook.presto.spi.ConnectorRecordSetProvider;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.InMemoryRecordSet;
import com.facebook.presto.spi.NodeManager;
import com.facebook.presto.spi.RecordSet;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.util.Types;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slice;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.management.Attribute;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class JmxRecordSetProvider
implements ConnectorRecordSetProvider {
    private final MBeanServer mbeanServer;
    private final String nodeId;

    @Inject
    public JmxRecordSetProvider(MBeanServer mbeanServer, NodeManager nodeManager) {
        this.mbeanServer = (MBeanServer)Preconditions.checkNotNull((Object)mbeanServer, (Object)"mbeanServer is null");
        this.nodeId = ((NodeManager)Preconditions.checkNotNull((Object)nodeManager, (Object)"nodeManager is null")).getCurrentNode().getNodeIdentifier();
    }

    /*
     * WARNING - void declaration
     */
    public RecordSet getRecordSet(ConnectorSplit split, List<? extends ConnectorColumnHandle> columns) {
        void var6_9;
        JmxTableHandle tableHandle = Types.checkType(split, JmxSplit.class, "split").getTableHandle();
        Preconditions.checkNotNull(columns, (Object)"columns is null");
        Preconditions.checkArgument((!columns.isEmpty() ? 1 : 0) != 0, (Object)"must provide at least one column");
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (ConnectorColumnHandle connectorColumnHandle : columns) {
            JmxColumnHandle jmxColumnHandle = Types.checkType(connectorColumnHandle, JmxColumnHandle.class, "column");
            builder.put((Object)jmxColumnHandle.getColumnName(), (Object)jmxColumnHandle.getColumnType());
        }
        ImmutableMap columnTypes = builder.build();
        try {
            Map<String, Object> attributes = this.getAttributes((Set<String>)columnTypes.keySet(), tableHandle);
            ArrayList<Object> row = new ArrayList<Object>();
            for (Map.Entry entry : columnTypes.entrySet()) {
                if (((String)entry.getKey()).equals("node")) {
                    row.add(this.nodeId);
                    continue;
                }
                Object value = attributes.get(entry.getKey());
                if (value == null) {
                    row.add(null);
                    continue;
                }
                Class javaType = ((Type)entry.getValue()).getJavaType();
                if (javaType == Boolean.TYPE) {
                    if (value instanceof Boolean) {
                        row.add(value);
                        continue;
                    }
                    row.add(null);
                    continue;
                }
                if (javaType == Long.TYPE) {
                    if (value instanceof Number) {
                        row.add(((Number)value).longValue());
                        continue;
                    }
                    row.add(null);
                    continue;
                }
                if (javaType == Double.TYPE) {
                    if (value instanceof Number) {
                        row.add(((Number)value).doubleValue());
                        continue;
                    }
                    row.add(null);
                    continue;
                }
                if (javaType != Slice.class) continue;
                if (value.getClass().isArray()) {
                    if (value.getClass().getComponentType() == String.class) {
                        row.add(Arrays.toString((String[])value));
                        continue;
                    }
                    if (value.getClass().getComponentType() == Boolean.TYPE) {
                        row.add(Arrays.toString((boolean[])value));
                        continue;
                    }
                    if (value.getClass().getComponentType() == Byte.TYPE) {
                        row.add(Arrays.toString((byte[])value));
                        continue;
                    }
                    if (value.getClass().getComponentType() == Character.TYPE) {
                        row.add(Arrays.toString((char[])value));
                        continue;
                    }
                    if (value.getClass().getComponentType() == Double.TYPE) {
                        row.add(Arrays.toString((double[])value));
                        continue;
                    }
                    if (value.getClass().getComponentType() == Float.TYPE) {
                        row.add(Arrays.toString((float[])value));
                        continue;
                    }
                    if (value.getClass().getComponentType() == Integer.TYPE) {
                        row.add(Arrays.toString((int[])value));
                        continue;
                    }
                    if (value.getClass().getComponentType() == Long.TYPE) {
                        row.add(Arrays.toString((long[])value));
                        continue;
                    }
                    if (value.getClass().getComponentType() != Short.TYPE) continue;
                    row.add(Arrays.toString((short[])value));
                    continue;
                }
                row.add(value.toString());
            }
            ImmutableList immutableList = ImmutableList.of(row);
        }
        catch (JMException e) {
            ImmutableList immutableList = ImmutableList.of();
        }
        return new InMemoryRecordSet((Collection)columnTypes.values(), (Collection)var6_9);
    }

    private Map<String, Object> getAttributes(Set<String> uniqueColumnNames, JmxTableHandle tableHandle) throws JMException {
        ObjectName objectName = new ObjectName(tableHandle.getObjectName());
        String[] columnNamesArray = uniqueColumnNames.toArray(new String[uniqueColumnNames.size()]);
        return this.mbeanServer.getAttributes(objectName, columnNamesArray).asList().stream().collect(Collectors.toMap(Attribute::getName, Attribute::getValue));
    }
}

