/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.connector.jmx;

import com.facebook.presto.connector.jmx.JmxConnectorId;
import com.facebook.presto.connector.jmx.JmxHandleResolver;
import com.facebook.presto.connector.jmx.JmxMetadata;
import com.facebook.presto.connector.jmx.JmxRecordSetProvider;
import com.facebook.presto.connector.jmx.JmxSplitManager;
import com.facebook.presto.spi.Connector;
import com.facebook.presto.spi.ConnectorFactory;
import com.facebook.presto.spi.ConnectorHandleResolver;
import com.facebook.presto.spi.ConnectorIndexResolver;
import com.facebook.presto.spi.ConnectorMetadata;
import com.facebook.presto.spi.ConnectorPageSourceProvider;
import com.facebook.presto.spi.ConnectorRecordSetProvider;
import com.facebook.presto.spi.ConnectorRecordSinkProvider;
import com.facebook.presto.spi.ConnectorSplitManager;
import com.facebook.presto.spi.NodeManager;
import com.google.common.base.Preconditions;
import java.util.Map;
import javax.inject.Inject;
import javax.management.MBeanServer;

public class JmxConnectorFactory
implements ConnectorFactory {
    private final MBeanServer mbeanServer;
    private final NodeManager nodeManager;

    @Inject
    public JmxConnectorFactory(MBeanServer mbeanServer, NodeManager nodeManager) {
        this.mbeanServer = (MBeanServer)Preconditions.checkNotNull((Object)mbeanServer, (Object)"mbeanServer is null");
        this.nodeManager = (NodeManager)Preconditions.checkNotNull((Object)nodeManager, (Object)"nodeManager is null");
    }

    public String getName() {
        return "jmx";
    }

    public Connector create(final String connectorId, Map<String, String> properties) {
        return new Connector(){

            public ConnectorHandleResolver getHandleResolver() {
                return new JmxHandleResolver();
            }

            public ConnectorMetadata getMetadata() {
                return new JmxMetadata(new JmxConnectorId(connectorId), JmxConnectorFactory.this.mbeanServer);
            }

            public ConnectorSplitManager getSplitManager() {
                return new JmxSplitManager(new JmxConnectorId(connectorId), JmxConnectorFactory.this.nodeManager);
            }

            public ConnectorPageSourceProvider getPageSourceProvider() {
                throw new UnsupportedOperationException();
            }

            public ConnectorRecordSetProvider getRecordSetProvider() {
                return new JmxRecordSetProvider(JmxConnectorFactory.this.mbeanServer, JmxConnectorFactory.this.nodeManager);
            }

            public ConnectorRecordSinkProvider getRecordSinkProvider() {
                throw new UnsupportedOperationException();
            }

            public ConnectorIndexResolver getIndexResolver() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

