/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.byteCode.instruction;

import com.facebook.presto.byteCode.ByteCodeNode;
import com.facebook.presto.byteCode.ByteCodeVisitor;
import com.facebook.presto.byteCode.OpCode;
import com.facebook.presto.byteCode.ParameterizedType;
import com.facebook.presto.byteCode.Variable;
import com.facebook.presto.byteCode.instruction.InstructionNode;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public abstract class VariableInstruction
implements InstructionNode {
    private final Variable variable;

    public static InstructionNode loadVariable(int slot) {
        return new LoadVariableInstruction(new Variable("unknown", slot, ParameterizedType.type(Object.class)));
    }

    public static InstructionNode loadVariable(Variable variable) {
        return new LoadVariableInstruction(variable);
    }

    public static InstructionNode storeVariable(Variable variable) {
        return new StoreVariableInstruction(variable);
    }

    public static InstructionNode incrementVariable(Variable variable, byte increment) {
        return new IncrementVariableInstruction(variable, increment);
    }

    private VariableInstruction(Variable variable) {
        this.variable = variable;
    }

    public Variable getVariable() {
        return this.variable;
    }

    @Override
    public List<ByteCodeNode> getChildNodes() {
        return ImmutableList.of();
    }

    @Override
    public <T> T accept(ByteCodeNode parent, ByteCodeVisitor<T> visitor) {
        return visitor.visitVariableInstruction(parent, this);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("variable", (Object)this.variable).toString();
    }

    public static class IncrementVariableInstruction
    extends VariableInstruction {
        private final byte increment;

        public IncrementVariableInstruction(Variable variable, byte increment) {
            super(variable);
            String type = variable.getType().getClassName();
            Preconditions.checkArgument((boolean)ImmutableList.of((Object)"byte", (Object)"short", (Object)"int").contains((Object)type), (String)"variable must be an byte, short or int, but is %s", (Object[])new Object[]{type});
            this.increment = increment;
        }

        public byte getIncrement() {
            return this.increment;
        }

        @Override
        public void accept(MethodVisitor visitor) {
            visitor.visitIincInsn(this.getVariable().getSlot(), (int)this.increment);
        }

        @Override
        public <T> T accept(ByteCodeNode parent, ByteCodeVisitor<T> visitor) {
            return visitor.visitIncrementVariable(parent, this);
        }
    }

    public static class StoreVariableInstruction
    extends VariableInstruction {
        public StoreVariableInstruction(Variable variable) {
            super(variable);
        }

        @Override
        public void accept(MethodVisitor visitor) {
            visitor.visitVarInsn(Type.getType((String)this.getVariable().getType().getType()).getOpcode(OpCode.ISTORE.getOpCode()), this.getVariable().getSlot());
        }

        @Override
        public <T> T accept(ByteCodeNode parent, ByteCodeVisitor<T> visitor) {
            return visitor.visitStoreVariable(parent, this);
        }
    }

    public static class LoadVariableInstruction
    extends VariableInstruction {
        public LoadVariableInstruction(Variable variable) {
            super(variable);
        }

        @Override
        public void accept(MethodVisitor visitor) {
            visitor.visitVarInsn(Type.getType((String)this.getVariable().getType().getType()).getOpcode(OpCode.ILOAD.getOpCode()), this.getVariable().getSlot());
        }

        @Override
        public <T> T accept(ByteCodeNode parent, ByteCodeVisitor<T> visitor) {
            return visitor.visitLoadVariable(parent, this);
        }
    }
}

