/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.byteCode.expression;

import com.facebook.presto.byteCode.Access;
import com.facebook.presto.byteCode.Block;
import com.facebook.presto.byteCode.ByteCodeNode;
import com.facebook.presto.byteCode.FieldDefinition;
import com.facebook.presto.byteCode.ParameterizedType;
import com.facebook.presto.byteCode.expression.ByteCodeExpression;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.List;
import javax.annotation.Nullable;

class SetFieldByteCodeExpression
extends ByteCodeExpression {
    private final ByteCodeExpression instance;
    private final ParameterizedType declaringClass;
    private final String name;
    private final ByteCodeExpression value;
    private final ParameterizedType fieldType;

    public SetFieldByteCodeExpression(@Nullable ByteCodeExpression instance, Class<?> declaringClass, String name, ByteCodeExpression value) {
        this(instance, SetFieldByteCodeExpression.getDeclaredField(declaringClass, name), value);
    }

    public SetFieldByteCodeExpression(@Nullable ByteCodeExpression instance, Field field, ByteCodeExpression value) {
        this(instance, ParameterizedType.type(((Field)Preconditions.checkNotNull((Object)field, (Object)"field is null")).getDeclaringClass()), field.getName(), value, ParameterizedType.type(field.getType()));
        boolean isStatic = Modifier.isStatic(field.getModifiers());
        if (instance == null) {
            Preconditions.checkArgument((boolean)isStatic, (String)"Field is not static: %s", (Object[])new Object[]{field});
        } else {
            Preconditions.checkArgument((!isStatic ? 1 : 0) != 0, (String)"Field is static: %s", (Object[])new Object[]{field});
        }
    }

    public SetFieldByteCodeExpression(@Nullable ByteCodeExpression instance, FieldDefinition field, ByteCodeExpression value) {
        this(instance, ((FieldDefinition)Preconditions.checkNotNull((Object)field, (Object)"field is null")).getDeclaringClass().getType(), field.getName(), value, field.getType());
        if (instance == null) {
            Preconditions.checkArgument((boolean)field.getAccess().contains((Object)Access.STATIC), (String)"Field is not static: %s", (Object[])new Object[]{field});
        } else {
            Preconditions.checkArgument((!field.getAccess().contains((Object)Access.STATIC) ? 1 : 0) != 0, (String)"Field is static: %s", (Object[])new Object[]{field});
        }
    }

    public SetFieldByteCodeExpression(@Nullable ByteCodeExpression instance, ParameterizedType declaringClass, String name, ByteCodeExpression value) {
        this(instance, declaringClass, name, value, value.getType());
    }

    public SetFieldByteCodeExpression(@Nullable ByteCodeExpression instance, ParameterizedType declaringClass, String name, ByteCodeExpression value, ParameterizedType fieldType) {
        super(ParameterizedType.type(Void.TYPE));
        if (instance != null) {
            Preconditions.checkArgument((!instance.getType().isPrimitive() ? 1 : 0) != 0, (String)"Type %s does not have fields", (Object[])new Object[]{instance.getType()});
        }
        this.instance = instance;
        this.declaringClass = (ParameterizedType)Preconditions.checkNotNull((Object)declaringClass, (Object)"declaringClass is null");
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name is null");
        this.fieldType = (ParameterizedType)Preconditions.checkNotNull((Object)fieldType, (Object)"fieldType is null");
        this.value = (ByteCodeExpression)Preconditions.checkNotNull((Object)value, (Object)"value is null");
    }

    @Override
    public ByteCodeNode getByteCode() {
        if (this.instance == null) {
            return new Block(null).append(this.value.getByteCode()).putStaticField(this.declaringClass, this.name, this.fieldType);
        }
        return new Block(null).append(this.instance.getByteCode()).append(this.value.getByteCode()).putField(this.declaringClass, this.name, this.fieldType);
    }

    @Override
    protected String formatOneLine() {
        if (this.instance == null) {
            return this.declaringClass.getSimpleName() + "." + this.name + " = " + this.value;
        }
        return this.instance + "." + this.name + " = " + this.value;
    }

    @Override
    public List<ByteCodeNode> getChildNodes() {
        ImmutableList.Builder children = ImmutableList.builder();
        if (this.instance != null) {
            children.add((Object)this.instance);
        }
        children.add((Object)this.value);
        return children.build();
    }

    private static Field getDeclaredField(Class<?> declaringClass, String name) {
        Preconditions.checkNotNull(declaringClass, (Object)"declaringClass is null");
        Preconditions.checkNotNull((Object)name, (Object)"name is null");
        try {
            return declaringClass.getField(name);
        }
        catch (NoSuchFieldException e) {
            throw new IllegalArgumentException(String.format("Class %s does not have a '%s' field", declaringClass.getName(), name));
        }
    }
}

