/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.byteCode.expression;

import com.facebook.presto.byteCode.Block;
import com.facebook.presto.byteCode.ByteCodeNode;
import com.facebook.presto.byteCode.OpCode;
import com.facebook.presto.byteCode.expression.ArithmeticByteCodeExpression;
import com.facebook.presto.byteCode.expression.ByteCodeExpression;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;

class NegateByteCodeExpression
extends ByteCodeExpression {
    private final ByteCodeExpression value;
    private final OpCode negateOpCode;

    NegateByteCodeExpression(ByteCodeExpression value) {
        super(((ByteCodeExpression)Preconditions.checkNotNull((Object)value, (Object)"value is null")).getType());
        this.value = value;
        Class<?> type = value.getType().getPrimitiveType();
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"value is not a primitive");
        Preconditions.checkArgument((type != Void.TYPE ? 1 : 0) != 0, (Object)"value is void");
        Preconditions.checkArgument((type == Integer.TYPE || type == Long.TYPE || type == Float.TYPE || type == Double.TYPE ? 1 : 0) != 0, (String)"value argument must be int, long, float, or double, but is %s", (Object[])new Object[]{type});
        this.negateOpCode = ArithmeticByteCodeExpression.getNumericOpCode("Negate", OpCode.INEG, type);
    }

    @Override
    public ByteCodeNode getByteCode() {
        return new Block(null).append(this.value).append(this.negateOpCode);
    }

    @Override
    public List<ByteCodeNode> getChildNodes() {
        return ImmutableList.of((Object)this.value);
    }

    @Override
    protected String formatOneLine() {
        return "-(" + this.value + ")";
    }
}

