/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.byteCode.expression;

import com.facebook.presto.byteCode.ByteCodeNode;
import com.facebook.presto.byteCode.ParameterizedType;
import com.facebook.presto.byteCode.expression.ByteCodeExpression;
import com.facebook.presto.byteCode.instruction.Constant;
import com.google.common.collect.ImmutableList;
import java.util.List;

class ConstantByteCodeExpression
extends ByteCodeExpression {
    private final Constant value;

    public ConstantByteCodeExpression(Class<?> type, Constant value) {
        this(ParameterizedType.type(type), value);
    }

    public ConstantByteCodeExpression(ParameterizedType type, Constant value) {
        super(type);
        this.value = value;
    }

    @Override
    public Constant getByteCode() {
        return this.value;
    }

    @Override
    protected String formatOneLine() {
        return ConstantByteCodeExpression.renderConstant(this.value.getValue());
    }

    public static String renderConstant(Object value) {
        if (value instanceof Long) {
            return value + "L";
        }
        if (value instanceof Float) {
            return value + "f";
        }
        if (value instanceof ParameterizedType) {
            return ((ParameterizedType)value).getSimpleName() + ".class";
        }
        if (value instanceof String) {
            return "\"" + value + "\"";
        }
        return String.valueOf(value);
    }

    @Override
    public List<ByteCodeNode> getChildNodes() {
        return ImmutableList.of();
    }
}

