/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.byteCode.expression;

import com.facebook.presto.byteCode.Block;
import com.facebook.presto.byteCode.ByteCodeNode;
import com.facebook.presto.byteCode.OpCode;
import com.facebook.presto.byteCode.ParameterizedType;
import com.facebook.presto.byteCode.expression.ByteCodeExpression;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;

public class ArithmeticByteCodeExpression
extends ByteCodeExpression {
    private final String infixSymbol;
    private final OpCode opCode;
    private final ByteCodeExpression left;
    private final ByteCodeExpression right;

    public static ByteCodeExpression createArithmeticByteCodeExpression(OpCode baseOpCode, ByteCodeExpression left, ByteCodeExpression right) {
        Preconditions.checkNotNull((Object)baseOpCode, (Object)"baseOpCode is null");
        String name = ArithmeticByteCodeExpression.getName(baseOpCode);
        String infixSymbol = ArithmeticByteCodeExpression.getInfixSymbol(baseOpCode);
        ArithmeticByteCodeExpression.checkArgumentTypes(baseOpCode, name, left, right);
        OpCode opCode = ArithmeticByteCodeExpression.getNumericOpCode(name, baseOpCode, left.getType().getPrimitiveType());
        return new ArithmeticByteCodeExpression(infixSymbol, left.getType(), opCode, left, right);
    }

    private static String getName(OpCode baseOpCode) {
        switch (baseOpCode) {
            case IAND: {
                return "Bitwise AND";
            }
            case IOR: {
                return "Bitwise OR";
            }
            case IXOR: {
                return "Bitwise XOR";
            }
            case IADD: {
                return "Add";
            }
            case ISUB: {
                return "Subtract";
            }
            case IMUL: {
                return "Multiply";
            }
            case IDIV: {
                return "Divide";
            }
            case IREM: {
                return "Remainder";
            }
            case ISHL: {
                return "Shift left";
            }
            case ISHR: {
                return "Shift right";
            }
            case IUSHR: {
                return "Shift right unsigned";
            }
        }
        throw new IllegalArgumentException("Unsupported OpCode " + baseOpCode);
    }

    private static String getInfixSymbol(OpCode baseOpCode) {
        switch (baseOpCode) {
            case IAND: {
                return "&";
            }
            case IOR: {
                return "|";
            }
            case IXOR: {
                return "^";
            }
            case IADD: {
                return "+";
            }
            case ISUB: {
                return "-";
            }
            case IMUL: {
                return "*";
            }
            case IDIV: {
                return "/";
            }
            case IREM: {
                return "%";
            }
            case ISHL: {
                return "<<";
            }
            case ISHR: {
                return ">>";
            }
            case IUSHR: {
                return ">>>";
            }
        }
        throw new IllegalArgumentException("Unsupported OpCode " + baseOpCode);
    }

    private static void checkArgumentTypes(OpCode baseOpCode, String name, ByteCodeExpression left, ByteCodeExpression right) {
        Class<?> leftType = ArithmeticByteCodeExpression.getPrimitiveType(left, "left");
        Class<?> rightType = ArithmeticByteCodeExpression.getPrimitiveType(right, "right");
        switch (baseOpCode) {
            case IAND: 
            case IOR: 
            case IXOR: {
                Preconditions.checkArgument((leftType == rightType ? 1 : 0) != 0, (Object)"left and right must be the same type");
                Preconditions.checkArgument((leftType == Integer.TYPE || leftType == Long.TYPE ? 1 : 0) != 0, (String)"%s argument must be int or long, but is %s", (Object[])new Object[]{name, leftType});
                return;
            }
            case IADD: 
            case ISUB: 
            case IMUL: 
            case IDIV: 
            case IREM: {
                Preconditions.checkArgument((leftType == rightType ? 1 : 0) != 0, (Object)"left and right must be the same type");
                Preconditions.checkArgument((leftType == Integer.TYPE || leftType == Long.TYPE || leftType == Float.TYPE || leftType == Double.TYPE ? 1 : 0) != 0, (String)"%s argument must be int, long, float, or double, but is %s", (Object[])new Object[]{name, leftType});
                return;
            }
            case ISHL: 
            case ISHR: 
            case IUSHR: {
                Preconditions.checkArgument((leftType == Integer.TYPE || leftType == Long.TYPE ? 1 : 0) != 0, (String)"%s left argument be int or long, but is %s", (Object[])new Object[]{name, leftType});
                Preconditions.checkArgument((rightType == Integer.TYPE ? 1 : 0) != 0, (String)"%s right argument be and int, but is %s", (Object[])new Object[]{name, rightType});
                return;
            }
        }
        throw new IllegalArgumentException("Unsupported OpCode " + baseOpCode);
    }

    static OpCode getNumericOpCode(String name, OpCode baseOpCode, Class<?> type) {
        if (type == Integer.TYPE) {
            return baseOpCode;
        }
        if (type == Long.TYPE) {
            return OpCode.getOpCode(baseOpCode.getOpCode() + 1);
        }
        if (type == Float.TYPE) {
            return OpCode.getOpCode(baseOpCode.getOpCode() + 2);
        }
        if (type == Double.TYPE) {
            return OpCode.getOpCode(baseOpCode.getOpCode() + 3);
        }
        throw new IllegalArgumentException(name + " does not support " + type);
    }

    private static Class<?> getPrimitiveType(ByteCodeExpression expression, String name) {
        Preconditions.checkNotNull((Object)expression, (Object)(name + " is null"));
        Class<?> leftType = expression.getType().getPrimitiveType();
        Preconditions.checkArgument((leftType != null ? 1 : 0) != 0, (Object)(name + " is not a primitive"));
        Preconditions.checkArgument((leftType != Void.TYPE ? 1 : 0) != 0, (Object)(name + " is void"));
        return leftType;
    }

    private ArithmeticByteCodeExpression(String infixSymbol, ParameterizedType type, OpCode opCode, ByteCodeExpression left, ByteCodeExpression right) {
        super(type);
        this.infixSymbol = infixSymbol;
        this.opCode = opCode;
        this.left = left;
        this.right = right;
    }

    @Override
    public ByteCodeNode getByteCode() {
        return new Block(null).append(this.left).append(this.right).append(this.opCode);
    }

    @Override
    public List<ByteCodeNode> getChildNodes() {
        return ImmutableList.of((Object)this.left, (Object)this.right);
    }

    @Override
    protected String formatOneLine() {
        return "(" + this.left + " " + this.infixSymbol + " " + this.right + ")";
    }
}

