/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.byteCode.control;

import com.facebook.presto.byteCode.Block;
import com.facebook.presto.byteCode.ByteCodeNode;
import com.facebook.presto.byteCode.ByteCodeNodeFactory;
import com.facebook.presto.byteCode.ByteCodeNodes;
import com.facebook.presto.byteCode.ByteCodeVisitor;
import com.facebook.presto.byteCode.CompilerContext;
import com.facebook.presto.byteCode.ExpectedType;
import com.facebook.presto.byteCode.control.FlowControl;
import com.facebook.presto.byteCode.instruction.LabelNode;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.objectweb.asm.MethodVisitor;

public class IfStatement
implements FlowControl {
    private final CompilerContext context;
    private final String comment;
    private final ByteCodeNode condition;
    private final ByteCodeNode ifTrue;
    private final ByteCodeNode ifFalse;
    private final LabelNode falseLabel = new LabelNode("false");
    private final LabelNode outLabel = new LabelNode("out");

    public static IfStatementBuilder ifStatementBuilder(CompilerContext context) {
        return new IfStatementBuilder(context);
    }

    public IfStatement(CompilerContext context, ByteCodeNode condition, ByteCodeNode ifTrue, ByteCodeNode ifFalse) {
        this(context, null, condition, ifTrue, ifFalse);
    }

    public IfStatement(CompilerContext context, String comment, ByteCodeNode condition, ByteCodeNode ifTrue, ByteCodeNode ifFalse) {
        this.context = context;
        this.comment = comment;
        this.condition = condition;
        this.ifTrue = ifTrue;
        this.ifFalse = ifFalse;
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    public ByteCodeNode getCondition() {
        return this.condition;
    }

    public ByteCodeNode getIfTrue() {
        return this.ifTrue;
    }

    public ByteCodeNode getIfFalse() {
        return this.ifFalse;
    }

    @Override
    public void accept(MethodVisitor visitor) {
        Block block = new Block(this.context);
        block.append(this.condition).ifZeroGoto(this.falseLabel).append(this.ifTrue);
        if (this.ifFalse != null) {
            block.gotoLabel(this.outLabel).visitLabel(this.falseLabel).append(this.ifFalse).visitLabel(this.outLabel);
        } else {
            block.visitLabel(this.falseLabel);
        }
        block.accept(visitor);
    }

    @Override
    public List<ByteCodeNode> getChildNodes() {
        if (this.ifFalse == null) {
            return ImmutableList.of((Object)this.condition, (Object)this.ifTrue);
        }
        return ImmutableList.of((Object)this.condition, (Object)this.ifTrue, (Object)this.ifFalse);
    }

    @Override
    public <T> T accept(ByteCodeNode parent, ByteCodeVisitor<T> visitor) {
        return visitor.visitIf(parent, this);
    }

    public static class IfStatementBuilder {
        private final CompilerContext context;
        private String comment;
        private ByteCodeNode condition;
        private ByteCodeNode ifTrue;
        private ByteCodeNode ifFalse;

        public IfStatementBuilder(CompilerContext context) {
            this.context = context;
        }

        public IfStatementBuilder comment(String format, Object ... args) {
            this.comment = String.format(format, args);
            return this;
        }

        public IfStatementBuilder condition(ByteCodeNode condition) {
            this.condition = ByteCodeNodes.buildBlock(this.context, condition, "condition");
            return this;
        }

        public IfStatementBuilder condition(ByteCodeNodeFactory condition) {
            this.condition = ByteCodeNodes.buildBlock(this.context, condition, ExpectedType.BOOLEAN, "condition");
            return this;
        }

        public IfStatementBuilder ifTrue(ByteCodeNode ifTrue) {
            this.ifTrue = ByteCodeNodes.buildBlock(this.context, ifTrue, "ifTrue");
            return this;
        }

        public IfStatementBuilder ifTrue(ByteCodeNodeFactory ifTrue) {
            this.ifTrue = ByteCodeNodes.buildBlock(this.context, ifTrue, ExpectedType.VOID, "ifTrue");
            return this;
        }

        public IfStatementBuilder ifFalse(ByteCodeNode ifFalse) {
            this.ifFalse = ByteCodeNodes.buildBlock(this.context, ifFalse, "ifFalse");
            return this;
        }

        public IfStatementBuilder ifFalse(ByteCodeNodeFactory ifFalse) {
            this.ifFalse = ByteCodeNodes.buildBlock(this.context, ifFalse, ExpectedType.VOID, "ifFalse");
            return this;
        }

        public IfStatement build() {
            IfStatement ifStatement = new IfStatement(this.context, this.comment, this.condition, this.ifTrue, this.ifFalse);
            return ifStatement;
        }
    }
}

