/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.byteCode.control;

import com.facebook.presto.byteCode.Block;
import com.facebook.presto.byteCode.ByteCodeNode;
import com.facebook.presto.byteCode.ByteCodeNodeFactory;
import com.facebook.presto.byteCode.ByteCodeNodes;
import com.facebook.presto.byteCode.ByteCodeVisitor;
import com.facebook.presto.byteCode.CompilerContext;
import com.facebook.presto.byteCode.ExpectedType;
import com.facebook.presto.byteCode.control.FlowControl;
import com.facebook.presto.byteCode.instruction.LabelNode;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.objectweb.asm.MethodVisitor;

public class ForLoop
implements FlowControl {
    private final CompilerContext context;
    private final String comment;
    private final ByteCodeNode initialize;
    private final ByteCodeNode condition;
    private final ByteCodeNode update;
    private final ByteCodeNode body;
    private final LabelNode beginLabel = new LabelNode("beginLabel");
    private final LabelNode continueLabel;
    private final LabelNode endLabel;

    public static ForLoopBuilder forLoopBuilder(CompilerContext context) {
        return new ForLoopBuilder(context);
    }

    private ForLoop(CompilerContext context, String comment, ByteCodeNode initialize, ByteCodeNode condition, ByteCodeNode update, ByteCodeNode body, LabelNode continueLabel, LabelNode endLabel) {
        this.context = context;
        this.comment = comment;
        this.initialize = initialize;
        this.condition = condition;
        this.update = update;
        this.body = body;
        this.continueLabel = continueLabel;
        this.endLabel = endLabel;
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    public ByteCodeNode getInitialize() {
        return this.initialize;
    }

    public ByteCodeNode getCondition() {
        return this.condition;
    }

    public ByteCodeNode getUpdate() {
        return this.update;
    }

    public ByteCodeNode getBody() {
        return this.body;
    }

    @Override
    public void accept(MethodVisitor visitor) {
        Block block = new Block(this.context).append(this.initialize).visitLabel(this.beginLabel).append(this.condition).ifZeroGoto(this.endLabel);
        if (this.body != null) {
            block.append(this.body);
        }
        block.visitLabel(this.continueLabel).append(this.update).gotoLabel(this.beginLabel).visitLabel(this.endLabel);
        block.accept(visitor);
    }

    @Override
    public List<ByteCodeNode> getChildNodes() {
        return ImmutableList.of((Object)this.initialize, (Object)this.condition, (Object)this.update, (Object)this.body);
    }

    @Override
    public <T> T accept(ByteCodeNode parent, ByteCodeVisitor<T> visitor) {
        return visitor.visitFor(parent, this);
    }

    public static class ForLoopBuilder {
        private final CompilerContext context;
        private final LabelNode continueLabel = new LabelNode("continue");
        private final LabelNode endLabel = new LabelNode("end");
        private String comment;
        private ByteCodeNode initialize;
        private ByteCodeNode condition;
        private ByteCodeNode update;
        private ByteCodeNode body;

        public ForLoopBuilder(CompilerContext context) {
            this.context = context;
            context.pushIterationScope(this.continueLabel, this.endLabel);
        }

        public ForLoopBuilder comment(String format, Object ... args) {
            this.comment = String.format(format, args);
            return this;
        }

        public ForLoopBuilder initialize(ByteCodeNode initialize) {
            this.initialize = ByteCodeNodes.buildBlock(this.context, initialize, "initialize");
            return this;
        }

        public ForLoopBuilder initialize(ByteCodeNodeFactory initialize) {
            this.initialize = ByteCodeNodes.buildBlock(this.context, initialize, ExpectedType.VOID, "initialize");
            return this;
        }

        public ForLoopBuilder condition(ByteCodeNode condition) {
            this.condition = ByteCodeNodes.buildBlock(this.context, condition, "condition");
            return this;
        }

        public ForLoopBuilder condition(ByteCodeNodeFactory condition) {
            this.condition = ByteCodeNodes.buildBlock(this.context, condition, ExpectedType.BOOLEAN, "condition");
            return this;
        }

        public ForLoopBuilder update(ByteCodeNode update) {
            this.update = ByteCodeNodes.buildBlock(this.context, update, "update");
            return this;
        }

        public ForLoopBuilder update(ByteCodeNodeFactory update) {
            this.update = ByteCodeNodes.buildBlock(this.context, update, ExpectedType.VOID, "update");
            return this;
        }

        public ForLoopBuilder body(ByteCodeNode body) {
            this.body = ByteCodeNodes.buildBlock(this.context, body, "body");
            return this;
        }

        public ForLoopBuilder body(ByteCodeNodeFactory body) {
            this.body = ByteCodeNodes.buildBlock(this.context, body, ExpectedType.VOID, "body");
            return this;
        }

        public ForLoop build() {
            ForLoop forLoop = new ForLoop(this.context, this.comment, this.initialize, this.condition, this.update, this.body, this.continueLabel, this.endLabel);
            this.context.popIterationScope();
            return forLoop;
        }
    }
}

