/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.byteCode;

import com.google.common.collect.ImmutableList;
import java.util.EnumSet;
import java.util.Locale;

public enum Access {
    PUBLIC(1),
    PRIVATE(2),
    PROTECTED(4),
    STATIC(8),
    FINAL(16),
    SUPER(32),
    SYNCHRONIZED(32),
    VOLATILE(64),
    BRIDGE(64),
    VARARGS(128),
    TRANSIENT(128),
    NATIVE(256),
    INTERFACE(512),
    ABSTRACT(1024),
    STRICT(2048),
    SYNTHETIC(4096),
    ANNOTATION(8192),
    ENUM(16384);

    private int modifier;

    private Access(int modifier) {
        this.modifier = modifier;
    }

    public int getModifier() {
        return this.modifier;
    }

    public String toString() {
        return super.name().toLowerCase(Locale.ENGLISH);
    }

    public static EnumSet<Access> a(Access ... access) {
        return EnumSet.copyOf(ImmutableList.copyOf((Object[])access));
    }

    public static int toAccessModifier(Iterable<Access> accesses) {
        int modifier = 0;
        for (Access access : accesses) {
            modifier += access.getModifier();
        }
        return modifier;
    }
}

