/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.block;

import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockEncoding;
import com.facebook.presto.spi.block.BlockEncodingSerde;
import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIterator;
import io.airlift.slice.SliceInput;
import io.airlift.slice.SliceOutput;
import java.util.Arrays;
import java.util.Iterator;

public final class PagesSerde {
    private PagesSerde() {
    }

    public static void writePages(BlockEncodingSerde blockEncodingSerde, SliceOutput sliceOutput, Page ... pages) {
        PagesSerde.writePages(blockEncodingSerde, sliceOutput, Arrays.asList(pages).iterator());
    }

    public static void writePages(BlockEncodingSerde blockEncodingSerde, SliceOutput sliceOutput, Iterable<Page> pages) {
        PagesSerde.writePages(blockEncodingSerde, sliceOutput, pages.iterator());
    }

    public static void writePages(BlockEncodingSerde blockEncodingSerde, SliceOutput sliceOutput, Iterator<Page> pages) {
        PagesWriter pagesWriter = new PagesWriter(blockEncodingSerde, sliceOutput);
        while (pages.hasNext()) {
            pagesWriter.append(pages.next());
        }
    }

    public static Iterator<Page> readPages(BlockEncodingSerde blockEncodingSerde, SliceInput sliceInput) {
        return new PagesReader(blockEncodingSerde, sliceInput);
    }

    private static class PagesReader
    extends AbstractIterator<Page> {
        private final BlockEncodingSerde serde;
        private final SliceInput input;

        public PagesReader(BlockEncodingSerde serde, SliceInput input) {
            this.serde = (BlockEncodingSerde)Preconditions.checkNotNull((Object)serde, (Object)"serde is null");
            this.input = (SliceInput)Preconditions.checkNotNull((Object)input, (Object)"input is null");
        }

        protected Page computeNext() {
            if (!this.input.isReadable()) {
                return (Page)this.endOfData();
            }
            int positions = this.input.readInt();
            int numberOfBlocks = this.input.readInt();
            Block[] blocks = new Block[numberOfBlocks];
            for (int i = 0; i < blocks.length; ++i) {
                BlockEncoding encoding = this.serde.readBlockEncoding(this.input);
                blocks[i] = encoding.readBlock(this.input);
            }
            Page page = new Page(positions, blocks);
            return page;
        }
    }

    private static class PagesWriter {
        private final BlockEncodingSerde serde;
        private final SliceOutput output;

        private PagesWriter(BlockEncodingSerde serde, SliceOutput output) {
            this.serde = (BlockEncodingSerde)Preconditions.checkNotNull((Object)serde, (Object)"serde is null");
            this.output = (SliceOutput)Preconditions.checkNotNull((Object)output, (Object)"output is null");
        }

        public PagesWriter append(Page page) {
            Preconditions.checkNotNull((Object)page, (Object)"page is null");
            Block[] blocks = page.getBlocks();
            this.output.writeInt(page.getPositionCount());
            this.output.writeInt(blocks.length);
            for (int i = 0; i < blocks.length; ++i) {
                BlockEncoding encoding = blocks[i].getEncoding();
                this.serde.writeBlockEncoding(this.output, encoding);
                encoding.writeBlock(this.output, blocks[i]);
            }
            return this;
        }
    }
}

