/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto;

import com.facebook.presto.Session;

public final class SystemSessionProperties {
    private static final String BIG_QUERY = "experimental_big_query";
    private static final String OPTIMIZE_HASH_GENERATION = "optimize_hash_generation";

    private SystemSessionProperties() {
    }

    public static boolean isBigQueryEnabled(Session session, boolean defaultValue) {
        return SystemSessionProperties.isEnabled(BIG_QUERY, session, defaultValue);
    }

    private static boolean isEnabled(String propertyName, Session session, boolean defaultValue) {
        String enabled = session.getSystemProperties().get(propertyName);
        if (enabled == null) {
            return defaultValue;
        }
        return Boolean.valueOf(enabled);
    }

    public static boolean isOptimizeHashGenerationEnabled(Session session, boolean defaultValue) {
        return SystemSessionProperties.isEnabled(OPTIMIZE_HASH_GENERATION, session, defaultValue);
    }
}

