/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.util.array;

import com.facebook.presto.util.array.ObjectBigArray;
import io.airlift.slice.Slice;

public final class SliceBigArray {
    private final ObjectBigArray<Slice> array;
    private long sizeOfSlices;

    public SliceBigArray() {
        this.array = new ObjectBigArray();
    }

    public SliceBigArray(Slice slice) {
        this.array = new ObjectBigArray(slice);
    }

    public long sizeOf() {
        return this.array.sizeOf() + this.sizeOfSlices;
    }

    public Slice get(long index) {
        return this.array.get(index);
    }

    public void set(long index, Slice value) {
        Slice currentValue = this.array.get(index);
        if (currentValue != null) {
            this.sizeOfSlices -= (long)currentValue.length();
        }
        if (value != null) {
            this.sizeOfSlices += (long)value.length();
        }
        this.array.set(index, value);
    }

    public void ensureCapacity(long length) {
        this.array.ensureCapacity(length);
    }
}

