/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.util;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import io.airlift.units.Duration;
import java.lang.ref.WeakReference;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nullable;

public final class MoreFutures {
    private MoreFutures() {
    }

    public static <T> T tryGetUnchecked(Future<T> future) {
        Preconditions.checkNotNull(future, (Object)"future is null");
        if (!future.isDone()) {
            return null;
        }
        try {
            return future.get(0L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw Throwables.propagate((Throwable)e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause == null) {
                cause = e;
            }
            throw Throwables.propagate((Throwable)cause);
        }
        catch (TimeoutException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static <T> ListenableFuture<T> addTimeout(ListenableFuture<T> future, Callable<T> timeoutTask, Duration timeout, ScheduledExecutorService executorService) {
        if (future.isDone()) {
            return future;
        }
        final SettableFuture settableFuture = SettableFuture.create();
        final ScheduledFuture<?> timeoutTaskFuture = executorService.schedule(new TimeoutFutureTask<T>(settableFuture, timeoutTask, future), timeout.toMillis(), TimeUnit.MILLISECONDS);
        Futures.addCallback(future, (FutureCallback)new FutureCallback<T>(){

            public void onSuccess(@Nullable T result) {
                settableFuture.set(result);
                timeoutTaskFuture.cancel(true);
            }

            public void onFailure(Throwable t) {
                settableFuture.setException(t);
                timeoutTaskFuture.cancel(true);
            }
        }, (Executor)executorService);
        return settableFuture;
    }

    private static class TimeoutFutureTask<T>
    implements Runnable {
        private final SettableFuture<T> settableFuture;
        private final Callable<T> timeoutTask;
        private final WeakReference<Future<T>> futureReference;

        public TimeoutFutureTask(SettableFuture<T> settableFuture, Callable<T> timeoutTask, ListenableFuture<T> future) {
            this.settableFuture = settableFuture;
            this.timeoutTask = timeoutTask;
            this.futureReference = new WeakReference<ListenableFuture<Future<T>>>(future);
        }

        @Override
        public void run() {
            if (this.settableFuture.isDone()) {
                return;
            }
            try {
                T result = this.timeoutTask.call();
                this.settableFuture.set(result);
            }
            catch (Throwable t) {
                this.settableFuture.setException(t);
            }
            Future future = (Future)this.futureReference.get();
            if (future != null) {
                future.cancel(true);
            }
        }
    }
}

