/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.util;

import com.facebook.presto.client.ErrorLocation;
import com.facebook.presto.execution.ExecutionFailureInfo;
import com.facebook.presto.execution.Failure;
import com.facebook.presto.spi.ErrorCode;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.sql.parser.ParsingException;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;

public final class Failures {
    private Failures() {
    }

    public static ExecutionFailureInfo toFailure(Throwable failure) {
        if (failure == null) {
            return null;
        }
        String type = failure instanceof Failure ? ((Failure)failure).getType() : failure.getClass().getCanonicalName();
        ErrorCode errorCode = null;
        if (failure instanceof PrestoException) {
            errorCode = ((PrestoException)failure).getErrorCode();
        } else if (failure instanceof Failure) {
            errorCode = ((Failure)failure).getErrorCode();
        }
        return new ExecutionFailureInfo(type, failure.getMessage(), Failures.toFailure(failure.getCause()), Failures.toFailures(Arrays.asList(failure.getSuppressed())), Lists.transform(Arrays.asList(failure.getStackTrace()), (Function)Functions.toStringFunction()), Failures.getErrorLocation(failure), errorCode);
    }

    public static void checkCondition(boolean condition, ErrorCodeSupplier errorCode, String formatString, Object ... args) {
        if (!condition) {
            throw new PrestoException(errorCode, String.format(formatString, args));
        }
    }

    public static List<ExecutionFailureInfo> toFailures(Iterable<? extends Throwable> failures) {
        return ImmutableList.copyOf((Iterable)Iterables.transform(failures, Failures.toFailureFunction()));
    }

    private static Function<Throwable, ExecutionFailureInfo> toFailureFunction() {
        return new Function<Throwable, ExecutionFailureInfo>(){

            public ExecutionFailureInfo apply(Throwable throwable) {
                return Failures.toFailure(throwable);
            }
        };
    }

    @Nullable
    private static ErrorLocation getErrorLocation(Throwable throwable) {
        if (throwable instanceof ParsingException) {
            ParsingException e = (ParsingException)throwable;
            return new ErrorLocation(e.getLineNumber(), e.getColumnNumber());
        }
        return null;
    }
}

