/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type;

import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeSignature;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import java.util.List;

public final class TypeUtils {
    private TypeUtils() {
    }

    public static int hashPosition(Type type, Block block, int position) {
        if (block.isNull(position)) {
            return 0;
        }
        return type.hash(block, position);
    }

    public static boolean positionEqualsPosition(Type type, Block leftBlock, int leftPosition, Block rightBlock, int rightPosition) {
        boolean leftIsNull = leftBlock.isNull(leftPosition);
        boolean rightIsNull = rightBlock.isNull(rightPosition);
        if (leftIsNull || rightIsNull) {
            return leftIsNull && rightIsNull;
        }
        return type.equalTo(leftBlock, leftPosition, rightBlock, rightPosition);
    }

    public static Function<Type, TypeSignature> typeSignatureGetter() {
        return new Function<Type, TypeSignature>(){

            public TypeSignature apply(Type input) {
                return input.getTypeSignature();
            }
        };
    }

    public static Function<String, TypeSignature> typeSignatureParser() {
        return new Function<String, TypeSignature>(){

            public TypeSignature apply(String input) {
                return TypeSignature.parseTypeSignature((String)input);
            }
        };
    }

    public static List<Type> resolveTypes(List<TypeSignature> typeNames, final TypeManager typeManager) {
        return FluentIterable.from(typeNames).transform((Function)new Function<TypeSignature, Type>(){

            public Type apply(TypeSignature type) {
                return (Type)Preconditions.checkNotNull((Object)typeManager.getType(type), (String)"Type '%s' not found", (Object[])new Object[]{type});
            }
        }).toList();
    }

    public static TypeSignature parameterizedTypeName(String base, TypeSignature ... argumentNames) {
        return new TypeSignature(base, (List)ImmutableList.copyOf((Object[])argumentNames));
    }
}

