/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.plan;

import com.facebook.presto.spi.block.SortOrder;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.sql.planner.plan.PlanVisitor;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class TopNRowNumberNode
extends PlanNode {
    private final PlanNode source;
    private final List<Symbol> partitionBy;
    private final List<Symbol> orderBy;
    private final Map<Symbol, SortOrder> orderings;
    private final Symbol rowNumberSymbol;
    private final int maxRowCountPerPartition;
    private final boolean partial;

    @JsonCreator
    public TopNRowNumberNode(@JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="source") PlanNode source, @JsonProperty(value="partitionBy") List<Symbol> partitionBy, @JsonProperty(value="orderBy") List<Symbol> orderBy, @JsonProperty(value="orderings") Map<Symbol, SortOrder> orderings, @JsonProperty(value="rowNumberSymbol") Symbol rowNumberSymbol, @JsonProperty(value="maxRowCountPerPartition") int maxRowCountPerPartition, @JsonProperty(value="partial") boolean partial) {
        super(id);
        Preconditions.checkNotNull((Object)source, (Object)"source is null");
        Preconditions.checkNotNull(partitionBy, (Object)"partitionBy is null");
        Preconditions.checkNotNull(orderBy, (Object)"orderBy is null");
        Preconditions.checkNotNull(orderings, (Object)"orderings is null");
        Preconditions.checkArgument((orderings.size() == orderBy.size() ? 1 : 0) != 0, (Object)"orderBy and orderings sizes don't match");
        Preconditions.checkNotNull((Object)rowNumberSymbol, (Object)"rowNumberSymbol is null");
        Preconditions.checkArgument((maxRowCountPerPartition > 0 ? 1 : 0) != 0, (Object)"maxRowCountPerPartition must be > 0");
        this.source = source;
        this.partitionBy = ImmutableList.copyOf(partitionBy);
        this.orderBy = ImmutableList.copyOf(orderBy);
        this.orderings = ImmutableMap.copyOf(orderings);
        this.rowNumberSymbol = rowNumberSymbol;
        this.maxRowCountPerPartition = maxRowCountPerPartition;
        this.partial = partial;
    }

    @Override
    public List<PlanNode> getSources() {
        return ImmutableList.of((Object)this.source);
    }

    @Override
    public List<Symbol> getOutputSymbols() {
        if (!this.partial) {
            return ImmutableList.copyOf((Iterable)Iterables.concat(this.source.getOutputSymbols(), (Iterable)ImmutableList.of((Object)this.rowNumberSymbol)));
        }
        return ImmutableList.copyOf(this.source.getOutputSymbols());
    }

    @JsonProperty
    public PlanNode getSource() {
        return this.source;
    }

    @JsonProperty
    public List<Symbol> getPartitionBy() {
        return this.partitionBy;
    }

    @JsonProperty
    public List<Symbol> getOrderBy() {
        return this.orderBy;
    }

    @JsonProperty
    public Map<Symbol, SortOrder> getOrderings() {
        return this.orderings;
    }

    @JsonProperty
    public Symbol getRowNumberSymbol() {
        return this.rowNumberSymbol;
    }

    @JsonProperty
    public int getMaxRowCountPerPartition() {
        return this.maxRowCountPerPartition;
    }

    @JsonProperty
    public boolean isPartial() {
        return this.partial;
    }

    @Override
    public <C, R> R accept(PlanVisitor<C, R> visitor, C context) {
        return visitor.visitTopNRowNumber(this, context);
    }
}

