/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.Session;
import com.facebook.presto.metadata.ColumnHandle;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.spi.block.SortOrder;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.planner.DeterminismEvaluator;
import com.facebook.presto.sql.planner.PlanNodeIdAllocator;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.SymbolAllocator;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.planner.plan.AggregationNode;
import com.facebook.presto.sql.planner.plan.FilterNode;
import com.facebook.presto.sql.planner.plan.IndexJoinNode;
import com.facebook.presto.sql.planner.plan.IndexSourceNode;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.LimitNode;
import com.facebook.presto.sql.planner.plan.MarkDistinctNode;
import com.facebook.presto.sql.planner.plan.OutputNode;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanNodeRewriter;
import com.facebook.presto.sql.planner.plan.PlanRewriter;
import com.facebook.presto.sql.planner.plan.ProjectNode;
import com.facebook.presto.sql.planner.plan.SemiJoinNode;
import com.facebook.presto.sql.planner.plan.SortNode;
import com.facebook.presto.sql.planner.plan.TableScanNode;
import com.facebook.presto.sql.planner.plan.TableWriterNode;
import com.facebook.presto.sql.planner.plan.TopNNode;
import com.facebook.presto.sql.planner.plan.UnionNode;
import com.facebook.presto.sql.planner.plan.UnnestNode;
import com.facebook.presto.sql.planner.plan.WindowNode;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.ExpressionRewriter;
import com.facebook.presto.sql.tree.ExpressionTreeRewriter;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.NullLiteral;
import com.facebook.presto.sql.tree.QualifiedNameReference;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class UnaliasSymbolReferences
extends PlanOptimizer {
    @Override
    public PlanNode optimize(PlanNode plan, Session session, Map<Symbol, Type> types, SymbolAllocator symbolAllocator, PlanNodeIdAllocator idAllocator) {
        Preconditions.checkNotNull((Object)plan, (Object)"plan is null");
        Preconditions.checkNotNull((Object)session, (Object)"session is null");
        Preconditions.checkNotNull(types, (Object)"types is null");
        Preconditions.checkNotNull((Object)symbolAllocator, (Object)"symbolAllocator is null");
        Preconditions.checkNotNull((Object)idAllocator, (Object)"idAllocator is null");
        return PlanRewriter.rewriteWith(new Rewriter(new HashMap<Symbol, Symbol>()), plan);
    }

    private static class Rewriter
    extends PlanNodeRewriter<Void> {
        private final Map<Symbol, Symbol> mapping;

        public Rewriter(Map<Symbol, Symbol> mapping) {
            this.mapping = mapping;
        }

        @Override
        public PlanNode rewriteLimit(LimitNode node, Void context, PlanRewriter<Void> planRewriter) {
            PlanNode source = planRewriter.rewrite(node.getSource(), context);
            return new LimitNode(node.getId(), source, node.getCount());
        }

        @Override
        public PlanNode rewriteAggregation(AggregationNode node, Void context, PlanRewriter<Void> planRewriter) {
            PlanNode source = planRewriter.rewrite(node.getSource(), context);
            ImmutableMap.Builder functionInfos = ImmutableMap.builder();
            ImmutableMap.Builder functionCalls = ImmutableMap.builder();
            ImmutableMap.Builder masks = ImmutableMap.builder();
            for (Map.Entry<Symbol, FunctionCall> entry : node.getAggregations().entrySet()) {
                Symbol symbol = entry.getKey();
                Symbol canonical = this.canonicalize(symbol);
                FunctionCall canonicalCall = (FunctionCall)this.canonicalize((Expression)entry.getValue());
                functionCalls.put((Object)canonical, (Object)canonicalCall);
                functionInfos.put((Object)canonical, (Object)node.getFunctions().get(symbol));
            }
            for (Map.Entry<Symbol, Object> entry : node.getMasks().entrySet()) {
                masks.put((Object)this.canonicalize(entry.getKey()), (Object)this.canonicalize((Symbol)entry.getValue()));
            }
            ImmutableList groupByKeys = ImmutableList.copyOf((Collection)ImmutableSet.copyOf(this.canonicalize(node.getGroupBy())));
            return new AggregationNode(node.getId(), source, (List<Symbol>)groupByKeys, (Map<Symbol, FunctionCall>)functionCalls.build(), (Map<Symbol, Signature>)functionInfos.build(), (Map<Symbol, Symbol>)masks.build(), this.canonicalize(node.getSampleWeight()), node.getConfidence());
        }

        @Override
        public PlanNode rewriteMarkDistinct(MarkDistinctNode node, Void context, PlanRewriter<Void> planRewriter) {
            PlanNode source = planRewriter.rewrite(node.getSource(), context);
            ImmutableList symbols = ImmutableList.copyOf((Collection)ImmutableSet.copyOf(this.canonicalize(node.getDistinctSymbols())));
            return new MarkDistinctNode(node.getId(), source, this.canonicalize(node.getMarkerSymbol()), (List<Symbol>)symbols);
        }

        @Override
        public PlanNode rewriteUnnest(UnnestNode node, Void context, PlanRewriter<Void> planRewriter) {
            PlanNode source = planRewriter.rewrite(node.getSource(), context);
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (Map.Entry<Symbol, List<Symbol>> entry : node.getUnnestSymbols().entrySet()) {
                builder.put((Object)this.canonicalize(entry.getKey()), this.canonicalize(entry.getValue()));
            }
            return new UnnestNode(node.getId(), source, this.canonicalize(node.getReplicateSymbols()), (Map<Symbol, List<Symbol>>)builder.build());
        }

        @Override
        public PlanNode rewriteWindow(WindowNode node, Void context, PlanRewriter<Void> planRewriter) {
            PlanNode source = planRewriter.rewrite(node.getSource(), context);
            ImmutableMap.Builder functionInfos = ImmutableMap.builder();
            ImmutableMap.Builder functionCalls = ImmutableMap.builder();
            for (Map.Entry<Symbol, FunctionCall> entry : node.getWindowFunctions().entrySet()) {
                Symbol symbol = entry.getKey();
                Symbol canonical = this.canonicalize(symbol);
                functionCalls.put((Object)canonical, (Object)((FunctionCall)this.canonicalize((Expression)entry.getValue())));
                functionInfos.put((Object)canonical, (Object)node.getSignatures().get(symbol));
            }
            ImmutableMap.Builder orderings = ImmutableMap.builder();
            for (Map.Entry<Symbol, SortOrder> entry : node.getOrderings().entrySet()) {
                orderings.put((Object)this.canonicalize(entry.getKey()), (Object)entry.getValue());
            }
            return new WindowNode(node.getId(), source, this.canonicalize(node.getPartitionBy()), this.canonicalize(node.getOrderBy()), (Map<Symbol, SortOrder>)orderings.build(), (Map<Symbol, FunctionCall>)functionCalls.build(), (Map<Symbol, Signature>)functionInfos.build());
        }

        @Override
        public PlanNode rewriteTableScan(TableScanNode node, Void context, PlanRewriter<Void> planRewriter) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (Map.Entry<Symbol, ColumnHandle> entry : node.getAssignments().entrySet()) {
                builder.put((Object)this.canonicalize(entry.getKey()), (Object)entry.getValue());
            }
            Expression originalConstraint = null;
            if (node.getOriginalConstraint() != null) {
                originalConstraint = this.canonicalize(node.getOriginalConstraint());
            }
            return new TableScanNode(node.getId(), node.getTable(), this.canonicalize(node.getOutputSymbols()), (Map<Symbol, ColumnHandle>)builder.build(), originalConstraint, node.getSummarizedPartition());
        }

        @Override
        public PlanNode rewriteFilter(FilterNode node, Void context, PlanRewriter<Void> planRewriter) {
            PlanNode source = planRewriter.rewrite(node.getSource(), context);
            return new FilterNode(node.getId(), source, this.canonicalize(node.getPredicate()));
        }

        @Override
        public PlanNode rewriteProject(ProjectNode node, Void context, PlanRewriter<Void> planRewriter) {
            PlanNode source = planRewriter.rewrite(node.getSource(), context);
            HashMap<Expression, Symbol> computedExpressions = new HashMap<Expression, Symbol>();
            LinkedHashMap<Symbol, Expression> assignments = new LinkedHashMap<Symbol, Expression>();
            for (Map.Entry<Symbol, Expression> entry : node.getOutputMap().entrySet()) {
                Symbol canonical;
                Expression expression = this.canonicalize(entry.getValue());
                if (entry.getValue() instanceof QualifiedNameReference) {
                    Symbol symbol = Symbol.fromQualifiedName(((QualifiedNameReference)entry.getValue()).getName());
                    if (!symbol.equals(entry.getKey())) {
                        this.map(entry.getKey(), symbol);
                    }
                } else if (DeterminismEvaluator.isDeterministic(expression) && !(expression instanceof NullLiteral)) {
                    Symbol computedSymbol = (Symbol)computedExpressions.get(expression);
                    if (computedSymbol == null) {
                        computedExpressions.put(expression, entry.getKey());
                    } else {
                        this.map(entry.getKey(), computedSymbol);
                    }
                }
                if (assignments.containsKey(canonical = this.canonicalize(entry.getKey()))) continue;
                assignments.put(canonical, expression);
            }
            return new ProjectNode(node.getId(), source, assignments);
        }

        @Override
        public PlanNode rewriteOutput(OutputNode node, Void context, PlanRewriter<Void> planRewriter) {
            PlanNode source = planRewriter.rewrite(node.getSource(), context);
            List canonical = Lists.transform(node.getOutputSymbols(), this.canonicalizeFunction());
            return new OutputNode(node.getId(), source, node.getColumnNames(), canonical);
        }

        @Override
        public PlanNode rewriteTopN(TopNNode node, Void context, PlanRewriter<Void> planRewriter) {
            PlanNode source = planRewriter.rewrite(node.getSource(), context);
            ImmutableList.Builder symbols = ImmutableList.builder();
            ImmutableMap.Builder orderings = ImmutableMap.builder();
            for (Symbol symbol : node.getOrderBy()) {
                Symbol canonical = this.canonicalize(symbol);
                symbols.add((Object)canonical);
                orderings.put((Object)canonical, (Object)node.getOrderings().get(symbol));
            }
            return new TopNNode(node.getId(), source, node.getCount(), (List<Symbol>)symbols.build(), (Map<Symbol, SortOrder>)orderings.build(), node.isPartial());
        }

        @Override
        public PlanNode rewriteSort(SortNode node, Void context, PlanRewriter<Void> planRewriter) {
            PlanNode source = planRewriter.rewrite(node.getSource(), context);
            ImmutableList.Builder symbols = ImmutableList.builder();
            ImmutableMap.Builder orderings = ImmutableMap.builder();
            for (Symbol symbol : node.getOrderBy()) {
                Symbol canonical = this.canonicalize(symbol);
                symbols.add((Object)canonical);
                orderings.put((Object)canonical, (Object)node.getOrderings().get(symbol));
            }
            return new SortNode(node.getId(), source, (List<Symbol>)symbols.build(), (Map<Symbol, SortOrder>)orderings.build());
        }

        @Override
        public PlanNode rewriteJoin(JoinNode node, Void context, PlanRewriter<Void> planRewriter) {
            PlanNode left = planRewriter.rewrite(node.getLeft(), context);
            PlanNode right = planRewriter.rewrite(node.getRight(), context);
            return new JoinNode(node.getId(), node.getType(), left, right, this.canonicalizeJoinCriteria(node.getCriteria()));
        }

        @Override
        public PlanNode rewriteSemiJoin(SemiJoinNode node, Void context, PlanRewriter<Void> planRewriter) {
            PlanNode source = planRewriter.rewrite(node.getSource(), context);
            PlanNode filteringSource = planRewriter.rewrite(node.getFilteringSource(), context);
            return new SemiJoinNode(node.getId(), source, filteringSource, this.canonicalize(node.getSourceJoinSymbol()), this.canonicalize(node.getFilteringSourceJoinSymbol()), this.canonicalize(node.getSemiJoinOutput()));
        }

        @Override
        public PlanNode rewriteIndexSource(IndexSourceNode node, Void context, PlanRewriter<Void> planRewriter) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (Map.Entry<Symbol, ColumnHandle> entry : node.getAssignments().entrySet()) {
                builder.put((Object)this.canonicalize(entry.getKey()), (Object)entry.getValue());
            }
            return new IndexSourceNode(node.getId(), node.getIndexHandle(), node.getTableHandle(), this.canonicalize(node.getLookupSymbols()), this.canonicalize(node.getOutputSymbols()), (Map<Symbol, ColumnHandle>)builder.build(), node.getEffectiveTupleDomain());
        }

        @Override
        public PlanNode rewriteIndexJoin(IndexJoinNode node, Void context, PlanRewriter<Void> planRewriter) {
            PlanNode probeSource = planRewriter.rewrite(node.getProbeSource(), context);
            PlanNode indexSource = planRewriter.rewrite(node.getIndexSource(), context);
            return new IndexJoinNode(node.getId(), node.getType(), probeSource, indexSource, this.canonicalizeIndexJoinCriteria(node.getCriteria()));
        }

        @Override
        public PlanNode rewriteUnion(UnionNode node, Void context, PlanRewriter<Void> planRewriter) {
            ImmutableList.Builder rewrittenSources = ImmutableList.builder();
            for (PlanNode source : node.getSources()) {
                rewrittenSources.add((Object)planRewriter.rewrite(source, context));
            }
            return new UnionNode(node.getId(), (List<PlanNode>)rewrittenSources.build(), this.canonicalizeUnionSymbolMap(node.getSymbolMapping()));
        }

        @Override
        public PlanNode rewriteTableWriter(TableWriterNode node, Void context, PlanRewriter<Void> planRewriter) {
            PlanNode source = planRewriter.rewrite(node.getSource(), context);
            return new TableWriterNode(node.getId(), source, node.getTarget(), this.canonicalize(node.getColumns()), node.getColumnNames(), this.canonicalize(node.getOutputSymbols()), this.canonicalize(node.getSampleWeightSymbol()));
        }

        private void map(Symbol symbol, Symbol canonical) {
            Preconditions.checkArgument((!symbol.equals(canonical) ? 1 : 0) != 0, (String)"Can't map symbol to itself: %s", (Object[])new Object[]{symbol});
            this.mapping.put(symbol, canonical);
        }

        private Optional<Symbol> canonicalize(Optional<Symbol> symbol) {
            if (symbol.isPresent()) {
                return Optional.of((Object)this.canonicalize((Symbol)symbol.get()));
            }
            return Optional.absent();
        }

        private Symbol canonicalize(Symbol symbol) {
            Symbol canonical = symbol;
            while (this.mapping.containsKey(canonical)) {
                canonical = this.mapping.get(canonical);
            }
            return canonical;
        }

        private Expression canonicalize(Expression value) {
            return ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new ExpressionRewriter<Void>(){

                public Expression rewriteQualifiedNameReference(QualifiedNameReference node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
                    Symbol canonical = Rewriter.this.canonicalize(Symbol.fromQualifiedName(node.getName()));
                    return new QualifiedNameReference(canonical.toQualifiedName());
                }
            }, (Expression)value);
        }

        private List<Symbol> canonicalize(List<Symbol> outputs) {
            return Lists.transform(outputs, this.canonicalizeFunction());
        }

        private Set<Symbol> canonicalize(Set<Symbol> symbols) {
            return FluentIterable.from(symbols).transform(this.canonicalizeFunction()).toSet();
        }

        private List<JoinNode.EquiJoinClause> canonicalizeJoinCriteria(List<JoinNode.EquiJoinClause> criteria) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (JoinNode.EquiJoinClause clause : criteria) {
                builder.add((Object)new JoinNode.EquiJoinClause(this.canonicalize(clause.getLeft()), this.canonicalize(clause.getRight())));
            }
            return builder.build();
        }

        private List<IndexJoinNode.EquiJoinClause> canonicalizeIndexJoinCriteria(List<IndexJoinNode.EquiJoinClause> criteria) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (IndexJoinNode.EquiJoinClause clause : criteria) {
                builder.add((Object)new IndexJoinNode.EquiJoinClause(this.canonicalize(clause.getProbe()), this.canonicalize(clause.getIndex())));
            }
            return builder.build();
        }

        private ListMultimap<Symbol, Symbol> canonicalizeUnionSymbolMap(ListMultimap<Symbol, Symbol> unionSymbolMap) {
            ImmutableListMultimap.Builder builder = ImmutableListMultimap.builder();
            for (Map.Entry entry : unionSymbolMap.asMap().entrySet()) {
                builder.putAll((Object)this.canonicalize((Symbol)entry.getKey()), Iterables.transform((Iterable)((Iterable)entry.getValue()), this.canonicalizeFunction()));
            }
            return builder.build();
        }

        private Function<Symbol, Symbol> canonicalizeFunction() {
            return new Function<Symbol, Symbol>(){

                public Symbol apply(Symbol input) {
                    return Rewriter.this.canonicalize(input);
                }
            };
        }
    }
}

