/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.Session;
import com.facebook.presto.metadata.ColumnHandle;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.planner.DependencyExtractor;
import com.facebook.presto.sql.planner.PlanNodeIdAllocator;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.SymbolAllocator;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.planner.plan.AggregationNode;
import com.facebook.presto.sql.planner.plan.DistinctLimitNode;
import com.facebook.presto.sql.planner.plan.FilterNode;
import com.facebook.presto.sql.planner.plan.IndexJoinNode;
import com.facebook.presto.sql.planner.plan.IndexSourceNode;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.LimitNode;
import com.facebook.presto.sql.planner.plan.MarkDistinctNode;
import com.facebook.presto.sql.planner.plan.OutputNode;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanNodeRewriter;
import com.facebook.presto.sql.planner.plan.PlanRewriter;
import com.facebook.presto.sql.planner.plan.ProjectNode;
import com.facebook.presto.sql.planner.plan.RowNumberNode;
import com.facebook.presto.sql.planner.plan.SemiJoinNode;
import com.facebook.presto.sql.planner.plan.SortNode;
import com.facebook.presto.sql.planner.plan.TableScanNode;
import com.facebook.presto.sql.planner.plan.TableWriterNode;
import com.facebook.presto.sql.planner.plan.TopNNode;
import com.facebook.presto.sql.planner.plan.TopNRowNumberNode;
import com.facebook.presto.sql.planner.plan.UnionNode;
import com.facebook.presto.sql.planner.plan.UnnestNode;
import com.facebook.presto.sql.planner.plan.WindowNode;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.FunctionCall;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PruneUnreferencedOutputs
extends PlanOptimizer {
    @Override
    public PlanNode optimize(PlanNode plan, Session session, Map<Symbol, Type> types, SymbolAllocator symbolAllocator, PlanNodeIdAllocator idAllocator) {
        Preconditions.checkNotNull((Object)plan, (Object)"plan is null");
        Preconditions.checkNotNull((Object)session, (Object)"session is null");
        Preconditions.checkNotNull(types, (Object)"types is null");
        Preconditions.checkNotNull((Object)symbolAllocator, (Object)"symbolAllocator is null");
        Preconditions.checkNotNull((Object)idAllocator, (Object)"idAllocator is null");
        return PlanRewriter.rewriteWith(new Rewriter(types), plan, ImmutableSet.of());
    }

    private static class Rewriter
    extends PlanNodeRewriter<Set<Symbol>> {
        private final Map<Symbol, Type> types;

        public Rewriter(Map<Symbol, Type> types) {
            this.types = types;
        }

        @Override
        public PlanNode rewriteJoin(JoinNode node, Set<Symbol> expectedOutputs, PlanRewriter<Set<Symbol>> planRewriter) {
            ImmutableSet leftInputs = ImmutableSet.builder().addAll(expectedOutputs).addAll(Iterables.transform(node.getCriteria(), JoinNode.EquiJoinClause.leftGetter())).build();
            ImmutableSet rightInputs = ImmutableSet.builder().addAll(expectedOutputs).addAll(Iterables.transform(node.getCriteria(), JoinNode.EquiJoinClause.rightGetter())).build();
            PlanNode left = planRewriter.rewrite(node.getLeft(), (Set<Symbol>)leftInputs);
            PlanNode right = planRewriter.rewrite(node.getRight(), (Set<Symbol>)rightInputs);
            return new JoinNode(node.getId(), node.getType(), left, right, node.getCriteria());
        }

        @Override
        public PlanNode rewriteSemiJoin(SemiJoinNode node, Set<Symbol> expectedOutputs, PlanRewriter<Set<Symbol>> planRewriter) {
            ImmutableSet sourceInputs = ImmutableSet.builder().addAll(expectedOutputs).add((Object)node.getSourceJoinSymbol()).build();
            ImmutableSet filteringSourceInputs = ImmutableSet.builder().add((Object)node.getFilteringSourceJoinSymbol()).build();
            PlanNode source = planRewriter.rewrite(node.getSource(), (Set<Symbol>)sourceInputs);
            PlanNode filteringSource = planRewriter.rewrite(node.getFilteringSource(), (Set<Symbol>)filteringSourceInputs);
            return new SemiJoinNode(node.getId(), source, filteringSource, node.getSourceJoinSymbol(), node.getFilteringSourceJoinSymbol(), node.getSemiJoinOutput());
        }

        @Override
        public PlanNode rewriteIndexJoin(IndexJoinNode node, Set<Symbol> expectedOutputs, PlanRewriter<Set<Symbol>> planRewriter) {
            ImmutableSet probeInputs = ImmutableSet.builder().addAll(expectedOutputs).addAll(Iterables.transform(node.getCriteria(), IndexJoinNode.EquiJoinClause.probeGetter())).build();
            ImmutableSet indexInputs = ImmutableSet.builder().addAll(expectedOutputs).addAll(Iterables.transform(node.getCriteria(), IndexJoinNode.EquiJoinClause.indexGetter())).build();
            PlanNode probeSource = planRewriter.rewrite(node.getProbeSource(), (Set<Symbol>)probeInputs);
            PlanNode indexSource = planRewriter.rewrite(node.getIndexSource(), (Set<Symbol>)indexInputs);
            return new IndexJoinNode(node.getId(), node.getType(), probeSource, indexSource, node.getCriteria());
        }

        @Override
        public PlanNode rewriteIndexSource(IndexSourceNode node, Set<Symbol> expectedOutputs, PlanRewriter<Set<Symbol>> planRewriter) {
            ImmutableList newOutputSymbols = FluentIterable.from(node.getOutputSymbols()).filter(Predicates.in(expectedOutputs)).toList();
            ImmutableSet newLookupSymbols = FluentIterable.from(node.getLookupSymbols()).filter(Predicates.in(expectedOutputs)).toSet();
            Sets.SetView requiredAssignmentSymbols = expectedOutputs;
            if (!node.getEffectiveTupleDomain().isNone()) {
                Set requiredSymbols = Maps.filterValues(node.getAssignments(), (Predicate)Predicates.in(node.getEffectiveTupleDomain().getDomains().keySet())).keySet();
                requiredAssignmentSymbols = Sets.union(expectedOutputs, requiredSymbols);
            }
            Map newAssignments = Maps.filterKeys(node.getAssignments(), (Predicate)Predicates.in(requiredAssignmentSymbols));
            return new IndexSourceNode(node.getId(), node.getIndexHandle(), node.getTableHandle(), (Set<Symbol>)newLookupSymbols, (List<Symbol>)newOutputSymbols, newAssignments, node.getEffectiveTupleDomain());
        }

        @Override
        public PlanNode rewriteAggregation(AggregationNode node, Set<Symbol> expectedOutputs, PlanRewriter<Set<Symbol>> planRewriter) {
            ImmutableSet.Builder expectedInputs = ImmutableSet.builder().addAll(node.getGroupBy());
            ImmutableMap.Builder functions = ImmutableMap.builder();
            ImmutableMap.Builder functionCalls = ImmutableMap.builder();
            ImmutableMap.Builder masks = ImmutableMap.builder();
            for (Map.Entry<Symbol, FunctionCall> entry : node.getAggregations().entrySet()) {
                Symbol symbol = entry.getKey();
                if (!expectedOutputs.contains(symbol)) continue;
                FunctionCall call = entry.getValue();
                expectedInputs.addAll(DependencyExtractor.extractUnique((Expression)call));
                if (node.getMasks().containsKey(symbol)) {
                    expectedInputs.add((Object)node.getMasks().get(symbol));
                    masks.put((Object)symbol, (Object)node.getMasks().get(symbol));
                }
                functionCalls.put((Object)symbol, (Object)call);
                functions.put((Object)symbol, (Object)node.getFunctions().get(symbol));
            }
            if (node.getSampleWeight().isPresent()) {
                expectedInputs.add(node.getSampleWeight().get());
            }
            PlanNode source = planRewriter.rewrite(node.getSource(), (Set<Symbol>)expectedInputs.build());
            return new AggregationNode(node.getId(), source, node.getGroupBy(), (Map<Symbol, FunctionCall>)functionCalls.build(), (Map<Symbol, Signature>)functions.build(), (Map<Symbol, Symbol>)masks.build(), node.getSampleWeight(), node.getConfidence());
        }

        @Override
        public PlanNode rewriteWindow(WindowNode node, Set<Symbol> expectedOutputs, PlanRewriter<Set<Symbol>> planRewriter) {
            ImmutableSet.Builder expectedInputs = ImmutableSet.builder().addAll(expectedOutputs).addAll(node.getPartitionBy()).addAll(node.getOrderBy());
            ImmutableMap.Builder functions = ImmutableMap.builder();
            ImmutableMap.Builder functionCalls = ImmutableMap.builder();
            for (Map.Entry<Symbol, FunctionCall> entry : node.getWindowFunctions().entrySet()) {
                Symbol symbol = entry.getKey();
                if (!expectedOutputs.contains(symbol)) continue;
                FunctionCall call = entry.getValue();
                expectedInputs.addAll(DependencyExtractor.extractUnique((Expression)call));
                functionCalls.put((Object)symbol, (Object)call);
                functions.put((Object)symbol, (Object)node.getSignatures().get(symbol));
            }
            PlanNode source = planRewriter.rewrite(node.getSource(), (Set<Symbol>)expectedInputs.build());
            return new WindowNode(node.getId(), source, node.getPartitionBy(), node.getOrderBy(), node.getOrderings(), (Map<Symbol, FunctionCall>)functionCalls.build(), (Map<Symbol, Signature>)functions.build());
        }

        @Override
        public PlanNode rewriteTableScan(TableScanNode node, Set<Symbol> expectedOutputs, PlanRewriter<Set<Symbol>> planRewriter) {
            ImmutableSet requiredTableScanOutputs = FluentIterable.from(expectedOutputs).filter(Predicates.in(node.getOutputSymbols())).toSet();
            ImmutableList newOutputSymbols = FluentIterable.from(node.getOutputSymbols()).filter(Predicates.in((Collection)requiredTableScanOutputs)).toList();
            ImmutableSet requiredAssignmentSymbols = requiredTableScanOutputs;
            if (!node.getPartitionsDomainSummary().isNone()) {
                Set requiredPartitionDomainSymbols = Maps.filterValues(node.getAssignments(), (Predicate)Predicates.in(node.getPartitionsDomainSummary().getDomains().keySet())).keySet();
                requiredAssignmentSymbols = Sets.union((Set)requiredTableScanOutputs, requiredPartitionDomainSymbols);
            }
            Map newAssignments = Maps.filterKeys(node.getAssignments(), (Predicate)Predicates.in((Collection)requiredAssignmentSymbols));
            return new TableScanNode(node.getId(), node.getTable(), (List<Symbol>)newOutputSymbols, (Map<Symbol, ColumnHandle>)newAssignments, node.getOriginalConstraint(), node.getSummarizedPartition());
        }

        @Override
        public PlanNode rewriteFilter(FilterNode node, Set<Symbol> expectedOutputs, PlanRewriter<Set<Symbol>> planRewriter) {
            ImmutableSet expectedInputs = ImmutableSet.builder().addAll(DependencyExtractor.extractUnique(node.getPredicate())).addAll(expectedOutputs).build();
            PlanNode source = planRewriter.rewrite(node.getSource(), (Set<Symbol>)expectedInputs);
            return new FilterNode(node.getId(), source, node.getPredicate());
        }

        @Override
        public PlanNode rewriteMarkDistinct(MarkDistinctNode node, Set<Symbol> expectedOutputs, PlanRewriter<Set<Symbol>> planRewriter) {
            if (!expectedOutputs.contains(node.getMarkerSymbol())) {
                return planRewriter.rewrite(node.getSource(), expectedOutputs);
            }
            ImmutableSet.Builder expectedInputs = ImmutableSet.builder().addAll(node.getDistinctSymbols()).addAll(expectedOutputs);
            PlanNode source = planRewriter.rewrite(node.getSource(), (Set<Symbol>)expectedInputs.build());
            return new MarkDistinctNode(node.getId(), source, node.getMarkerSymbol(), node.getDistinctSymbols());
        }

        @Override
        public PlanNode rewriteUnnest(UnnestNode node, Set<Symbol> expectedOutputs, PlanRewriter<Set<Symbol>> planRewriter) {
            ImmutableList replicateSymbols = FluentIterable.from(node.getReplicateSymbols()).filter(Predicates.in(expectedOutputs)).toList();
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (Map.Entry<Symbol, List<Symbol>> entry : node.getUnnestSymbols().entrySet()) {
                if (!Iterables.any((Iterable)entry.getValue(), (Predicate)Predicates.in(expectedOutputs))) continue;
                builder.put(entry);
            }
            ImmutableMap unnestSymbols = builder.build();
            ImmutableSet.Builder expectedInputs = ImmutableSet.builder().addAll((Iterable)replicateSymbols).addAll(unnestSymbols.keySet());
            PlanNode source = planRewriter.rewrite(node.getSource(), (Set<Symbol>)expectedInputs.build());
            if (unnestSymbols.isEmpty()) {
                return source;
            }
            return new UnnestNode(node.getId(), source, (List<Symbol>)replicateSymbols, (Map<Symbol, List<Symbol>>)unnestSymbols);
        }

        @Override
        public PlanNode rewriteProject(ProjectNode node, Set<Symbol> expectedOutputs, PlanRewriter<Set<Symbol>> planRewriter) {
            ImmutableSet.Builder expectedInputs = ImmutableSet.builder();
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (int i = 0; i < node.getOutputSymbols().size(); ++i) {
                Symbol output = node.getOutputSymbols().get(i);
                Expression expression = node.getExpressions().get(i);
                if (!expectedOutputs.contains(output)) continue;
                expectedInputs.addAll(DependencyExtractor.extractUnique(expression));
                builder.put((Object)output, (Object)expression);
            }
            PlanNode source = planRewriter.rewrite(node.getSource(), (Set<Symbol>)expectedInputs.build());
            return new ProjectNode(node.getId(), source, (Map<Symbol, Expression>)builder.build());
        }

        @Override
        public PlanNode rewriteOutput(OutputNode node, Set<Symbol> expectedOutputs, PlanRewriter<Set<Symbol>> planRewriter) {
            ImmutableSet expectedInputs = ImmutableSet.copyOf(node.getOutputSymbols());
            PlanNode source = planRewriter.rewrite(node.getSource(), (Set<Symbol>)expectedInputs);
            return new OutputNode(node.getId(), source, node.getColumnNames(), node.getOutputSymbols());
        }

        @Override
        public PlanNode rewriteLimit(LimitNode node, Set<Symbol> expectedOutputs, PlanRewriter<Set<Symbol>> planRewriter) {
            ImmutableSet.Builder expectedInputs = ImmutableSet.builder().addAll(expectedOutputs);
            PlanNode source = planRewriter.rewrite(node.getSource(), (Set<Symbol>)expectedInputs.build());
            return new LimitNode(node.getId(), source, node.getCount());
        }

        @Override
        public PlanNode rewriteDistinctLimit(DistinctLimitNode node, Set<Symbol> expectedOutputs, PlanRewriter<Set<Symbol>> planRewriter) {
            PlanNode source = planRewriter.rewrite(node.getSource(), (Set<Symbol>)ImmutableSet.copyOf(node.getOutputSymbols()));
            return new DistinctLimitNode(node.getId(), source, node.getLimit());
        }

        @Override
        public PlanNode rewriteTopN(TopNNode node, Set<Symbol> expectedOutputs, PlanRewriter<Set<Symbol>> planRewriter) {
            ImmutableSet.Builder expectedInputs = ImmutableSet.builder().addAll(expectedOutputs).addAll(node.getOrderBy());
            PlanNode source = planRewriter.rewrite(node.getSource(), (Set<Symbol>)expectedInputs.build());
            return new TopNNode(node.getId(), source, node.getCount(), node.getOrderBy(), node.getOrderings(), node.isPartial());
        }

        @Override
        public PlanNode rewriteRowNumber(RowNumberNode node, Set<Symbol> expectedOutputs, PlanRewriter<Set<Symbol>> planRewriter) {
            ImmutableSet.Builder expectedInputs = ImmutableSet.builder().addAll(expectedOutputs).addAll(node.getPartitionBy());
            PlanNode source = planRewriter.rewrite(node.getSource(), (Set<Symbol>)expectedInputs.build());
            return new RowNumberNode(node.getId(), source, node.getPartitionBy(), node.getRowNumberSymbol(), node.getMaxRowCountPerPartition());
        }

        @Override
        public PlanNode rewriteTopNRowNumber(TopNRowNumberNode node, Set<Symbol> expectedOutputs, PlanRewriter<Set<Symbol>> planRewriter) {
            ImmutableSet.Builder expectedInputs = ImmutableSet.builder().addAll(expectedOutputs).addAll(node.getPartitionBy()).addAll(node.getOrderBy());
            PlanNode source = planRewriter.rewrite(node.getSource(), (Set<Symbol>)expectedInputs.build());
            return new TopNRowNumberNode(node.getId(), source, node.getPartitionBy(), node.getOrderBy(), node.getOrderings(), node.getRowNumberSymbol(), node.getMaxRowCountPerPartition(), node.isPartial());
        }

        @Override
        public PlanNode rewriteSort(SortNode node, Set<Symbol> expectedOutputs, PlanRewriter<Set<Symbol>> planRewriter) {
            ImmutableSet expectedInputs = ImmutableSet.copyOf((Iterable)Iterables.concat(expectedOutputs, node.getOrderBy()));
            PlanNode source = planRewriter.rewrite(node.getSource(), (Set<Symbol>)expectedInputs);
            return new SortNode(node.getId(), source, node.getOrderBy(), node.getOrderings());
        }

        @Override
        public PlanNode rewriteTableWriter(TableWriterNode node, Set<Symbol> expectedOutputs, PlanRewriter<Set<Symbol>> planRewriter) {
            ImmutableSet.Builder expectedInputs = ImmutableSet.builder().addAll(node.getColumns());
            if (node.getSampleWeightSymbol().isPresent()) {
                expectedInputs.add(node.getSampleWeightSymbol().get());
            }
            PlanNode source = planRewriter.rewrite(node.getSource(), (Set<Symbol>)expectedInputs.build());
            return new TableWriterNode(node.getId(), source, node.getTarget(), node.getColumns(), node.getColumnNames(), node.getOutputSymbols(), node.getSampleWeightSymbol());
        }

        @Override
        public PlanNode rewriteUnion(UnionNode node, Set<Symbol> expectedOutputs, PlanRewriter<Set<Symbol>> planRewriter) {
            ImmutableListMultimap.Builder rewrittenSymbolMappingBuilder = ImmutableListMultimap.builder();
            for (Symbol symbol : node.getOutputSymbols()) {
                if (!expectedOutputs.contains(symbol)) continue;
                rewrittenSymbolMappingBuilder.putAll((Object)symbol, (Iterable)node.getSymbolMapping().get((Object)symbol));
            }
            ImmutableListMultimap rewrittenSymbolMapping = rewrittenSymbolMappingBuilder.build();
            ImmutableList.Builder rewrittenSubPlans = ImmutableList.builder();
            for (int i = 0; i < node.getSources().size(); ++i) {
                ImmutableSet.Builder expectedInputSymbols = ImmutableSet.builder();
                for (Collection symbols : rewrittenSymbolMapping.asMap().values()) {
                    expectedInputSymbols.add(Iterables.get((Iterable)symbols, (int)i));
                }
                rewrittenSubPlans.add((Object)planRewriter.rewrite(node.getSources().get(i), (Set<Symbol>)expectedInputSymbols.build()));
            }
            return new UnionNode(node.getId(), (List<PlanNode>)rewrittenSubPlans.build(), (ListMultimap<Symbol, Symbol>)rewrittenSymbolMapping);
        }
    }
}

