/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.Session;
import com.facebook.presto.index.IndexManager;
import com.facebook.presto.metadata.ColumnHandle;
import com.facebook.presto.metadata.ResolvedIndex;
import com.facebook.presto.spi.TupleDomain;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.planner.DomainTranslator;
import com.facebook.presto.sql.planner.PlanNodeIdAllocator;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.SymbolAllocator;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.planner.plan.AggregationNode;
import com.facebook.presto.sql.planner.plan.FilterNode;
import com.facebook.presto.sql.planner.plan.IndexJoinNode;
import com.facebook.presto.sql.planner.plan.IndexSourceNode;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanNodeRewriter;
import com.facebook.presto.sql.planner.plan.PlanRewriter;
import com.facebook.presto.sql.planner.plan.PlanVisitor;
import com.facebook.presto.sql.planner.plan.ProjectNode;
import com.facebook.presto.sql.planner.plan.SortNode;
import com.facebook.presto.sql.planner.plan.TableScanNode;
import com.facebook.presto.sql.tree.BooleanLiteral;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.QualifiedNameReference;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;

public class IndexJoinOptimizer
extends PlanOptimizer {
    private final IndexManager indexManager;

    public IndexJoinOptimizer(IndexManager indexManager) {
        this.indexManager = (IndexManager)Preconditions.checkNotNull((Object)indexManager, (Object)"indexManager is null");
    }

    @Override
    public PlanNode optimize(PlanNode plan, Session session, Map<Symbol, Type> types, SymbolAllocator symbolAllocator, PlanNodeIdAllocator idAllocator) {
        Preconditions.checkNotNull((Object)plan, (Object)"plan is null");
        Preconditions.checkNotNull((Object)session, (Object)"session is null");
        Preconditions.checkNotNull(types, (Object)"types is null");
        Preconditions.checkNotNull((Object)symbolAllocator, (Object)"symbolAllocator is null");
        Preconditions.checkNotNull((Object)idAllocator, (Object)"idAllocator is null");
        return PlanRewriter.rewriteWith(new Rewriter(symbolAllocator, idAllocator, this.indexManager), plan, null);
    }

    private static Function<Expression, Symbol> symbolFromReferenceGetter() {
        return new Function<Expression, Symbol>(){

            public Symbol apply(Expression expression) {
                Preconditions.checkArgument((boolean)(expression instanceof QualifiedNameReference));
                return Symbol.fromQualifiedName(((QualifiedNameReference)expression).getName());
            }
        };
    }

    private static Predicate<Expression> instanceOfQualifiedNameReference() {
        return new Predicate<Expression>(){

            public boolean apply(Expression expression) {
                return expression instanceof QualifiedNameReference;
            }
        };
    }

    public static class IndexKeyTracer {
        public static Map<Symbol, Symbol> trace(PlanNode node, Set<Symbol> lookupSymbols) {
            return node.accept(new Visitor(), lookupSymbols);
        }

        private static class Visitor
        extends PlanVisitor<Set<Symbol>, Map<Symbol, Symbol>> {
            private Visitor() {
            }

            @Override
            protected Map<Symbol, Symbol> visitPlan(PlanNode node, Set<Symbol> lookupSymbols) {
                throw new UnsupportedOperationException("Node not expected to be part of Index pipeline: " + node);
            }

            @Override
            public Map<Symbol, Symbol> visitProject(ProjectNode node, Set<Symbol> lookupSymbols) {
                Map directSymbolTranslationOutputMap = Maps.transformValues((Map)Maps.filterValues(node.getOutputMap(), (Predicate)IndexJoinOptimizer.instanceOfQualifiedNameReference()), (Function)IndexJoinOptimizer.symbolFromReferenceGetter());
                ImmutableMap outputToSourceMap = FluentIterable.from(lookupSymbols).filter(Predicates.in(directSymbolTranslationOutputMap.keySet())).toMap(Functions.forMap((Map)directSymbolTranslationOutputMap));
                Preconditions.checkState((!outputToSourceMap.isEmpty() ? 1 : 0) != 0, (Object)"No lookup symbols were able to pass through the projection");
                Map<Symbol, Symbol> sourceToIndexMap = node.getSource().accept(this, ImmutableSet.copyOf(outputToSourceMap.values()));
                Map outputToIndexMap = Maps.transformValues((Map)Maps.filterValues((Map)outputToSourceMap, (Predicate)Predicates.in(sourceToIndexMap.keySet())), (Function)Functions.forMap(sourceToIndexMap));
                return ImmutableMap.copyOf((Map)outputToIndexMap);
            }

            @Override
            public Map<Symbol, Symbol> visitFilter(FilterNode node, Set<Symbol> lookupSymbols) {
                return node.getSource().accept(this, lookupSymbols);
            }

            @Override
            public Map<Symbol, Symbol> visitIndexJoin(IndexJoinNode node, Set<Symbol> lookupSymbols) {
                ImmutableSet probeLookupSymbols = FluentIterable.from(lookupSymbols).filter(Predicates.in(node.getProbeSource().getOutputSymbols())).toSet();
                Preconditions.checkState((!probeLookupSymbols.isEmpty() ? 1 : 0) != 0, (Object)"No lookup symbols were able to pass through the index join probe source");
                return node.getProbeSource().accept(this, probeLookupSymbols);
            }

            @Override
            public Map<Symbol, Symbol> visitAggregation(AggregationNode node, Set<Symbol> lookupSymbols) {
                ImmutableSet groupByLookupSymbols = FluentIterable.from(lookupSymbols).filter(Predicates.in(node.getGroupBy())).toSet();
                Preconditions.checkState((!groupByLookupSymbols.isEmpty() ? 1 : 0) != 0, (Object)"No lookup symbols were able to pass through the aggregation group by");
                return node.getSource().accept(this, groupByLookupSymbols);
            }

            @Override
            public Map<Symbol, Symbol> visitSort(SortNode node, Set<Symbol> lookupSymbols) {
                return node.getSource().accept(this, lookupSymbols);
            }

            @Override
            public Map<Symbol, Symbol> visitIndexSource(IndexSourceNode node, Set<Symbol> lookupSymbols) {
                Preconditions.checkState((boolean)node.getLookupSymbols().equals(lookupSymbols), (Object)"lookupSymbols must be the same as IndexSource lookup symbols");
                return FluentIterable.from(lookupSymbols).toMap(Functions.identity());
            }
        }
    }

    private static class IndexSourceRewriter
    extends PlanNodeRewriter<Context> {
        private final IndexManager indexManager;
        private final SymbolAllocator symbolAllocator;
        private final PlanNodeIdAllocator idAllocator;

        private IndexSourceRewriter(IndexManager indexManager, SymbolAllocator symbolAllocator, PlanNodeIdAllocator idAllocator) {
            this.symbolAllocator = (SymbolAllocator)Preconditions.checkNotNull((Object)symbolAllocator, (Object)"symbolAllocator is null");
            this.idAllocator = (PlanNodeIdAllocator)Preconditions.checkNotNull((Object)idAllocator, (Object)"idAllocator is null");
            this.indexManager = (IndexManager)Preconditions.checkNotNull((Object)indexManager, (Object)"indexManager is null");
        }

        public static Optional<PlanNode> rewriteWithIndex(PlanNode planNode, Set<Symbol> lookupSymbols, IndexManager indexManager, SymbolAllocator symbolAllocator, PlanNodeIdAllocator idAllocator) {
            AtomicBoolean success = new AtomicBoolean();
            IndexSourceRewriter indexSourceRewriter = new IndexSourceRewriter(indexManager, symbolAllocator, idAllocator);
            PlanNode rewritten = PlanRewriter.rewriteWith(indexSourceRewriter, planNode, new Context(lookupSymbols, success));
            if (success.get()) {
                return Optional.of((Object)rewritten);
            }
            return Optional.absent();
        }

        @Override
        public PlanNode rewriteNode(PlanNode node, Context context, PlanRewriter<Context> planRewriter) {
            return node;
        }

        @Override
        public PlanNode rewriteTableScan(TableScanNode node, Context context, PlanRewriter<Context> planRewriter) {
            Preconditions.checkState((boolean)node.getOutputSymbols().containsAll(context.getLookupSymbols()));
            ImmutableSet lookupColumns = FluentIterable.from(context.getLookupSymbols()).transform(Functions.forMap(node.getAssignments())).toSet();
            Preconditions.checkState((boolean)node.getGeneratedPartitions().isPresent(), (Object)"Predicate should have generated partitions before this optimizer");
            TupleDomain<ColumnHandle> tupleDomain = ((TableScanNode.GeneratedPartitions)node.getGeneratedPartitions().get()).getTupleDomainInput();
            Optional<ResolvedIndex> optionalResolvedIndex = this.indexManager.resolveIndex(node.getTable(), (Set<ColumnHandle>)lookupColumns, tupleDomain);
            if (!optionalResolvedIndex.isPresent()) {
                return node;
            }
            ResolvedIndex resolvedIndex = (ResolvedIndex)optionalResolvedIndex.get();
            ImmutableBiMap inverseAssignments = ImmutableBiMap.copyOf(node.getAssignments()).inverse();
            Expression unresolvedExpression = DomainTranslator.toPredicate(resolvedIndex.getUnresolvedTupleDomain(), (Map<ColumnHandle, Symbol>)inverseAssignments, this.symbolAllocator.getTypes());
            PlanNode source = new IndexSourceNode(this.idAllocator.getNextId(), resolvedIndex.getIndexHandle(), node.getTable(), context.getLookupSymbols(), node.getOutputSymbols(), node.getAssignments(), tupleDomain);
            if (!unresolvedExpression.equals((Object)BooleanLiteral.TRUE_LITERAL)) {
                source = new FilterNode(this.idAllocator.getNextId(), source, unresolvedExpression);
            }
            context.markSuccess();
            return source;
        }

        @Override
        public PlanNode rewriteProject(ProjectNode node, Context context, PlanRewriter<Context> planRewriter) {
            ImmutableSet newLookupSymbols = FluentIterable.from(context.getLookupSymbols()).transform(Functions.forMap(node.getOutputMap())).filter(IndexJoinOptimizer.instanceOfQualifiedNameReference()).transform(IndexJoinOptimizer.symbolFromReferenceGetter()).toSet();
            if (newLookupSymbols.isEmpty()) {
                return node;
            }
            return planRewriter.defaultRewrite(node, new Context((Set<Symbol>)newLookupSymbols, context.getSuccess()));
        }

        @Override
        public PlanNode rewriteFilter(FilterNode node, Context context, PlanRewriter<Context> planRewriter) {
            return planRewriter.defaultRewrite(node, new Context(context.getLookupSymbols(), context.getSuccess()));
        }

        @Override
        public PlanNode rewriteIndexSource(IndexSourceNode node, Context context, PlanRewriter<Context> planRewriter) {
            throw new IllegalStateException("Should not be trying to generate an Index on something that has already been determined to use an Index");
        }

        @Override
        public PlanNode rewriteIndexJoin(IndexJoinNode node, Context context, PlanRewriter<Context> planRewriter) {
            ImmutableSet probeLookupSymbols = FluentIterable.from(context.getLookupSymbols()).filter(Predicates.in(node.getProbeSource().getOutputSymbols())).toSet();
            if (probeLookupSymbols.isEmpty()) {
                return node;
            }
            PlanNode rewrittenProbeSource = planRewriter.rewrite(node.getProbeSource(), new Context((Set<Symbol>)probeLookupSymbols, context.getSuccess()));
            IndexJoinNode source = node;
            if (rewrittenProbeSource != node.getProbeSource()) {
                source = new IndexJoinNode(node.getId(), node.getType(), rewrittenProbeSource, node.getIndexSource(), node.getCriteria());
            }
            return source;
        }

        @Override
        public PlanNode rewriteAggregation(AggregationNode node, Context context, PlanRewriter<Context> planRewriter) {
            ImmutableSet groupByLookupSymbols = FluentIterable.from(context.getLookupSymbols()).filter(Predicates.in(node.getGroupBy())).toSet();
            if (groupByLookupSymbols.isEmpty()) {
                return node;
            }
            return planRewriter.defaultRewrite(node, new Context((Set<Symbol>)groupByLookupSymbols, context.getSuccess()));
        }

        @Override
        public PlanNode rewriteSort(SortNode node, Context context, PlanRewriter<Context> planRewriter) {
            return planRewriter.rewrite(node.getSource(), context);
        }

        public static class Context {
            private final Set<Symbol> lookupSymbols;
            private final AtomicBoolean success;

            public Context(Set<Symbol> lookupSymbols, AtomicBoolean success) {
                Preconditions.checkArgument((!lookupSymbols.isEmpty() ? 1 : 0) != 0, (Object)"lookupSymbols can not be empty");
                this.lookupSymbols = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(lookupSymbols, (Object)"lookupSymbols is null")));
                this.success = (AtomicBoolean)Preconditions.checkNotNull((Object)success, (Object)"success is null");
            }

            public Set<Symbol> getLookupSymbols() {
                return this.lookupSymbols;
            }

            public AtomicBoolean getSuccess() {
                return this.success;
            }

            public void markSuccess() {
                Preconditions.checkState((boolean)this.success.compareAndSet(false, true), (Object)"Can only have one success per context");
            }
        }
    }

    private static class Rewriter
    extends PlanNodeRewriter<Void> {
        private final IndexManager indexManager;
        private final SymbolAllocator symbolAllocator;
        private final PlanNodeIdAllocator idAllocator;

        private Rewriter(SymbolAllocator symbolAllocator, PlanNodeIdAllocator idAllocator, IndexManager indexManager) {
            this.symbolAllocator = (SymbolAllocator)Preconditions.checkNotNull((Object)symbolAllocator, (Object)"symbolAllocator is null");
            this.idAllocator = (PlanNodeIdAllocator)Preconditions.checkNotNull((Object)idAllocator, (Object)"idAllocator is null");
            this.indexManager = (IndexManager)Preconditions.checkNotNull((Object)indexManager, (Object)"indexManager is null");
        }

        @Override
        public PlanNode rewriteJoin(JoinNode node, Void context, PlanRewriter<Void> planRewriter) {
            PlanNode leftRewritten = planRewriter.rewrite(node.getLeft(), context);
            PlanNode rightRewritten = planRewriter.rewrite(node.getRight(), context);
            if (!node.getCriteria().isEmpty()) {
                Optional<PlanNode> rightIndexCandidate;
                List leftJoinSymbols = Lists.transform(node.getCriteria(), JoinNode.EquiJoinClause.leftGetter());
                List rightJoinSymbols = Lists.transform(node.getCriteria(), JoinNode.EquiJoinClause.rightGetter());
                Optional<PlanNode> leftIndexCandidate = IndexSourceRewriter.rewriteWithIndex(leftRewritten, (Set<Symbol>)ImmutableSet.copyOf((Collection)leftJoinSymbols), this.indexManager, this.symbolAllocator, this.idAllocator);
                if (leftIndexCandidate.isPresent()) {
                    Map<Symbol, Symbol> trace = IndexKeyTracer.trace((PlanNode)leftIndexCandidate.get(), (Set<Symbol>)ImmutableSet.copyOf((Collection)leftJoinSymbols));
                    Preconditions.checkState((!trace.isEmpty() && leftJoinSymbols.containsAll(trace.keySet()) ? 1 : 0) != 0);
                }
                if ((rightIndexCandidate = IndexSourceRewriter.rewriteWithIndex(rightRewritten, (Set<Symbol>)ImmutableSet.copyOf((Collection)rightJoinSymbols), this.indexManager, this.symbolAllocator, this.idAllocator)).isPresent()) {
                    Map<Symbol, Symbol> trace = IndexKeyTracer.trace((PlanNode)rightIndexCandidate.get(), (Set<Symbol>)ImmutableSet.copyOf((Collection)rightJoinSymbols));
                    Preconditions.checkState((!trace.isEmpty() && rightJoinSymbols.containsAll(trace.keySet()) ? 1 : 0) != 0);
                }
                switch (node.getType()) {
                    case INNER: {
                        if (rightIndexCandidate.isPresent()) {
                            return new IndexJoinNode(this.idAllocator.getNextId(), IndexJoinNode.Type.INNER, leftRewritten, (PlanNode)rightIndexCandidate.get(), Rewriter.createEquiJoinClause(leftJoinSymbols, rightJoinSymbols));
                        }
                        if (!leftIndexCandidate.isPresent()) break;
                        return new IndexJoinNode(this.idAllocator.getNextId(), IndexJoinNode.Type.INNER, rightRewritten, (PlanNode)leftIndexCandidate.get(), Rewriter.createEquiJoinClause(rightJoinSymbols, leftJoinSymbols));
                    }
                    case LEFT: {
                        if (!rightIndexCandidate.isPresent()) break;
                        return new IndexJoinNode(this.idAllocator.getNextId(), IndexJoinNode.Type.SOURCE_OUTER, leftRewritten, (PlanNode)rightIndexCandidate.get(), Rewriter.createEquiJoinClause(leftJoinSymbols, rightJoinSymbols));
                    }
                    case RIGHT: {
                        if (!leftIndexCandidate.isPresent()) break;
                        return new IndexJoinNode(this.idAllocator.getNextId(), IndexJoinNode.Type.SOURCE_OUTER, rightRewritten, (PlanNode)leftIndexCandidate.get(), Rewriter.createEquiJoinClause(rightJoinSymbols, leftJoinSymbols));
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown type: " + (Object)((Object)node.getType()));
                    }
                }
            }
            if (leftRewritten != node.getLeft() || rightRewritten != node.getRight()) {
                return new JoinNode(node.getId(), node.getType(), leftRewritten, rightRewritten, node.getCriteria());
            }
            return node;
        }

        private static List<IndexJoinNode.EquiJoinClause> createEquiJoinClause(List<Symbol> probeSymbols, List<Symbol> indexSymbols) {
            Preconditions.checkArgument((probeSymbols.size() == indexSymbols.size() ? 1 : 0) != 0);
            ImmutableList.Builder builder = ImmutableList.builder();
            for (int i = 0; i < probeSymbols.size(); ++i) {
                builder.add((Object)new IndexJoinNode.EquiJoinClause(probeSymbols.get(i), indexSymbols.get(i)));
            }
            return builder.build();
        }
    }
}

