/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.analyzer.Field;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.QualifiedNameReference;
import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class SymbolAllocator {
    private final Map<Symbol, Type> symbols = new HashMap<Symbol, Type>();

    public Symbol newSymbol(String nameHint, Type type) {
        return this.newSymbol(nameHint, type, null);
    }

    public Symbol newSymbol(String nameHint, Type type, String suffix) {
        Preconditions.checkNotNull((Object)nameHint, (Object)"name is null");
        nameHint = nameHint.toLowerCase(Locale.ENGLISH);
        if (nameHint.contains("_")) {
            nameHint = nameHint.substring(0, nameHint.indexOf("_"));
        }
        String unique = nameHint;
        if (suffix != null) {
            unique = unique + "$" + suffix;
        }
        int id = 1;
        while (this.symbols.containsKey(new Symbol(unique))) {
            unique = nameHint + "_" + id;
            ++id;
        }
        Symbol symbol = new Symbol(unique);
        this.symbols.put(symbol, type);
        return symbol;
    }

    public Symbol newSymbol(Expression expression, Type type) {
        return this.newSymbol(expression, type, null);
    }

    public Symbol newSymbol(Expression expression, Type type, String suffix) {
        String nameHint = "expr";
        if (expression instanceof QualifiedNameReference) {
            nameHint = ((QualifiedNameReference)expression).getName().getSuffix();
        } else if (expression instanceof FunctionCall) {
            nameHint = ((FunctionCall)expression).getName().getSuffix();
        }
        return this.newSymbol(nameHint, type, suffix);
    }

    public Symbol newSymbol(Field field) {
        String nameHint = (String)field.getName().or((Object)"field");
        return this.newSymbol(nameHint, field.getType());
    }

    public Map<Symbol, Type> getTypes() {
        return this.symbols;
    }
}

