/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.metadata.ColumnHandle;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.OperatorNotFoundException;
import com.facebook.presto.metadata.TableHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.Domain;
import com.facebook.presto.spi.Marker;
import com.facebook.presto.spi.Range;
import com.facebook.presto.spi.TupleDomain;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.sql.planner.DependencyExtractor;
import com.facebook.presto.sql.planner.DomainUtils;
import com.facebook.presto.sql.planner.PlanFragment;
import com.facebook.presto.sql.planner.SubPlan;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.plan.AggregationNode;
import com.facebook.presto.sql.planner.plan.DistinctLimitNode;
import com.facebook.presto.sql.planner.plan.ExchangeNode;
import com.facebook.presto.sql.planner.plan.FilterNode;
import com.facebook.presto.sql.planner.plan.IndexJoinNode;
import com.facebook.presto.sql.planner.plan.IndexSourceNode;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.LimitNode;
import com.facebook.presto.sql.planner.plan.MarkDistinctNode;
import com.facebook.presto.sql.planner.plan.OutputNode;
import com.facebook.presto.sql.planner.plan.PlanFragmentId;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanVisitor;
import com.facebook.presto.sql.planner.plan.ProjectNode;
import com.facebook.presto.sql.planner.plan.RowNumberNode;
import com.facebook.presto.sql.planner.plan.SampleNode;
import com.facebook.presto.sql.planner.plan.SemiJoinNode;
import com.facebook.presto.sql.planner.plan.SinkNode;
import com.facebook.presto.sql.planner.plan.SortNode;
import com.facebook.presto.sql.planner.plan.TableCommitNode;
import com.facebook.presto.sql.planner.plan.TableScanNode;
import com.facebook.presto.sql.planner.plan.TableWriterNode;
import com.facebook.presto.sql.planner.plan.TopNNode;
import com.facebook.presto.sql.planner.plan.TopNRowNumberNode;
import com.facebook.presto.sql.planner.plan.UnionNode;
import com.facebook.presto.sql.planner.plan.UnnestNode;
import com.facebook.presto.sql.planner.plan.ValuesNode;
import com.facebook.presto.sql.planner.plan.WindowNode;
import com.facebook.presto.sql.tree.ComparisonExpression;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.QualifiedNameReference;
import com.facebook.presto.util.GraphvizPrinter;
import com.facebook.presto.util.JsonPlanPrinter;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.airlift.slice.Slice;
import java.lang.invoke.MethodHandle;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class PlanPrinter {
    private final StringBuilder output = new StringBuilder();
    private final Metadata metadata;

    private PlanPrinter(PlanNode plan, Map<Symbol, Type> types, Metadata metadata, Optional<Map<PlanFragmentId, PlanFragment>> fragmentsById) {
        Preconditions.checkNotNull((Object)plan, (Object)"plan is null");
        Preconditions.checkNotNull(types, (Object)"types is null");
        Preconditions.checkNotNull(fragmentsById, (Object)"fragmentsById is null");
        Preconditions.checkNotNull((Object)metadata, (Object)"metadata is null");
        this.metadata = metadata;
        Visitor visitor = new Visitor(types, fragmentsById);
        plan.accept(visitor, 0);
    }

    public String toString() {
        return this.output.toString();
    }

    public static String textLogicalPlan(PlanNode plan, Map<Symbol, Type> types, Metadata metadata) {
        return new PlanPrinter(plan, types, metadata, (Optional<Map<PlanFragmentId, PlanFragment>>)Optional.absent()).toString();
    }

    public static String getJsonPlanSource(PlanNode plan, Metadata metadata) {
        return JsonPlanPrinter.getPlan(plan, metadata);
    }

    public static String textDistributedPlan(SubPlan plan, Metadata metadata) {
        List<PlanFragment> fragments = plan.getAllFragments();
        ImmutableMap fragmentsById = Maps.uniqueIndex(fragments, PlanFragment.idGetter());
        PlanFragment fragment = plan.getFragment();
        return new PlanPrinter(fragment.getRoot(), fragment.getSymbols(), metadata, (Optional<Map<PlanFragmentId, PlanFragment>>)Optional.of((Object)fragmentsById)).toString();
    }

    public static String graphvizLogicalPlan(PlanNode plan, Map<Symbol, Type> types) {
        PlanFragment fragment = new PlanFragment(new PlanFragmentId("graphviz_plan"), plan, types, PlanFragment.PlanDistribution.NONE, plan.getId(), PlanFragment.OutputPartitioning.NONE, (List<Symbol>)ImmutableList.of());
        return GraphvizPrinter.printLogical((List<PlanFragment>)ImmutableList.of((Object)fragment));
    }

    public static String graphvizDistributedPlan(SubPlan plan) {
        return GraphvizPrinter.printDistributed(plan);
    }

    private void print(int indent, String format, Object ... args) {
        String value = args.length == 0 ? format : String.format(format, args);
        this.output.append(Strings.repeat((String)"    ", (int)indent)).append(value).append('\n');
    }

    private String formatDomain(TableHandle table, ColumnHandle column, Domain domain) {
        ImmutableList.Builder parts = ImmutableList.builder();
        if (domain.isNullAllowed()) {
            parts.add((Object)"NULL");
        }
        try {
            ColumnMetadata columnMetadata = this.metadata.getColumnMetadata(table, column);
            MethodHandle method = this.metadata.getFunctionRegistry().getCoercion(columnMetadata.getType(), (Type)VarcharType.VARCHAR).getMethodHandle();
            for (Range range : domain.getRanges()) {
                StringBuilder builder = new StringBuilder();
                if (range.isSingleValue()) {
                    String value = ((Slice)method.invokeWithArguments(range.getSingleValue())).toStringUtf8();
                    builder.append('[').append(value).append(']');
                } else {
                    builder.append(range.getLow().getBound() == Marker.Bound.EXACTLY ? (char)'[' : '(');
                    if (range.getLow().isLowerUnbounded()) {
                        builder.append("<min>");
                    } else {
                        builder.append(((Slice)method.invokeWithArguments(range.getLow().getValue())).toStringUtf8());
                    }
                    builder.append(", ");
                    if (range.getHigh().isUpperUnbounded()) {
                        builder.append("<max>");
                    } else {
                        builder.append(((Slice)method.invokeWithArguments(range.getHigh().getValue())).toStringUtf8());
                    }
                    builder.append(range.getHigh().getBound() == Marker.Bound.EXACTLY ? (char)']' : ')');
                }
                parts.add((Object)builder.toString());
            }
        }
        catch (OperatorNotFoundException e) {
            parts.add((Object)"<UNREPRESENTABLE VALUE>");
        }
        catch (Throwable e) {
            throw Throwables.propagate((Throwable)e);
        }
        return "[" + Joiner.on((String)", ").join((Iterable)parts.build()) + "]";
    }

    private class Visitor
    extends PlanVisitor<Integer, Void> {
        private final Map<Symbol, Type> types;
        private final Optional<Map<PlanFragmentId, PlanFragment>> fragmentsById;

        public Visitor(Map<Symbol, Type> types, Optional<Map<PlanFragmentId, PlanFragment>> fragmentsById) {
            this.types = types;
            this.fragmentsById = fragmentsById;
        }

        @Override
        public Void visitJoin(JoinNode node, Integer indent) {
            ArrayList<ComparisonExpression> joinExpressions = new ArrayList<ComparisonExpression>();
            for (JoinNode.EquiJoinClause clause : node.getCriteria()) {
                joinExpressions.add(new ComparisonExpression(ComparisonExpression.Type.EQUAL, (Expression)new QualifiedNameReference(clause.getLeft().toQualifiedName()), (Expression)new QualifiedNameReference(clause.getRight().toQualifiedName())));
            }
            PlanPrinter.this.print(indent, "- %s[%s] => [%s]", new Object[]{node.getType().getJoinLabel(), Joiner.on((String)" AND ").join(joinExpressions), this.formatOutputs(node.getOutputSymbols())});
            node.getLeft().accept(this, indent + 1);
            node.getRight().accept(this, indent + 1);
            return null;
        }

        @Override
        public Void visitSemiJoin(SemiJoinNode node, Integer indent) {
            PlanPrinter.this.print(indent, "- SemiJoin[%s = %s] => [%s]", new Object[]{node.getSourceJoinSymbol(), node.getFilteringSourceJoinSymbol(), this.formatOutputs(node.getOutputSymbols())});
            node.getSource().accept(this, indent + 1);
            node.getFilteringSource().accept(this, indent + 1);
            return null;
        }

        @Override
        public Void visitIndexSource(IndexSourceNode node, Integer indent) {
            PlanPrinter.this.print(indent, "- IndexSource[%s, lookup = %s] => [%s]", new Object[]{node.getIndexHandle(), node.getLookupSymbols(), this.formatOutputs(node.getOutputSymbols())});
            for (Map.Entry<Symbol, ColumnHandle> entry : node.getAssignments().entrySet()) {
                if (!node.getOutputSymbols().contains(entry.getKey())) continue;
                PlanPrinter.this.print(indent + 2, "%s := %s", new Object[]{entry.getKey(), entry.getValue()});
            }
            return null;
        }

        @Override
        public Void visitIndexJoin(IndexJoinNode node, Integer indent) {
            ArrayList<ComparisonExpression> joinExpressions = new ArrayList<ComparisonExpression>();
            for (IndexJoinNode.EquiJoinClause clause : node.getCriteria()) {
                joinExpressions.add(new ComparisonExpression(ComparisonExpression.Type.EQUAL, (Expression)new QualifiedNameReference(clause.getProbe().toQualifiedName()), (Expression)new QualifiedNameReference(clause.getIndex().toQualifiedName())));
            }
            PlanPrinter.this.print(indent, "- %sIndexJoin[%s] => [%s]", new Object[]{node.getType().getJoinLabel(), Joiner.on((String)" AND ").join(joinExpressions), this.formatOutputs(node.getOutputSymbols())});
            node.getProbeSource().accept(this, indent + 1);
            node.getIndexSource().accept(this, indent + 1);
            return null;
        }

        @Override
        public Void visitLimit(LimitNode node, Integer indent) {
            PlanPrinter.this.print(indent, "- Limit[%s] => [%s]", new Object[]{node.getCount(), this.formatOutputs(node.getOutputSymbols())});
            return this.processChildren(node, indent + 1);
        }

        @Override
        public Void visitDistinctLimit(DistinctLimitNode node, Integer indent) {
            PlanPrinter.this.print(indent, "- DistinctLimit[%s] => [%s]", new Object[]{node.getLimit(), this.formatOutputs(node.getOutputSymbols())});
            return this.processChildren(node, indent + 1);
        }

        @Override
        public Void visitAggregation(AggregationNode node, Integer indent) {
            String type = "";
            if (node.getStep() != AggregationNode.Step.SINGLE) {
                type = String.format("(%s)", node.getStep().toString());
            }
            String key = "";
            if (!node.getGroupBy().isEmpty()) {
                key = node.getGroupBy().toString();
            }
            String sampleWeight = "";
            if (node.getSampleWeight().isPresent()) {
                sampleWeight = String.format("[sampleWeight = %s]", node.getSampleWeight().get());
            }
            PlanPrinter.this.print(indent, "- Aggregate%s%s%s => [%s]", new Object[]{type, key, sampleWeight, this.formatOutputs(node.getOutputSymbols())});
            for (Map.Entry<Symbol, FunctionCall> entry : node.getAggregations().entrySet()) {
                if (node.getMasks().containsKey(entry.getKey())) {
                    PlanPrinter.this.print(indent + 2, "%s := %s (mask = %s)", new Object[]{entry.getKey(), entry.getValue(), node.getMasks().get(entry.getKey())});
                    continue;
                }
                PlanPrinter.this.print(indent + 2, "%s := %s", new Object[]{entry.getKey(), entry.getValue()});
            }
            return this.processChildren(node, indent + 1);
        }

        @Override
        public Void visitMarkDistinct(MarkDistinctNode node, Integer indent) {
            PlanPrinter.this.print(indent, "- MarkDistinct[distinct=%s marker=%s] => [%s]", new Object[]{this.formatOutputs(node.getDistinctSymbols()), node.getMarkerSymbol(), this.formatOutputs(node.getOutputSymbols())});
            return this.processChildren(node, indent + 1);
        }

        @Override
        public Void visitWindow(final WindowNode node, Integer indent) {
            List partitionBy = Lists.transform(node.getPartitionBy(), (Function)Functions.toStringFunction());
            List orderBy = Lists.transform(node.getOrderBy(), (Function)new Function<Symbol, String>(){

                public String apply(Symbol input) {
                    return input + " " + node.getOrderings().get(input);
                }
            });
            ArrayList<String> args = new ArrayList<String>();
            if (!partitionBy.isEmpty()) {
                args.add(String.format("partition by (%s)", Joiner.on((String)", ").join((Iterable)partitionBy)));
            }
            if (!orderBy.isEmpty()) {
                args.add(String.format("order by (%s)", Joiner.on((String)", ").join((Iterable)orderBy)));
            }
            PlanPrinter.this.print(indent, "- Window[%s] => [%s]", new Object[]{Joiner.on((String)", ").join(args), this.formatOutputs(node.getOutputSymbols())});
            for (Map.Entry<Symbol, FunctionCall> entry : node.getWindowFunctions().entrySet()) {
                PlanPrinter.this.print(indent + 2, "%s := %s(%s)", new Object[]{entry.getKey(), entry.getValue().getName(), Joiner.on((String)", ").join((Iterable)entry.getValue().getArguments())});
            }
            return this.processChildren(node, indent + 1);
        }

        @Override
        public Void visitTopNRowNumber(final TopNRowNumberNode node, Integer indent) {
            List partitionBy = Lists.transform(node.getPartitionBy(), (Function)Functions.toStringFunction());
            List orderBy = Lists.transform(node.getOrderBy(), (Function)new Function<Symbol, String>(){

                public String apply(Symbol input) {
                    return input + " " + node.getOrderings().get(input);
                }
            });
            ArrayList<String> args = new ArrayList<String>();
            args.add(String.format("partition by (%s)", Joiner.on((String)", ").join((Iterable)partitionBy)));
            args.add(String.format("order by (%s)", Joiner.on((String)", ").join((Iterable)orderBy)));
            PlanPrinter.this.print(indent, "- TopNRowNumber[%s limit %s] => [%s]", new Object[]{Joiner.on((String)", ").join(args), node.getMaxRowCountPerPartition(), this.formatOutputs(node.getOutputSymbols())});
            PlanPrinter.this.print(indent + 2, "%s := %s", new Object[]{node.getRowNumberSymbol(), "row_number()"});
            return this.processChildren(node, indent + 1);
        }

        @Override
        public Void visitRowNumber(RowNumberNode node, Integer indent) {
            List partitionBy = Lists.transform(node.getPartitionBy(), (Function)Functions.toStringFunction());
            ArrayList<String> args = new ArrayList<String>();
            if (!partitionBy.isEmpty()) {
                args.add(String.format("partition by (%s) ", Joiner.on((String)", ").join((Iterable)partitionBy)));
            }
            if (node.getMaxRowCountPerPartition().isPresent()) {
                args.add(String.format("limit (%s) ", node.getMaxRowCountPerPartition().get()));
            }
            PlanPrinter.this.print(indent, "- RowNumber[%s] => [%s]", new Object[]{Joiner.on((String)", ").join(args), this.formatOutputs(node.getOutputSymbols())});
            PlanPrinter.this.print(indent + 2, "%s := %s", new Object[]{node.getRowNumberSymbol(), "row_number()"});
            return this.processChildren(node, indent + 1);
        }

        @Override
        public Void visitTableScan(TableScanNode node, Integer indent) {
            TupleDomain<ColumnHandle> partitionsDomainSummary = node.getPartitionsDomainSummary();
            PlanPrinter.this.print(indent, "- TableScan[%s, original constraint=%s] => [%s]", new Object[]{node.getTable(), node.getOriginalConstraint(), this.formatOutputs(node.getOutputSymbols())});
            for (Map.Entry<Symbol, ColumnHandle> entry : node.getAssignments().entrySet()) {
                boolean isInDomainSummary;
                boolean isOutputSymbol = node.getOutputSymbols().contains(entry.getKey());
                boolean isInOriginalConstraint = node.getOriginalConstraint() == null ? false : DependencyExtractor.extractUnique(node.getOriginalConstraint()).contains(entry.getKey());
                boolean bl = isInDomainSummary = !partitionsDomainSummary.isNone() && partitionsDomainSummary.getDomains().keySet().contains(entry.getValue());
                if (!isOutputSymbol && !isInOriginalConstraint && !isInDomainSummary) continue;
                PlanPrinter.this.print(indent + 2, "%s := %s", new Object[]{entry.getKey(), entry.getValue()});
                if (isInDomainSummary) {
                    PlanPrinter.this.print(indent + 3, ":: %s", new Object[]{PlanPrinter.this.formatDomain(node.getTable(), entry.getValue(), DomainUtils.simplifyDomain((Domain)partitionsDomainSummary.getDomains().get(entry.getValue())))});
                    continue;
                }
                if (!partitionsDomainSummary.isNone()) continue;
                PlanPrinter.this.print(indent + 3, ":: NONE", new Object[0]);
            }
            return null;
        }

        @Override
        public Void visitValues(ValuesNode node, Integer indent) {
            PlanPrinter.this.print(indent, "- Values => [%s]", new Object[]{this.formatOutputs(node.getOutputSymbols())});
            for (List<Expression> row : node.getRows()) {
                PlanPrinter.this.print(indent + 2, Joiner.on((String)", ").join(row), new Object[0]);
            }
            return null;
        }

        @Override
        public Void visitFilter(FilterNode node, Integer indent) {
            PlanPrinter.this.print(indent, "- Filter[%s] => [%s]", new Object[]{node.getPredicate(), this.formatOutputs(node.getOutputSymbols())});
            return this.processChildren(node, indent + 1);
        }

        @Override
        public Void visitProject(ProjectNode node, Integer indent) {
            PlanPrinter.this.print(indent, "- Project => [%s]", new Object[]{this.formatOutputs(node.getOutputSymbols())});
            for (Map.Entry<Symbol, Expression> entry : node.getOutputMap().entrySet()) {
                if (entry.getValue() instanceof QualifiedNameReference && ((QualifiedNameReference)entry.getValue()).getName().equals((Object)entry.getKey().toQualifiedName())) continue;
                PlanPrinter.this.print(indent + 2, "%s := %s", new Object[]{entry.getKey(), entry.getValue()});
            }
            return this.processChildren(node, indent + 1);
        }

        @Override
        public Void visitUnnest(UnnestNode node, Integer indent) {
            PlanPrinter.this.print(indent, "- Unnest [replicate=%s, unnest=%s] => [%s]", new Object[]{this.formatOutputs(node.getReplicateSymbols()), this.formatOutputs(node.getUnnestSymbols().keySet()), this.formatOutputs(node.getOutputSymbols())});
            return this.processChildren(node, indent + 1);
        }

        @Override
        public Void visitOutput(OutputNode node, Integer indent) {
            PlanPrinter.this.print(indent, "- Output[%s]", new Object[]{Joiner.on((String)", ").join(node.getColumnNames())});
            for (int i = 0; i < node.getColumnNames().size(); ++i) {
                Symbol symbol;
                String name = node.getColumnNames().get(i);
                if (name.equals((symbol = node.getOutputSymbols().get(i)).toString())) continue;
                PlanPrinter.this.print(indent + 2, "%s := %s", new Object[]{name, symbol});
            }
            return this.processChildren(node, indent + 1);
        }

        @Override
        public Void visitTopN(final TopNNode node, Integer indent) {
            Iterable keys = Iterables.transform(node.getOrderBy(), (Function)new Function<Symbol, String>(){

                public String apply(Symbol input) {
                    return input + " " + node.getOrderings().get(input);
                }
            });
            PlanPrinter.this.print(indent, "- TopN[%s by (%s)] => [%s]", new Object[]{node.getCount(), Joiner.on((String)", ").join(keys), this.formatOutputs(node.getOutputSymbols())});
            return this.processChildren(node, indent + 1);
        }

        @Override
        public Void visitSort(final SortNode node, Integer indent) {
            Iterable keys = Iterables.transform(node.getOrderBy(), (Function)new Function<Symbol, String>(){

                public String apply(Symbol input) {
                    return input + " " + node.getOrderings().get(input);
                }
            });
            PlanPrinter.this.print(indent, "- Sort[%s] => [%s]", new Object[]{Joiner.on((String)", ").join(keys), this.formatOutputs(node.getOutputSymbols())});
            return this.processChildren(node, indent + 1);
        }

        @Override
        public Void visitExchange(ExchangeNode node, Integer indent) {
            PlanPrinter.this.print(indent, "- Exchange[%s] => [%s]", new Object[]{node.getSourceFragmentIds(), this.formatOutputs(node.getOutputSymbols())});
            return this.processExchange(node, indent + 1);
        }

        @Override
        public Void visitSink(SinkNode node, Integer indent) {
            PlanPrinter.this.print(indent, "- Sink[%s] => [%s]", new Object[]{node.getId(), this.formatOutputs(node.getOutputSymbols())});
            return this.processChildren(node, indent + 1);
        }

        @Override
        public Void visitUnion(UnionNode node, Integer indent) {
            PlanPrinter.this.print(indent, "- Union => [%s]", new Object[]{this.formatOutputs(node.getOutputSymbols())});
            return this.processChildren(node, indent + 1);
        }

        @Override
        public Void visitTableWriter(TableWriterNode node, Integer indent) {
            PlanPrinter.this.print(indent, "- TableWriter => [%s]", new Object[]{this.formatOutputs(node.getOutputSymbols())});
            for (int i = 0; i < node.getColumnNames().size(); ++i) {
                String name = node.getColumnNames().get(i);
                Symbol symbol = node.getColumns().get(i);
                PlanPrinter.this.print(indent + 2, "%s := %s", new Object[]{name, symbol});
            }
            return this.processChildren(node, indent + 1);
        }

        @Override
        public Void visitTableCommit(TableCommitNode node, Integer indent) {
            PlanPrinter.this.print(indent, "- TableCommit[%s] => [%s]", new Object[]{node.getTarget(), this.formatOutputs(node.getOutputSymbols())});
            return this.processChildren(node, indent + 1);
        }

        @Override
        public Void visitSample(SampleNode node, Integer indent) {
            PlanPrinter.this.print(indent, "- Sample[%s: %s] => [%s]", new Object[]{node.getSampleType(), node.getSampleRatio(), this.formatOutputs(node.getOutputSymbols())});
            return this.processChildren(node, indent + 1);
        }

        @Override
        protected Void visitPlan(PlanNode node, Integer context) {
            throw new UnsupportedOperationException("not yet implemented: " + node.getClass().getName());
        }

        private Void processChildren(PlanNode node, int indent) {
            for (PlanNode child : node.getSources()) {
                child.accept(this, indent);
            }
            return null;
        }

        private Void processExchange(ExchangeNode node, int indent) {
            for (PlanFragmentId planFragmentId : node.getSourceFragmentIds()) {
                PlanFragment target = (PlanFragment)((Map)this.fragmentsById.get()).get(planFragmentId);
                target.getRoot().accept(new Visitor(target.getSymbols(), this.fragmentsById), indent);
            }
            return null;
        }

        private String formatOutputs(Iterable<Symbol> symbols) {
            return Joiner.on((String)", ").join(Iterables.transform(symbols, (Function)new Function<Symbol, String>(){

                public String apply(Symbol input) {
                    return input + ":" + Visitor.this.types.get(input);
                }
            }));
        }
    }
}

