/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.index.IndexManager;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.split.SplitManager;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.optimizations.CanonicalizeExpressions;
import com.facebook.presto.sql.planner.optimizations.CountConstantOptimizer;
import com.facebook.presto.sql.planner.optimizations.ImplementSampleAsFilter;
import com.facebook.presto.sql.planner.optimizations.IndexJoinOptimizer;
import com.facebook.presto.sql.planner.optimizations.LimitPushDown;
import com.facebook.presto.sql.planner.optimizations.MergeProjections;
import com.facebook.presto.sql.planner.optimizations.MetadataQueryOptimizer;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.planner.optimizations.PredicatePushDown;
import com.facebook.presto.sql.planner.optimizations.PruneRedundantProjections;
import com.facebook.presto.sql.planner.optimizations.PruneUnreferencedOutputs;
import com.facebook.presto.sql.planner.optimizations.SetFlatteningOptimizer;
import com.facebook.presto.sql.planner.optimizations.SimplifyExpressions;
import com.facebook.presto.sql.planner.optimizations.UnaliasSymbolReferences;
import com.facebook.presto.sql.planner.optimizations.WindowFilterPushDown;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import java.util.List;
import javax.inject.Provider;

public class PlanOptimizersFactory
implements Provider<List<PlanOptimizer>> {
    private final List<PlanOptimizer> optimizers;

    @Inject
    public PlanOptimizersFactory(Metadata metadata, SqlParser sqlParser, SplitManager splitManager, IndexManager indexManager, FeaturesConfig featuresConfig) {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object[])new PlanOptimizer[]{new ImplementSampleAsFilter(), new CanonicalizeExpressions(), new SimplifyExpressions(metadata, sqlParser), new UnaliasSymbolReferences(), new PruneRedundantProjections(), new SetFlatteningOptimizer(), new LimitPushDown(), new PredicatePushDown(metadata, sqlParser, splitManager, featuresConfig.isExperimentalSyntaxEnabled()), new PredicatePushDown(metadata, sqlParser, splitManager, featuresConfig.isExperimentalSyntaxEnabled()), new MergeProjections(), new SimplifyExpressions(metadata, sqlParser), new UnaliasSymbolReferences(), new IndexJoinOptimizer(indexManager), new CountConstantOptimizer(), new WindowFilterPushDown(), new PruneUnreferencedOutputs(), new PruneRedundantProjections()});
        if (featuresConfig.isOptimizeMetadataQueries()) {
            builder.add((Object)new MetadataQueryOptimizer(metadata, splitManager));
        }
        this.optimizers = builder.build();
    }

    public synchronized List<PlanOptimizer> get() {
        return this.optimizers;
    }
}

