/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.sql.analyzer.FieldOrExpression;
import com.facebook.presto.sql.planner.RelationPlan;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.TranslationMap;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.tree.Expression;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;

class PlanBuilder {
    private final TranslationMap translations;
    private final PlanNode root;
    private final Optional<Symbol> sampleWeight;

    public PlanBuilder(TranslationMap translations, PlanNode root, Optional<Symbol> sampleWeight) {
        Preconditions.checkNotNull((Object)translations, (Object)"translations is null");
        Preconditions.checkNotNull((Object)root, (Object)"root is null");
        Preconditions.checkNotNull(sampleWeight, (Object)"sampleWeight is null");
        this.translations = translations;
        this.root = root;
        this.sampleWeight = sampleWeight;
    }

    public Optional<Symbol> getSampleWeight() {
        return this.sampleWeight;
    }

    public RelationPlan getRelationPlan() {
        return this.translations.getRelationPlan();
    }

    public PlanNode getRoot() {
        return this.root;
    }

    public Symbol translate(Expression expression) {
        return this.translations.get(expression);
    }

    public Symbol translate(FieldOrExpression fieldOrExpression) {
        return this.translations.get(fieldOrExpression);
    }

    public Expression rewrite(Expression expression) {
        return this.translations.rewrite(expression);
    }

    public Expression rewrite(FieldOrExpression fieldOrExpression) {
        return this.translations.rewrite(fieldOrExpression);
    }

    public TranslationMap getTranslations() {
        return this.translations;
    }
}

