/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.metadata.FunctionInfo;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.sql.analyzer.SemanticErrorCode;
import com.facebook.presto.sql.analyzer.SemanticException;
import com.facebook.presto.sql.planner.ExpressionInterpreter;
import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.BooleanLiteral;
import com.facebook.presto.sql.tree.Cast;
import com.facebook.presto.sql.tree.DoubleLiteral;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.GenericLiteral;
import com.facebook.presto.sql.tree.IntervalLiteral;
import com.facebook.presto.sql.tree.Literal;
import com.facebook.presto.sql.tree.LongLiteral;
import com.facebook.presto.sql.tree.NegativeExpression;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NullLiteral;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.StringLiteral;
import com.facebook.presto.sql.tree.TimeLiteral;
import com.facebook.presto.sql.tree.TimestampLiteral;
import com.facebook.presto.util.DateTimeUtils;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.util.List;

public final class LiteralInterpreter {
    private LiteralInterpreter() {
    }

    public static Object evaluate(Metadata metadata, ConnectorSession session, Expression node) {
        if (!(node instanceof Literal)) {
            throw new IllegalArgumentException("node must be a Literal");
        }
        return new LiteralVisitor(metadata).process((Node)node, session);
    }

    public static List<Expression> toExpressions(List<?> objects, List<? extends Type> types) {
        Preconditions.checkNotNull(objects, (Object)"objects is null");
        Preconditions.checkNotNull(types, (Object)"types is null");
        Preconditions.checkArgument((objects.size() == types.size() ? 1 : 0) != 0, (Object)"objects and types do not have the same size");
        ImmutableList.Builder expressions = ImmutableList.builder();
        for (int i = 0; i < objects.size(); ++i) {
            Object object = objects.get(i);
            Type type = types.get(i);
            expressions.add((Object)LiteralInterpreter.toExpression(object, type));
        }
        return expressions.build();
    }

    public static Expression toExpression(Object object, Type type) {
        if (object instanceof Expression) {
            return (Expression)object;
        }
        if (object == null) {
            return new Cast((Expression)new NullLiteral(), type.getTypeSignature().toString());
        }
        if (type.equals(BigintType.BIGINT)) {
            return new LongLiteral(object.toString());
        }
        if (type.equals(DoubleType.DOUBLE)) {
            Double value = (Double)object;
            if (value.isNaN()) {
                return new FunctionCall(new QualifiedName("nan"), (List)ImmutableList.of());
            }
            if (value == Double.NEGATIVE_INFINITY) {
                return new NegativeExpression((Expression)new FunctionCall(new QualifiedName("infinity"), (List)ImmutableList.of()));
            }
            if (value == Double.POSITIVE_INFINITY) {
                return new FunctionCall(new QualifiedName("infinity"), (List)ImmutableList.of());
            }
            return new DoubleLiteral(object.toString());
        }
        if (type.equals(VarcharType.VARCHAR)) {
            if (object instanceof Slice) {
                return new StringLiteral(((Slice)object).toString(Charsets.UTF_8));
            }
            if (object instanceof String) {
                return new StringLiteral((String)object);
            }
        }
        if (type.equals(BooleanType.BOOLEAN)) {
            return new BooleanLiteral(object.toString());
        }
        Signature signature = FunctionRegistry.getMagicLiteralFunctionSignature(type);
        Expression rawLiteral = LiteralInterpreter.toExpression(object, FunctionRegistry.type(type.getJavaType()));
        return new FunctionCall(new QualifiedName(signature.getName()), (List)ImmutableList.of((Object)rawLiteral));
    }

    private static class LiteralVisitor
    extends AstVisitor<Object, ConnectorSession> {
        private final Metadata metadata;

        private LiteralVisitor(Metadata metadata) {
            this.metadata = metadata;
        }

        protected Object visitLiteral(Literal node, ConnectorSession session) {
            throw new UnsupportedOperationException("Unhandled literal type: " + node);
        }

        protected Object visitBooleanLiteral(BooleanLiteral node, ConnectorSession session) {
            return node.getValue();
        }

        protected Long visitLongLiteral(LongLiteral node, ConnectorSession session) {
            return node.getValue();
        }

        protected Double visitDoubleLiteral(DoubleLiteral node, ConnectorSession session) {
            return node.getValue();
        }

        protected Slice visitStringLiteral(StringLiteral node, ConnectorSession session) {
            return node.getSlice();
        }

        protected Object visitGenericLiteral(GenericLiteral node, ConnectorSession session) {
            FunctionInfo operator;
            Type type = this.metadata.getType(TypeSignature.parseTypeSignature((String)node.getType()));
            if (type == null) {
                throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)node, "Unknown type: " + node.getType(), new Object[0]);
            }
            try {
                operator = this.metadata.getFunctionRegistry().getCoercion((Type)VarcharType.VARCHAR, type);
            }
            catch (IllegalArgumentException e) {
                throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)node, "No literal form for type %s", type);
            }
            try {
                return ExpressionInterpreter.invoke(session, operator.getMethodHandle(), (List<Object>)ImmutableList.of((Object)Slices.utf8Slice((String)node.getValue())));
            }
            catch (Throwable throwable) {
                throw Throwables.propagate((Throwable)throwable);
            }
        }

        protected Long visitTimeLiteral(TimeLiteral node, ConnectorSession session) {
            return DateTimeUtils.parseTime(session.getTimeZoneKey(), node.getValue());
        }

        protected Long visitTimestampLiteral(TimestampLiteral node, ConnectorSession session) {
            return DateTimeUtils.parseTimestamp(session.getTimeZoneKey(), node.getValue());
        }

        protected Long visitIntervalLiteral(IntervalLiteral node, ConnectorSession session) {
            if (node.isYearToMonth()) {
                return (long)node.getSign().multiplier() * DateTimeUtils.parseYearMonthInterval(node.getValue(), node.getStartField(), node.getEndField());
            }
            return (long)node.getSign().multiplier() * DateTimeUtils.parseDayTimeInterval(node.getValue(), node.getStartField(), node.getEndField());
        }

        protected Object visitNullLiteral(NullLiteral node, ConnectorSession session) {
            return null;
        }
    }
}

