/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.gen;

import com.facebook.presto.byteCode.Block;
import com.facebook.presto.byteCode.ByteCodeNode;
import com.facebook.presto.byteCode.CompilerContext;
import com.facebook.presto.byteCode.OpCode;
import com.facebook.presto.byteCode.Variable;
import com.facebook.presto.byteCode.control.IfStatement;
import com.facebook.presto.byteCode.control.LookupSwitch;
import com.facebook.presto.byteCode.instruction.JumpInstruction;
import com.facebook.presto.byteCode.instruction.LabelNode;
import com.facebook.presto.metadata.FunctionInfo;
import com.facebook.presto.metadata.OperatorType;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.gen.Binding;
import com.facebook.presto.sql.gen.ByteCodeGenerator;
import com.facebook.presto.sql.gen.ByteCodeGeneratorContext;
import com.facebook.presto.sql.gen.ByteCodeUtils;
import com.facebook.presto.sql.gen.CompilerOperations;
import com.facebook.presto.sql.relational.ConstantExpression;
import com.facebook.presto.sql.relational.RowExpression;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class InCodeGenerator
implements ByteCodeGenerator {
    @Override
    public ByteCodeNode generateExpression(Signature signature, ByteCodeGeneratorContext generatorContext, Type returnType, List<RowExpression> arguments) {
        Block switchBlock;
        ByteCodeNode value = generatorContext.generate(arguments.get(0));
        List<RowExpression> values = arguments.subList(1, arguments.size());
        ImmutableList.Builder valuesByteCode = ImmutableList.builder();
        for (int i = 1; i < arguments.size(); ++i) {
            ByteCodeNode testNode = generatorContext.generate(arguments.get(i));
            valuesByteCode.add((Object)testNode);
        }
        Type type = arguments.get(0).getType();
        Class javaType = type.getJavaType();
        FunctionInfo hashCodeFunction = generatorContext.getRegistry().resolveOperator(OperatorType.HASH_CODE, (List<? extends Type>)ImmutableList.of((Object)type));
        ImmutableListMultimap.Builder hashBucketsBuilder = ImmutableListMultimap.builder();
        ImmutableList.Builder defaultBucket = ImmutableList.builder();
        ImmutableSet.Builder constantValuesBuilder = ImmutableSet.builder();
        for (RowExpression testValue : values) {
            ByteCodeNode testByteCode = generatorContext.generate(testValue);
            if (testValue instanceof ConstantExpression && ((ConstantExpression)testValue).getValue() != null) {
                ConstantExpression constant = (ConstantExpression)testValue;
                Object object = constant.getValue();
                constantValuesBuilder.add(object);
                try {
                    int hashCode = hashCodeFunction.getMethodHandle().invoke(object).intValue();
                    hashBucketsBuilder.put((Object)hashCode, (Object)testByteCode);
                    continue;
                }
                catch (Throwable throwable) {
                    throw new IllegalArgumentException("Error processing IN statement: error calculating hash code for " + object, throwable);
                }
            }
            defaultBucket.add((Object)testByteCode);
        }
        ImmutableListMultimap hashBuckets = hashBucketsBuilder.build();
        ImmutableSet constantValues = constantValuesBuilder.build();
        LabelNode end = new LabelNode("end");
        LabelNode match = new LabelNode("match");
        LabelNode noMatch = new LabelNode("noMatch");
        LabelNode defaultLabel = new LabelNode("default");
        CompilerContext context = generatorContext.getContext();
        if (constantValues.size() < 1000) {
            Block switchCaseBlocks = new Block(context);
            LookupSwitch.LookupSwitchBuilder switchBuilder = LookupSwitch.lookupSwitchBuilder();
            for (Map.Entry bucket : hashBuckets.asMap().entrySet()) {
                LabelNode label = new LabelNode("inHash" + bucket.getKey());
                switchBuilder.addCase((Integer)bucket.getKey(), label);
                Collection testValues = (Collection)bucket.getValue();
                Block caseBlock = this.buildInCase(generatorContext, context, type, label, match, defaultLabel, testValues, false);
                switchCaseBlocks.append(caseBlock.setDescription("case " + bucket.getKey()));
            }
            switchBuilder.defaultCase(defaultLabel);
            Binding hashCodeBinding = generatorContext.getCallSiteBinder().bind(hashCodeFunction.getMethodHandle());
            switchBlock = new Block(context).comment("lookupSwitch(hashCode(<stackValue>))").dup(javaType).append(ByteCodeUtils.invoke(generatorContext.getContext(), hashCodeBinding, hashCodeFunction.getSignature())).longToInt().append(switchBuilder.build()).append(switchCaseBlocks);
        } else {
            Binding constant = generatorContext.getCallSiteBinder().bind(constantValues, Set.class);
            switchBlock = new Block(context).comment("inListSet.contains(<stackValue>)").append(new IfStatement(context, new Block(context).comment("value (+boxing if necessary)").dup(javaType).append(ByteCodeUtils.boxPrimitive(context, javaType)).comment("set").append(ByteCodeUtils.loadConstant(context, constant)).invokeStatic(CompilerOperations.class, "in", Boolean.TYPE, Object.class, Set.class), JumpInstruction.jump(match), OpCode.NOP));
        }
        Block defaultCaseBlock = this.buildInCase(generatorContext, context, type, defaultLabel, match, noMatch, (Collection<ByteCodeNode>)defaultBucket.build(), true).setDescription("default");
        Block block = new Block(context).comment("IN").append(value).append(ByteCodeUtils.ifWasNullPopAndGoto(context, end, Boolean.TYPE, javaType)).append(switchBlock).append(defaultCaseBlock);
        Block matchBlock = new Block(context).setDescription("match").visitLabel(match).pop(javaType).putVariable("wasNull", false).push(true).gotoLabel(end);
        block.append(matchBlock);
        Block noMatchBlock = new Block(context).setDescription("noMatch").visitLabel(noMatch).pop(javaType).push(false).gotoLabel(end);
        block.append(noMatchBlock);
        block.visitLabel(end);
        return block;
    }

    private Block buildInCase(ByteCodeGeneratorContext generatorContext, CompilerContext context, Type type, LabelNode caseLabel, LabelNode matchLabel, LabelNode noMatchLabel, Collection<ByteCodeNode> testValues, boolean checkForNulls) {
        Variable caseWasNull = null;
        if (checkForNulls) {
            caseWasNull = context.createTempVariable(Boolean.TYPE);
        }
        Block caseBlock = new Block(context).visitLabel(caseLabel);
        if (checkForNulls) {
            caseBlock.putVariable(caseWasNull, false);
        }
        LabelNode elseLabel = new LabelNode("else");
        Block elseBlock = new Block(context).visitLabel(elseLabel);
        if (checkForNulls) {
            elseBlock.getVariable(caseWasNull).putVariable("wasNull");
        }
        elseBlock.gotoLabel(noMatchLabel);
        FunctionInfo operator = generatorContext.getRegistry().resolveOperator(OperatorType.EQUAL, (List<? extends Type>)ImmutableList.of((Object)type, (Object)type));
        Binding equalsFunction = generatorContext.getCallSiteBinder().bind(operator.getMethodHandle());
        ByteCodeNode elseNode = elseBlock;
        for (ByteCodeNode testNode : testValues) {
            LabelNode testLabel = new LabelNode("test");
            IfStatement.IfStatementBuilder test = IfStatement.ifStatementBuilder(context);
            Block condition = new Block(context).visitLabel(testLabel).dup(type.getJavaType()).append(testNode);
            if (checkForNulls) {
                condition.getVariable("wasNull").putVariable(caseWasNull).append(ByteCodeUtils.ifWasNullPopAndGoto(context, elseLabel, Void.TYPE, type.getJavaType(), type.getJavaType()));
            }
            condition.append(ByteCodeUtils.invoke(generatorContext.getContext(), equalsFunction, operator.getSignature()));
            test.condition(condition);
            test.ifTrue(new Block(context).gotoLabel(matchLabel));
            test.ifFalse(elseNode);
            elseNode = test.build();
            elseLabel = testLabel;
        }
        caseBlock.append(elseNode);
        return caseBlock;
    }
}

