/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.analyzer;

import com.facebook.presto.sql.tree.Expression;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import javax.annotation.Nullable;

public class FieldOrExpression {
    private final Optional<Integer> fieldIndex;
    private final Optional<Expression> expression;

    public FieldOrExpression(int fieldIndex) {
        this.fieldIndex = Optional.of((Object)fieldIndex);
        this.expression = Optional.absent();
    }

    public FieldOrExpression(Expression expression) {
        Preconditions.checkNotNull((Object)expression, (Object)"expression is null");
        this.fieldIndex = Optional.absent();
        this.expression = Optional.of((Object)expression);
    }

    public boolean isFieldReference() {
        return this.fieldIndex.isPresent();
    }

    public int getFieldIndex() {
        Preconditions.checkState((boolean)this.isFieldReference(), (Object)"Not a field reference");
        return (Integer)this.fieldIndex.get();
    }

    public boolean isExpression() {
        return this.expression.isPresent();
    }

    public Expression getExpression() {
        Preconditions.checkState((boolean)this.isExpression(), (Object)"Not an expression");
        return (Expression)this.expression.get();
    }

    public String toString() {
        if (this.fieldIndex.isPresent()) {
            return ((Integer)this.fieldIndex.get()).toString();
        }
        return ((Expression)this.expression.get()).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FieldOrExpression that = (FieldOrExpression)o;
        if (!this.expression.equals(that.expression)) {
            return false;
        }
        return this.fieldIndex.equals(that.fieldIndex);
    }

    public int hashCode() {
        int result = this.fieldIndex.hashCode();
        result = 31 * result + this.expression.hashCode();
        return result;
    }

    public static Predicate<FieldOrExpression> isFieldReferencePredicate() {
        return new Predicate<FieldOrExpression>(){

            public boolean apply(@Nullable FieldOrExpression input) {
                return input.isFieldReference();
            }
        };
    }

    public static Predicate<FieldOrExpression> isExpressionPredicate() {
        return new Predicate<FieldOrExpression>(){

            public boolean apply(@Nullable FieldOrExpression input) {
                return input.isExpression();
            }
        };
    }

    public static Function<FieldOrExpression, Integer> fieldIndexGetter() {
        return new Function<FieldOrExpression, Integer>(){

            public Integer apply(FieldOrExpression input) {
                return input.getFieldIndex();
            }
        };
    }

    public static Function<FieldOrExpression, Expression> expressionGetter() {
        return new Function<FieldOrExpression, Expression>(){

            public Expression apply(FieldOrExpression input) {
                return input.getExpression();
            }
        };
    }
}

