/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.window;

import com.facebook.presto.metadata.Signature;
import com.facebook.presto.operator.Description;
import com.facebook.presto.operator.window.AbstractWindowFunctionSupplier;
import com.facebook.presto.operator.window.WindowFunction;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.type.TypeUtils;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;

public class ReflectionWindowFunctionSupplier<T extends WindowFunction>
extends AbstractWindowFunctionSupplier {
    private final Constructor<T> constructor;

    public ReflectionWindowFunctionSupplier(String name, Type returnType, List<? extends Type> argumentTypes, Class<T> type) {
        this(new Signature(name, returnType.getTypeSignature(), Lists.transform(argumentTypes, TypeUtils.typeSignatureGetter())), type);
    }

    public ReflectionWindowFunctionSupplier(Signature signature, Class<T> type) {
        super(signature, ReflectionWindowFunctionSupplier.getDescription((AnnotatedElement)Preconditions.checkNotNull(type, (Object)"type is null")));
        try {
            this.constructor = signature.getArgumentTypes().isEmpty() ? type.getConstructor(new Class[0]) : type.getConstructor(List.class);
        }
        catch (NoSuchMethodException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    protected T newWindowFunction(List<Integer> inputs) {
        try {
            if (this.getSignature().getArgumentTypes().isEmpty()) {
                return (T)((WindowFunction)this.constructor.newInstance(new Object[0]));
            }
            return (T)((WindowFunction)this.constructor.newInstance(inputs));
        }
        catch (InvocationTargetException e) {
            throw Throwables.propagate((Throwable)e.getCause());
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private static String getDescription(AnnotatedElement annotatedElement) {
        Description description = annotatedElement.getAnnotation(Description.class);
        return description == null ? null : description.value();
    }
}

