/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.window;

import com.facebook.presto.operator.PagesIndex;
import com.facebook.presto.operator.window.WindowFunction;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.util.Failures;
import com.google.common.primitives.Ints;
import java.util.List;

public class NthValueFunction
implements WindowFunction {
    private final Type type;
    private final int valueChannel;
    private final int offsetChannel;
    private int partitionStartPosition;
    private int currentPosition;
    private int partitionRowCount;
    private PagesIndex pagesIndex;

    protected NthValueFunction(Type type, List<Integer> argumentChannels) {
        this.type = type;
        this.valueChannel = argumentChannels.get(0);
        this.offsetChannel = argumentChannels.get(1);
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public void reset(int partitionStartPosition, int partitionRowCount, PagesIndex pagesIndex) {
        this.partitionStartPosition = partitionStartPosition;
        this.currentPosition = partitionStartPosition;
        this.partitionRowCount = partitionRowCount;
        this.pagesIndex = pagesIndex;
    }

    @Override
    public void processRow(BlockBuilder output, boolean newPeerGroup, int peerGroupCount) {
        if (this.pagesIndex.isNull(this.offsetChannel, this.currentPosition)) {
            output.appendNull();
            return;
        }
        int offset = Ints.checkedCast((long)this.pagesIndex.getLong(this.offsetChannel, this.currentPosition));
        Failures.checkCondition(offset >= 1, (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Offset must be at least 1", new Object[0]);
        int valuePosition = this.partitionStartPosition + offset - 1;
        if (valuePosition >= this.partitionStartPosition + this.partitionRowCount) {
            output.appendNull();
            return;
        }
        this.pagesIndex.appendTo(this.valueChannel, valuePosition, output);
        ++this.currentPosition;
    }

    public static class VarcharNthValueFunction
    extends NthValueFunction {
        public VarcharNthValueFunction(List<Integer> argumentChannels) {
            super((Type)VarcharType.VARCHAR, argumentChannels);
        }
    }

    public static class DoubleNthValueFunction
    extends NthValueFunction {
        public DoubleNthValueFunction(List<Integer> argumentChannels) {
            super((Type)DoubleType.DOUBLE, argumentChannels);
        }
    }

    public static class BooleanNthValueFunction
    extends NthValueFunction {
        public BooleanNthValueFunction(List<Integer> argumentChannels) {
            super((Type)BooleanType.BOOLEAN, argumentChannels);
        }
    }

    public static class BigintNthValueFunction
    extends NthValueFunction {
        public BigintNthValueFunction(List<Integer> argumentChannels) {
            super((Type)BigintType.BIGINT, argumentChannels);
        }
    }
}

