/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.window;

import com.facebook.presto.operator.PagesIndex;
import com.facebook.presto.operator.window.WindowFunction;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.google.common.collect.Iterables;
import java.util.List;

public class LastValueFunction
implements WindowFunction {
    private final Type type;
    private final int argumentChannel;
    private PagesIndex pagesIndex;
    private int valuePosition;

    protected LastValueFunction(Type type, List<Integer> argumentChannels) {
        this.type = type;
        this.argumentChannel = (Integer)Iterables.getOnlyElement(argumentChannels);
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public void reset(int partitionStartPosition, int partitionRowCount, PagesIndex pagesIndex) {
        this.pagesIndex = pagesIndex;
        this.valuePosition = partitionStartPosition + partitionRowCount - 1;
    }

    @Override
    public void processRow(BlockBuilder output, boolean newPeerGroup, int peerGroupCount) {
        this.pagesIndex.appendTo(this.argumentChannel, this.valuePosition, output);
    }

    public static class VarcharLastValueFunction
    extends LastValueFunction {
        public VarcharLastValueFunction(List<Integer> argumentChannels) {
            super((Type)VarcharType.VARCHAR, argumentChannels);
        }
    }

    public static class DoubleLastValueFunction
    extends LastValueFunction {
        public DoubleLastValueFunction(List<Integer> argumentChannels) {
            super((Type)DoubleType.DOUBLE, argumentChannels);
        }
    }

    public static class BooleanLastValueFunction
    extends LastValueFunction {
        public BooleanLastValueFunction(List<Integer> argumentChannels) {
            super((Type)BooleanType.BOOLEAN, argumentChannels);
        }
    }

    public static class BigintLastValueFunction
    extends LastValueFunction {
        public BigintLastValueFunction(List<Integer> argumentChannels) {
            super((Type)BigintType.BIGINT, argumentChannels);
        }
    }
}

