/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.window;

import com.facebook.presto.operator.PagesIndex;
import com.facebook.presto.operator.window.WindowFunction;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.util.Failures;
import com.google.common.primitives.Ints;
import java.util.List;

public class LagFunction
implements WindowFunction {
    private final Type type;
    private final int valueChannel;
    private final int offsetChannel;
    private final int defaultChannel;
    private int partitionStartPosition;
    private int currentPosition;
    private PagesIndex pagesIndex;

    protected LagFunction(Type type, List<Integer> argumentChannels) {
        this.type = type;
        this.valueChannel = argumentChannels.get(0);
        this.offsetChannel = argumentChannels.size() > 1 ? argumentChannels.get(1) : -1;
        this.defaultChannel = argumentChannels.size() > 2 ? argumentChannels.get(2) : -1;
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public void reset(int partitionStartPosition, int partitionRowCount, PagesIndex pagesIndex) {
        this.partitionStartPosition = partitionStartPosition;
        this.currentPosition = partitionStartPosition;
        this.pagesIndex = pagesIndex;
    }

    @Override
    public void processRow(BlockBuilder output, boolean newPeerGroup, int peerGroupCount) {
        int offset = this.offsetChannel < 0 ? 1 : Ints.checkedCast((long)this.pagesIndex.getLong(this.offsetChannel, this.currentPosition));
        Failures.checkCondition(offset >= 0, (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Offset must be at least 0", new Object[0]);
        int valuePosition = this.currentPosition - offset;
        if (valuePosition >= this.partitionStartPosition) {
            this.pagesIndex.appendTo(this.valueChannel, valuePosition, output);
        } else if (this.defaultChannel < 0) {
            output.appendNull();
        } else {
            this.pagesIndex.appendTo(this.defaultChannel, this.currentPosition, output);
        }
        ++this.currentPosition;
    }

    public static class VarcharLagFunction
    extends LagFunction {
        public VarcharLagFunction(List<Integer> argumentChannels) {
            super((Type)VarcharType.VARCHAR, argumentChannels);
        }
    }

    public static class DoubleLagFunction
    extends LagFunction {
        public DoubleLagFunction(List<Integer> argumentChannels) {
            super((Type)DoubleType.DOUBLE, argumentChannels);
        }
    }

    public static class BooleanLagFunction
    extends LagFunction {
        public BooleanLagFunction(List<Integer> argumentChannels) {
            super((Type)BooleanType.BOOLEAN, argumentChannels);
        }
    }

    public static class BigintLagFunction
    extends LagFunction {
        public BigintLagFunction(List<Integer> argumentChannels) {
            super((Type)BigintType.BIGINT, argumentChannels);
        }
    }
}

